#! /usr/bin/perl
# record.pl: Ͽץ
# 							sako shinji
#
# $Id: record.pl,v 1.2 2006/10/16 03:57:59 sako Exp $
#
$| = 1;
use File::Basename;

#  ǡϿѥץ ver 2.0
#
#               ver.1.0  2003 05/18  HOSSY
#               ver.1.1  2004/08/11  sako shinji
#               ver.1.2  2004/09/09  sako shinji
#
#               ver.2.0  2005/08/03  sako shinji
#               ver.2.1  2006/03/14  sako shinji
#               ver.2.2  2006/08/01  sako shinji
#
# եΥѥ
$script_base = dirname( $0);
require $script_base . "/config.pl";
#
# ѥץ벻ǡ
#

# ʸϥǡ
$sentence_file = "${database}/${dataset}/sentence.txt";
# ץ벻
$samplepath = "${database}/${dataset}/speech";

# juliusΥѥ
$juliusbin = "${julius_dickit}/bin";

# Ͽǡ¸
$outpath = "${recdir}";

# julius °ġϿ
# * ǡ16000Hz, 16bit-short, big-endian, إåʤ
# Υޡ400ߥäȤڤФ(adinrecεǽ)
$record_command = "${juliusbin}/adinrec -lv 1000 -raw -freq 16000 -margin 400 ";
# play (sox)ޥɤǺ
# ΥեޥåȤꤷƺ
$play_command = "play -x -c 1 -r 16000 -f s -s w -t raw ";

# ǥ쥯ȥκ
if ( "${outpath}" ne "") {
	system "mkdir -p $outpath" || die "ǥ쥯ȥǤޤ ($outpath)";
}

sub help{
    print STDERR "\n [ Ȥ ]\n";
    print STDERR "  % θ˥ޥ\n";
    print STDERR "  l   : Ͽʹ\n";
    print STDERR "  r   : Ͽľ\n";
#    print STDERR "  R   : Ͽľ(̵)\n";
    print STDERR "  t   : ܤʹľ\n";
    print STDERR "  b   : ʸ\n";
    print STDERR "  n   : ʸؿʤ\n";
    print STDERR "  m X : ʸ X ذư:m b01\n";
    print STDERR "  h   : Υå\n";
    print STDERR "  q   : λ\n";
    print STDERR "\n";
}

# κ
sub raw_play{
    my $audiofile = $_[0];
    if( -s "${audiofile}" ){
	system "$play_command ${audiofile} 2>/dev/null";
    }
    else{
        print STDERR "ERROR: ǡޤ ($audiofile)\n";
    }
}

# Ͽ
sub raw_record{
    my $audiofile = $_[0];
    system "${record_command} ${audiofile}";
    if( -s "${audiofile}" ){
	;
    }
    else{
	print STDERR "ERROR: Ͽ˼Ԥޤ ($audiofile)\n";
    }
}

# 
sub readfile{
    my $inputfile = $_[0];
    my @tmp_list=();
    
    open(TXT,$inputfile) || die "ERROR: ե򳫤ޤ ($inputfile)\n";
    while(<TXT>){
        chomp;
        split ':';
        push @tmp_list, {"num", $_[0], "kanji", $_[1], "kana", $_[2]};
    }
    close(TXT);
    
    return @tmp_list;
}

#
sub recinfo{
    my $t_num = $_[0];
    my $t_kanji = $_[1];
    my $t_kana = $_[2];
    
    print "\n\[${t_num}\]";
    if( -s "${outpath}/${t_num}.ad"){
	# եι
	my @file_stat = stat( "${outpath}/${t_num}.ad");
	my $mtime = localtime( $file_stat[9]); 
	print " *Ͽ  ${outpath}/${t_num}.ad ($mtime)\n\n";
    }
    else{
	print " *̤Ͽ\n\n";
    }
    # ɤ߾夲ʸϤɽ
    if( $t_kana )  {print "      $t_kana\n";}
    if( $t_kanji ) {print "      $t_kanji\n";}

    print("\n");
}

# 
@textset = readfile( $sentence_file);

#ɤ߹
my $start;
if(@ARGV==0){
    $start = 0;
}
elsif(@ARGV==1){
    chomp($ARGV[0]);

    for( my $j = 0; $j < $#textset; $j++){
	if( $textset[$j]{"num"} eq $ARGV[0]){
	    $start = $j;
	}
    }
}



$i = $start;

while(){
    my $num = $textset[$i]{"num"};
    my $kanji = $textset[$i]{"kanji"};
    my $kana = $textset[$i]{"kana"};
    my $outputfile =  "${outpath}/${num}.ad";
    my $samplefile =  "${samplepath}/${num}.ad";

    recinfo( $num, $kanji, $kana);

    print "% ";
    $input = <STDIN>;

# help    
    if( $input eq ""){
	if( -s $outputfile){
	    $input = "n\n";
	}
	else{
	    $input = "r";
	}
    }
    if($input=~/^h/){
	help;
    }
# Ͽ	      
    elsif($input=~/^l/){
	# 
	raw_play( $outputfile);
    }
# Ͽ
    elsif($input=~/^r/){
	# 
	raw_play( $samplefile);
	raw_record( $outputfile);
    }
#
    elsif($input=~/^t/){
	# 
	raw_play( $samplefile);
    }
# ʸϤ
    elsif($input=~/^[bB]/){
	$i-=1;
	if( $i < 0){
	    $i=0;
	}
    }
# λ
    elsif($input=~/^[qQ]/){
	printf "\nλޤ\n";
	exit 0;
    }
# ʸϤ
    elsif($input=~/^n/){
	$i=$i+1;
	if( $i > $#textset){
	    $i = $#textset;
	}
    }
# ʸϤذư	      
    elsif($input=~/^m /){
	$moveto = $';
	chomp($moveto);
	my $j=0;
        for ($j=0; $j<$#textset; $j++){
	    if( $textset[$j]{"num"} eq $moveto){
		$i = $j;
		next;
	    }
	}
    }
}

print "\nλޤ\n";
