/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlGrammar</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="grammar">
 *       <optional>
 *         <attribute name="tag-format">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="version">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="lang">
 *           <data type="language"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="space">
 *           <choice>
 *             <value>default</value>
 *             <value>preserve</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="src">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="type">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="root">
 *           <data type="IDREF"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="mode">
 *           <choice>
 *             <value type="NMTOKEN">voice</value>
 *             <value type="NMTOKEN">dtmf</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <zeroOrMore>
 *         <choice>
 *           <ref name="alias"/>
 *           <ref name="meta-srgs"/>
 *           <ref name="rule"/>
 *           <ref name="lexicon"/>
 *         </choice>
 *       </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="grammar"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="tag-format"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="version"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="lang"&gt;
 *           &lt;data type="language"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="space"&gt;
 *           &lt;choice&gt;
 *             &lt;value&gt;default&lt;/value&gt;
 *             &lt;value&gt;preserve&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="src"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="type"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="root"&gt;
 *           &lt;data type="IDREF"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="mode"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;voice&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;dtmf&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;zeroOrMore&gt;
 *         &lt;choice&gt;
 *           &lt;ref name="alias"/&gt;
 *           &lt;ref name="meta-srgs"/&gt;
 *           &lt;ref name="rule"/&gt;
 *           &lt;ref name="lexicon"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Wed Jul 07 07:19:10 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlGrammar implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlVxmlChoice, IVxmlChoiceMixed, IVxmlChoiceMixedChoice, IVxmlRecordMixed, IVxmlRecordMixedChoice, IVxmlTransferMixed, IVxmlTransferMixedChoice, IVxmlFormChoice, IVxmlFieldMixed, IVxmlFieldMixedChoice {
    public static final String SPACE_DEFAULT = "default";
    public static final String SPACE_PRESERVE = "preserve";
    public static final String MODE_VOICE = "voice";
    public static final String MODE_DTMF = "dtmf";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String tagFormat_;
    private String version_;
    private java.util.Locale lang_;
    private String space_;
    private String src_;
    private String type_;
    private String root_;
    private String mode_;
    // List<IVxmlGrammarChoice>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlGrammar</code>.
     *
     */
    public VxmlGrammar() {
    }

    /**
     * Creates a <code>VxmlGrammar</code>.
     *
     * @param source
     */
    public VxmlGrammar(VxmlGrammar source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlGrammar</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlGrammar(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlGrammar</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlGrammar(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlGrammar</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlGrammar(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlGrammar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlGrammar(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlGrammar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlGrammar(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlGrammar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlGrammar(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlGrammar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlGrammar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlGrammar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlGrammar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlGrammar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlGrammar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlGrammar</code> by the VxmlGrammar <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlGrammar source) {
        int size;
        tagFormat_ = source.tagFormat_;
        version_ = source.version_;
        lang_ = source.lang_;
        space_ = source.space_;
        src_ = source.src_;
        type_ = source.type_;
        root_ = source.root_;
        mode_ = source.mode_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlGrammarChoice)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlGrammar</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlGrammar</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlGrammar</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        tagFormat_ = URelaxer.getAttributePropertyAsString(element, "tag-format");
        version_ = URelaxer.getAttributePropertyAsString(element, "version");
        lang_ = URelaxer.getAttributePropertyAsLocale(element, "lang");
        space_ = URelaxer.getAttributePropertyAsString(element, "space");
        src_ = URelaxer.getAttributePropertyAsString(element, "src");
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        root_ = URelaxer.getAttributePropertyAsString(element, "root");
        mode_ = URelaxer.getAttributePropertyAsString(element, "mode");
        content_.clear();
        while (true) {
            if (VxmlAlias.isMatch(stack)) {
                addContent(new VxmlAlias(stack));
            } else if (VxmlMetaSrgs.isMatch(stack)) {
                addContent(new VxmlMetaSrgs(stack));
            } else if (VxmlRule.isMatch(stack)) {
                addContent(new VxmlRule(stack));
            } else if (VxmlLexicon.isMatch(stack)) {
                addContent(new VxmlLexicon(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlGrammar((VxmlGrammar)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "grammar");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.tagFormat_ != null) {
            URelaxer.setAttributePropertyByString(element, "tag-format", this.tagFormat_);
        }
        if (this.version_ != null) {
            URelaxer.setAttributePropertyByString(element, "version", this.version_);
        }
        if (this.lang_ != null) {
            URelaxer.setAttributePropertyByLocale(element, "lang", this.lang_);
        }
        if (this.space_ != null) {
            URelaxer.setAttributePropertyByString(element, "space", this.space_);
        }
        if (this.src_ != null) {
            URelaxer.setAttributePropertyByString(element, "src", this.src_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.root_ != null) {
            URelaxer.setAttributePropertyByString(element, "root", this.root_);
        }
        if (this.mode_ != null) {
            URelaxer.setAttributePropertyByString(element, "mode", this.mode_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlGrammarChoice value = (IVxmlGrammarChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlGrammar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlGrammar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlGrammar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlGrammar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlGrammar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlGrammar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>tagFormat</b>.
     *
     * @return String
     */
    public String getTagFormat() {
        return (tagFormat_);
    }

    /**
     * Sets the String property <b>tagFormat</b>.
     *
     * @param tagFormat
     */
    public void setTagFormat(String tagFormat) {
        this.tagFormat_ = tagFormat;
    }

    /**
     * Gets the String property <b>version</b>.
     *
     * @return String
     */
    public String getVersion() {
        return (version_);
    }

    /**
     * Sets the String property <b>version</b>.
     *
     * @param version
     */
    public void setVersion(String version) {
        this.version_ = version;
    }

    /**
     * Gets the java.util.Locale property <b>lang</b>.
     *
     * @return java.util.Locale
     */
    public java.util.Locale getLang() {
        return (lang_);
    }

    /**
     * Sets the java.util.Locale property <b>lang</b>.
     *
     * @param lang
     */
    public void setLang(java.util.Locale lang) {
        this.lang_ = lang;
    }

    /**
     * Gets the String property <b>space</b>.
     *
     * @return String
     */
    public String getSpace() {
        return (space_);
    }

    /**
     * Sets the String property <b>space</b>.
     *
     * @param space
     */
    public void setSpace(String space) {
        this.space_ = space;
    }

    /**
     * Gets the String property <b>src</b>.
     *
     * @return String
     */
    public String getSrc() {
        return (src_);
    }

    /**
     * Sets the String property <b>src</b>.
     *
     * @param src
     */
    public void setSrc(String src) {
        this.src_ = src;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the String property <b>root</b>.
     *
     * @return String
     */
    public String getRoot() {
        return (root_);
    }

    /**
     * Sets the String property <b>root</b>.
     *
     * @param root
     */
    public void setRoot(String root) {
        this.root_ = root;
    }

    /**
     * Gets the String property <b>mode</b>.
     *
     * @return String
     */
    public String getMode() {
        return (mode_);
    }

    /**
     * Sets the String property <b>mode</b>.
     *
     * @param mode
     */
    public void setMode(String mode) {
        this.mode_ = mode;
    }

    /**
     * Gets the IVxmlGrammarChoice property <b>content</b>.
     *
     * @return IVxmlGrammarChoice[]
     */
    public IVxmlGrammarChoice[] getContent() {
        IVxmlGrammarChoice[] array = new IVxmlGrammarChoice[content_.size()];
        return ((IVxmlGrammarChoice[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlGrammarChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlGrammarChoice[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlGrammarChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlGrammarChoice content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlGrammarChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlGrammarChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlGrammarChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlGrammarChoice[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlGrammarChoice property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlGrammarChoice property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlGrammarChoice
     */
    public IVxmlGrammarChoice getContent(int index) {
        return ((IVxmlGrammarChoice)content_.get(index));
    }

    /**
     * Sets the IVxmlGrammarChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlGrammarChoice content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlGrammarChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlGrammarChoice content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlGrammarChoice property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlGrammarChoice property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlGrammarChoice content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlGrammarChoice property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "grammar", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (tagFormat_ != null) {
            buffer.append(" ");
            buffer.append("tag-format");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getTagFormat())));
            buffer.append("\"");
        }
        if (version_ != null) {
            buffer.append(" ");
            buffer.append("version");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getVersion())));
            buffer.append("\"");
        }
        if (lang_ != null) {
            buffer.append(" ");
            buffer.append("lang");
            buffer.append("=\"");
            buffer.append(URelaxer.getString(getLang()));
            buffer.append("\"");
        }
        if (space_ != null) {
            buffer.append(" ");
            buffer.append("space");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getSpace())));
            buffer.append("\"");
        }
        if (src_ != null) {
            buffer.append(" ");
            buffer.append("src");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getSrc())));
            buffer.append("\"");
        }
        if (type_ != null) {
            buffer.append(" ");
            buffer.append("type");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }
        if (root_ != null) {
            buffer.append(" ");
            buffer.append("root");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getRoot())));
            buffer.append("\"");
        }
        if (mode_ != null) {
            buffer.append(" ");
            buffer.append("mode");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMode())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlGrammarChoice value = (IVxmlGrammarChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlGrammarChoice value = (IVxmlGrammarChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "grammar", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "grammar", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (tagFormat_ != null) {
            buffer.write(" ");
            buffer.write("tag-format");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getTagFormat())));
            buffer.write("\"");
        }
        if (version_ != null) {
            buffer.write(" ");
            buffer.write("version");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getVersion())));
            buffer.write("\"");
        }
        if (lang_ != null) {
            buffer.write(" ");
            buffer.write("lang");
            buffer.write("=\"");
            buffer.write(URelaxer.getString(getLang()));
            buffer.write("\"");
        }
        if (space_ != null) {
            buffer.write(" ");
            buffer.write("space");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getSpace())));
            buffer.write("\"");
        }
        if (src_ != null) {
            buffer.write(" ");
            buffer.write("src");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getSrc())));
            buffer.write("\"");
        }
        if (type_ != null) {
            buffer.write(" ");
            buffer.write("type");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }
        if (root_ != null) {
            buffer.write(" ");
            buffer.write("root");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getRoot())));
            buffer.write("\"");
        }
        if (mode_ != null) {
            buffer.write(" ");
            buffer.write("mode");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMode())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlGrammarChoice value = (IVxmlGrammarChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlGrammarChoice value = (IVxmlGrammarChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "grammar", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "grammar", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (tagFormat_ != null) {
            buffer.print(" ");
            buffer.print("tag-format");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getTagFormat())));
            buffer.print("\"");
        }
        if (version_ != null) {
            buffer.print(" ");
            buffer.print("version");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getVersion())));
            buffer.print("\"");
        }
        if (lang_ != null) {
            buffer.print(" ");
            buffer.print("lang");
            buffer.print("=\"");
            buffer.print(URelaxer.getString(getLang()));
            buffer.print("\"");
        }
        if (space_ != null) {
            buffer.print(" ");
            buffer.print("space");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getSpace())));
            buffer.print("\"");
        }
        if (src_ != null) {
            buffer.print(" ");
            buffer.print("src");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getSrc())));
            buffer.print("\"");
        }
        if (type_ != null) {
            buffer.print(" ");
            buffer.print("type");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }
        if (root_ != null) {
            buffer.print(" ");
            buffer.print("root");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getRoot())));
            buffer.print("\"");
        }
        if (mode_ != null) {
            buffer.print(" ");
            buffer.print("mode");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMode())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlGrammarChoice value = (IVxmlGrammarChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlGrammarChoice value = (IVxmlGrammarChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "grammar", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTagFormatAsString() {
        return (URelaxer.getString(getTagFormat()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getVersionAsString() {
        return (URelaxer.getString(getVersion()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLangAsString() {
        return (URelaxer.getString(getLang()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSpaceAsString() {
        return (URelaxer.getString(getSpace()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSrcAsString() {
        return (URelaxer.getString(getSrc()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRootAsString() {
        return (URelaxer.getString(getRoot()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getModeAsString() {
        return (URelaxer.getString(getMode()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTagFormatByString(String string) {
        setTagFormat(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setVersionByString(String string) {
        setVersion(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLangByString(String string) {
        setLang(URelaxer.getLocale(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSpaceByString(String string) {
        setSpace(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSrcByString(String string) {
        setSrc(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRootByString(String string) {
        setRoot(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setModeByString(String string) {
        setMode(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlGrammar</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "grammar")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (VxmlAlias.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMetaSrgs.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRule.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLexicon.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlGrammar</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlGrammar</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
