/*
 * Galatea Dialog Manager:
 * (c)2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: RecogWindow.java,v 1.1 2006/10/31 10:55:40 nishi Exp $
 */

package galatea.recogman;

import javax.swing.*;
import java.awt.*;

public class RecogWindow
{
	private static int ITEMS = 5;
	private JEditorPane[] panes_ = new JEditorPane[ITEMS];
	private JEditorPane messagePane_;
	
	private void _makeWindow()
	{
		JFrame frame = new JFrame("RecogManager");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		try {
			JPanel panel = new JPanel(new GridLayout(ITEMS + 1, 1));
			messagePane_ = new JEditorPane("text/plain", "");
			messagePane_.setEditable(false);
			panel.add(new JScrollPane
					(messagePane_,
							ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER,
							ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
					)
			);
			for (int i = 0; i < ITEMS; i++) {
				panes_[i] = new JEditorPane("text/plain", "");
				panes_[i].setEditable(false);
				panel.add(new JScrollPane
						(panes_[i],
								ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
								ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
						)
				);
			}
			frame.getContentPane().add(panel);
		} catch(Exception err) { 
			System.out.println(err); 
		}
		frame.setSize(400, 400);
		frame.setVisible(true);
	}
	
	
	public RecogWindow()
	{
		_makeWindow();
	}
	
	
	public void showMessage(String text)
	{
		if (text != null && messagePane_ != null) {
			messagePane_.setText(text);
		}
	}
	
	
	public void showResults(String[] results)
	{
		if (results != null && panes_ != null) {
			for (int i = 0; i < results.length; i++ ) {
				if (panes_[i] != null) {
					panes_[i].setText(results[i]);
				}
			}
		}
	}
	
	
	public static void main(String args[]) throws Exception
	{
	}
}
