/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: DocLoader.java,v 1.12 2006/12/18 00:55:17 nishi Exp $
 */

package galatea.document;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import galatea.dialog.DialogManager;
import galatea.dialog.window.DialogManagerWindow;
import galatea.util.NetUtil;
import galatea.util.Util;

import org.w3c.dom.Element;

public class DocLoader {
	private Element element_;
	private IAbstractDoc doc_;
	private StateMap stateMap_;
	private String warnings_;
	
	/**
	 * http 経由での相対 path 指定の処理を修正．
	 * @param file: ローカルにキャッシュされたファイル位置
	 * @param path: キャッシュ元のファイルのpath
	 * @param dialog: http://server/file.vxml#dialog
	 */
	public DocLoader(String filename, String path, String fragment) throws Exception
	{
		doc_ = null;
		warnings_ = "";
		try {
			element_ = NetUtil.loadXMLFile(filename);
			String topName = NetUtil.getTopName(element_);
			if ( topName.equals("vxml") ) {
				doc_ = new VXMLDoc(element_, path, fragment);
			} else if( topName.equals("pdoc") ) {
				doc_ = new PDoc(element_, path, fragment);
			} else if( topName.equals("grammar") ) {
				doc_ = new GrammarDoc(element_, path, fragment);
			} else {
				throw new DocError("Not a valid document:" + filename);
			}
		} catch (java.lang.NullPointerException e) {
			e.printStackTrace();
		} catch (Exception e) {
			throw new DocError("Not a valid document:" + filename + "\n" + e.toString());
		}
		warnings_ = doc_.getDocWarnings();
		stateMap_ = doc_.getStateMap();
	}
	
	
	public StateMap getStateMap() {
		return stateMap_;
	}
	
	public String getWarnings() {
		return warnings_;
	}
	
	public String getSrcAsString() {
		if (element_ == null) return "";
		return NetUtil.makeString(element_);
	}
	
	public String getTranslatedAsString() {
		if (stateMap_ == null) return "";
		return stateMap_.toString();
	}
	
	
	/**
	 * for galatea -p
	 */
	public static String convert(String uri)
	{
		String ret = "";
		try {
			String path = Util.getUriWithoutFragment(uri);
			String dialog = Util.getUriFragment(uri);
			DocLoader loader = new DocLoader(uri, path, dialog);
			StateMap stateMap = loader.getStateMap();
			if (stateMap == null) {
				System.err.println("DocLoader stopped: stateMap null.");
				return ret;
			}
			ret = loader.getWarnings() + "\n" + stateMap.toString();
		} catch(DocError e){
			e.printStackTrace(System.err);
			System.err.println("DocLoader stopped.");
		} catch(java.io.FileNotFoundException e){
			e.printStackTrace(System.err);
			System.err.println("DocLoader stopped.");
		} catch(org.xml.sax.SAXParseException e){
			e.printStackTrace(System.err);
			System.err.println("Source:"+uri);
			System.err.println("Line:"+e.getLineNumber()+" Column:"+e.getColumnNumber());
			System.err.println("DocLoader stopped.");
		} catch(java.lang.Exception e){
			e.printStackTrace();
			System.err.println("DocLoader stopped.");
		}
		return ret;
	}
	
}
