/**
 *
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 *  $Id: DialogManager.java,v 1.22 2007/01/22 05:42:37 nishi Exp $
 */

package galatea.dialog;

import galatea.dialog.window.DialogManagerWindow;
import galatea.dialog.window.IDMWindowActionListener;
import galatea.document.ContentState;
import galatea.document.DocError;
import galatea.document.DocLoader;
import galatea.document.StateMap;
import galatea.httpserver.HttpServer;
import galatea.scripting.ECMAScript;
import galatea.util.Logger;
import galatea.util.Getopt;
import galatea.util.Messages;
import galatea.util.Property;
import galatea.util.Util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;

/**
 * @author nishi
 *
 */
public class DialogManager {
	private static final String propertiesPath = "/res/config/dialog.properties";
	private static final String messagesPath = "res.messages.messages";

	private Logger dbg;
	
	private IC theIC_;
	private IInteractionController interactionController_;
	private IControllerModeManager modeManager_;
	private String filename;
	
	/**
	 * @param res
	 * @return
	 */
	public static String getResourceAsString(String res) {
		InputStream is = DialogManager.class.getResourceAsStream(res);
		String str = Util.readInputStream(is, Charset.forName("UTF-8"));
		return str;
	}
	
	public static void main(String argv[]) {
		DialogManager dm = new DialogManager();
		dm._setup(argv);
		dm._waitDevicesForReady();
		dm._execute();
		Util.halt("Galatea Dialog Manager terminated.");	
	}
	
	public DialogManager() {
		dbg = new Logger("DM");
	}

	private void _setup(String[] argv) {
		Messages.setup(messagesPath);

		String conf = "gdm.conf";
		boolean isPrintOnly = false;
		
		Getopt g = new Getopt("", argv, "c:vp");
		g.setOpterr(false);
		int c;
		while ((c = g.getopt()) != -1){
			switch (c)	{
			case 'c':
				conf = g.getOptarg();
				break;
				
			case 'v':
				showVersion();
				showUsage();
				System.exit(1);
				break; // ignored
				
			case 'p':
				isPrintOnly = true;
				break;
				
			}
		}
		
		Properties props = new Properties(System.getProperties());
		InputStream is = DialogManager.class.getResourceAsStream(propertiesPath);
		try {
			props.load(is);
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(0);
		}
		File conffile = new File(conf);
		if (conffile.canRead()) {
			try {
				props.load(new FileInputStream(conffile));
			} catch(Exception e) {
				e.printStackTrace();
				// System.exit(0);
			}
		}
		System.setProperties(props);
		
		if ( isPrintOnly ) {
			System.out.print(DocLoader.convert(argv[g.getOptind()]));
			System.exit(0);
		}
		
		if ( Property.getAsBoolean("ShowVersion", true) ) {
			showVersion();
		}
		
		if (argv.length - g.getOptind() != 1){
			filename = null; // _getDefaultFile();
		} else {
			filename = argv[g.getOptind()];
			if (Util.isWindows()) {
				filename = filename.replaceAll("\\\\", "/");
			}
		}
		
		theIC_ = new IC();
		theIC_.start();
		interactionController_ = theIC_;
		modeManager_ = theIC_;
	}

	public void showVersion() {
		System.err.println(galatea.dialog.Tstamp.TSTAMP);
		System.err.print(galatea.dialog.Tstamp.COPYRIGHT);
		System.err.println();
	}
	
	public void showUsage() {
		System.err.println("Usage:\tgalatea [options] [document.vxml]");
		System.err.println("\t -c file : config file");
		System.err.println("\t -v      : show version");
		System.err.println("\t -p      : print translation results");
		System.err.println();
	}
	
	private void _waitDevicesForReady() {
		interactionController_.waitDevicesForReady();
	}
	
	private void _execute() {
//		int errorCount = 0;
		while (true) {
			try {
				if (filename != null && filename.length() > 0 ) {
					dbg.print("filename:" + filename);
					modeManager_.setStatelessMode(false);
					String path = Util.getUriWithoutFragment(filename);
					String dialog = Util.getUriFragment(filename);
					DocLoader loader = new DocLoader(filename, path, dialog);
					StateMap stateMap = loader.getStateMap();
					if ( stateMap == null ) {
						throw new DocError("Document not found: " + filename);
					}
					interactionController_.setStateMap(stateMap);
					String state = "[Load] " + filename;
					String src = loader.getSrcAsString();
					String trans = loader.getWarnings() + "\n" + loader.getTranslatedAsString();
					interactionController_.dispDocInfo(filename, state, src, trans);
				} else {
					dbg.print("StatelessMode=true");
					interactionController_.dispDocInfo("", "(stateless)", "", "");
					modeManager_.setStatelessMode(true);
				}
				interactionController_.mainLoop();
				filename = interactionController_.getNextDocFile();
				interactionController_.resetNextDocFile();
			} catch(galatea.dialog.RuntimeError e){
				System.err.println(e);
				modeManager_.setStatelessMode(true);
				modeManager_.setPauseMode(true);
				interactionController_.dispDocInfo("", "(stateless)", "", "");
				interactionController_.resetNextDocFile();
			} catch(DocError e){
				System.err.println(e);
				modeManager_.setStatelessMode(true);
				modeManager_.setPauseMode(true);
				interactionController_.dispDocInfo("", "(stateless)", "", "");
				interactionController_.resetNextDocFile();
			} catch(java.io.FileNotFoundException e){
				System.err.println(e);
				modeManager_.setStatelessMode(true);
				modeManager_.setPauseMode(true);
				interactionController_.dispDocInfo("", "(stateless)", "", "");
				interactionController_.resetNextDocFile();
				filename = "";
				
			} catch(org.xml.sax.SAXParseException e){
				e.printStackTrace();
				interactionController_.resetNextDocFile();
			} catch(java.lang.Exception e){
				e.printStackTrace();
				interactionController_.resetNextDocFile();
			}
		}
	}

}
