/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: AddOutItemCommand.java,v 1.4 2007/01/15 03:16:37 nishi Exp $
 */

package galatea.command;
import galatea.dialog.RuntimeError;
import galatea.outitem.*;

import java.util.*;

public class AddOutItemCommand extends Command
{
	
	private ArrayList items_;
	
	public AddOutItemCommand(OutItem oi)
	{
		items_ = new ArrayList();
		items_.add((Object)oi);
		// setCondition = "true"
	}
	
	public AddOutItemCommand(OutItem oi, String cond)
	{
		items_ = new ArrayList();
		items_.add((Object)oi);
		setCondition(cond);
	}
	
	public AddOutItemCommand(ArrayList items)
	{
		items_ = items;
	}
	
	public AddOutItemCommand(ArrayList items, String cond)
	{
		items_ = items;
		setCondition(cond);
	}
	
	public String toString()
	{
		String s = "  <add";
		if ( hasCondition() ) {
			s += " cond=\"" + getConditionAsEncodedString() + "\"";
		}
		s += ">";
		for (int i = 0; i < items_.size(); i++) {
//			s += "   ";
			s += items_.get(i).toString();
//			s += "\n";
		}
		s += "</add>";
		return s;
	}
	
	
	public void execute() throws RuntimeError
	{
		if ( evaluateCondition() == true ) {
			for (int i = 0; i < items_.size(); i++) {
				OutItem oi = (OutItem)items_.get(i);
				oi.setECMAScript(ecmascript_);
				oi.doEvaluate(); 
				// TODO: dequeue したときに eval すべき？
				interpreterContext_.enqueueOutItem(oi);
			}
		}
	}
	
}
