/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlJVOICE</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="VOICE" relaxer:className="JVOICE">
 *       <optional>
 *         <attribute name="OPTIONAL">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="REQUIRED">
 *           <choice>
 *             <value type="NMTOKEN">MALE</value>
 *             <value type="NMTOKEN">FEMALE</value>
 *             <value type="NMTOKEN">male</value>
 *             <value type="NMTOKEN">female</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="ALPHA">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <mixed>
 *         <zeroOrMore>
 *           <choice>
 *             <ref name="audio"/>
 *             <ref name="prosody"/>
 *             <ref name="voice"/>
 *             <ref name="emotion"/>
 *             <ref name="REGWORD"/>
 *             <ref name="CONTEXT"/>
 *             <ref name="VOICE"/>
 *             <ref name="break"/>
 *             <ref name="phoneme"/>
 *             <ref name="say-as"/>
 *             <ref name="paragraph"/>
 *             <ref name="PITCH"/>
 *             <ref name="PRON"/>
 *             <ref name="value"/>
 *             <ref name="emphasis"/>
 *             <ref name="mark"/>
 *             <ref name="p"/>
 *             <ref name="sentence"/>
 *             <ref name="s"/>
 *             <ref name="BOOKMARK"/>
 *             <ref name="LANG"/>
 *             <ref name="PARTOFSP"/>
 *             <ref name="RATE"/>
 *             <ref name="SILENCE"/>
 *             <ref name="VOLUME"/>
 *             <ref name="enumerate"/>
 *             <ref name="EMPH"/>
 *             <ref name="RESET"/>
 *             <ref name="SPELL"/>
 *             <ref name="SPEECH"/>
 *           </choice>
 *         </zeroOrMore>
 *       </mixed>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="VOICE" relaxer:className="JVOICE"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="OPTIONAL"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="REQUIRED"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;MALE&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;FEMALE&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;male&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;female&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="ALPHA"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;mixed&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;choice&gt;
 *             &lt;ref name="audio"/&gt;
 *             &lt;ref name="prosody"/&gt;
 *             &lt;ref name="voice"/&gt;
 *             &lt;ref name="emotion"/&gt;
 *             &lt;ref name="REGWORD"/&gt;
 *             &lt;ref name="CONTEXT"/&gt;
 *             &lt;ref name="VOICE"/&gt;
 *             &lt;ref name="break"/&gt;
 *             &lt;ref name="phoneme"/&gt;
 *             &lt;ref name="say-as"/&gt;
 *             &lt;ref name="paragraph"/&gt;
 *             &lt;ref name="PITCH"/&gt;
 *             &lt;ref name="PRON"/&gt;
 *             &lt;ref name="value"/&gt;
 *             &lt;ref name="emphasis"/&gt;
 *             &lt;ref name="mark"/&gt;
 *             &lt;ref name="p"/&gt;
 *             &lt;ref name="sentence"/&gt;
 *             &lt;ref name="s"/&gt;
 *             &lt;ref name="BOOKMARK"/&gt;
 *             &lt;ref name="LANG"/&gt;
 *             &lt;ref name="PARTOFSP"/&gt;
 *             &lt;ref name="RATE"/&gt;
 *             &lt;ref name="SILENCE"/&gt;
 *             &lt;ref name="VOLUME"/&gt;
 *             &lt;ref name="enumerate"/&gt;
 *             &lt;ref name="EMPH"/&gt;
 *             &lt;ref name="RESET"/&gt;
 *             &lt;ref name="SPELL"/&gt;
 *             &lt;ref name="SPEECH"/&gt;
 *           &lt;/choice&gt;
 *         &lt;/zeroOrMore&gt;
 *       &lt;/mixed&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Wed Jul 07 07:19:10 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlJVOICE implements java.io.Serializable, Cloneable, IRNSContainer, IVxmlJVOICEMixed, IVxmlJVOICEMixedChoice, IVxmlPITCHMixed, IVxmlPITCHMixedChoice, IVxmlParagraphMixed, IVxmlParagraphMixedChoice, IVxmlPRONMixed, IVxmlPRONMixedChoice, IVxmlPMixed, IVxmlPMixedChoice, IVxmlSentenceMixed, IVxmlSentenceMixedChoice, IVxmlVOLUMEMixed, IVxmlVOLUMEMixedChoice, IVxmlSMixed, IVxmlSMixedChoice, IVxmlLANGMixed, IVxmlLANGMixedChoice, IVxmlPARTOFSPMixed, IVxmlPARTOFSPMixedChoice, IVxmlEmphasisMixed, IVxmlEmphasisMixedChoice, IVxmlRATEMixed, IVxmlRATEMixedChoice, IVxmlSPELLMixed, IVxmlSPELLMixedChoice, IVxmlSPEECHMixed, IVxmlSPEECHMixedChoice, IVxmlEMPHMixed, IVxmlEMPHMixedChoice, IVxmlEnumerateMixed, IVxmlEnumerateMixedChoice, IRVisitable, IRNode, IVxmlCONTEXTMixed, IVxmlCONTEXTMixedChoice, IVxmlEmotionMixed, IVxmlEmotionMixedChoice, IVxmlVoiceMixed, IVxmlVoiceMixedChoice, IVxmlAudioMixed, IVxmlAudioMixedChoice, IVxmlProsodyMixed, IVxmlProsodyMixedChoice, IVxmlChoiceMixed, IVxmlChoiceMixedChoice, IVxmlPromptMixed, IVxmlPromptMixedChoice, IVxmlMediaMixedMixed, IVxmlMediaMixedMixedChoice {
    public static final String REQUIRED_MALE = "MALE";
    public static final String REQUIRED_FEMALE = "FEMALE";
    public static final String REQUIRED_MALE1 = "male";
    public static final String REQUIRED_FEMALE1 = "female";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String OPTIONAL_;
    private String REQUIRED_;
    private String ALPHA_;
    // List<IVxmlJVOICEMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlJVOICE</code>.
     *
     */
    public VxmlJVOICE() {
    }

    /**
     * Creates a <code>VxmlJVOICE</code>.
     *
     * @param source
     */
    public VxmlJVOICE(VxmlJVOICE source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlJVOICE</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlJVOICE(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlJVOICE</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlJVOICE(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlJVOICE</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlJVOICE(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlJVOICE</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlJVOICE(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlJVOICE</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlJVOICE(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlJVOICE</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlJVOICE(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlJVOICE</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlJVOICE(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlJVOICE</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlJVOICE(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlJVOICE</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlJVOICE(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlJVOICE</code> by the VxmlJVOICE <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlJVOICE source) {
        int size;
        OPTIONAL_ = source.OPTIONAL_;
        REQUIRED_ = source.REQUIRED_;
        ALPHA_ = source.ALPHA_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlJVOICEMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlJVOICE</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlJVOICE</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlJVOICE</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        OPTIONAL_ = URelaxer.getAttributePropertyAsString(element, "OPTIONAL");
        REQUIRED_ = URelaxer.getAttributePropertyAsString(element, "REQUIRED");
        ALPHA_ = URelaxer.getAttributePropertyAsString(element, "ALPHA");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlProsody.isMatch(stack)) {
                addContent(new VxmlProsody(stack));
            } else if (VxmlVoice.isMatch(stack)) {
                addContent(new VxmlVoice(stack));
            } else if (VxmlEmotion.isMatch(stack)) {
                addContent(new VxmlEmotion(stack));
            } else if (VxmlREGWORD.isMatch(stack)) {
                addContent(new VxmlREGWORD(stack));
            } else if (VxmlCONTEXT.isMatch(stack)) {
                addContent(new VxmlCONTEXT(stack));
            } else if (VxmlJVOICE.isMatch(stack)) {
                addContent(new VxmlJVOICE(stack));
            } else if (VxmlBreak.isMatch(stack)) {
                addContent(new VxmlBreak(stack));
            } else if (VxmlPhoneme.isMatch(stack)) {
                addContent(new VxmlPhoneme(stack));
            } else if (VxmlSayAs.isMatch(stack)) {
                addContent(new VxmlSayAs(stack));
            } else if (VxmlPITCH.isMatch(stack)) {
                addContent(new VxmlPITCH(stack));
            } else if (VxmlP.isMatch(stack)) {
                addContent(new VxmlP(stack));
            } else if (VxmlPARTOFSP.isMatch(stack)) {
                addContent(new VxmlPARTOFSP(stack));
            } else if (VxmlRATE.isMatch(stack)) {
                addContent(new VxmlRATE(stack));
            } else if (VxmlVOLUME.isMatch(stack)) {
                addContent(new VxmlVOLUME(stack));
            } else if (VxmlParagraph.isMatch(stack)) {
                addContent(new VxmlParagraph(stack));
            } else if (VxmlPRON.isMatch(stack)) {
                addContent(new VxmlPRON(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlEmphasis.isMatch(stack)) {
                addContent(new VxmlEmphasis(stack));
            } else if (VxmlMark.isMatch(stack)) {
                addContent(new VxmlMark(stack));
            } else if (VxmlSentence.isMatch(stack)) {
                addContent(new VxmlSentence(stack));
            } else if (VxmlS.isMatch(stack)) {
                addContent(new VxmlS(stack));
            } else if (VxmlBOOKMARK.isMatch(stack)) {
                addContent(new VxmlBOOKMARK(stack));
            } else if (VxmlLANG.isMatch(stack)) {
                addContent(new VxmlLANG(stack));
            } else if (VxmlSILENCE.isMatch(stack)) {
                addContent(new VxmlSILENCE(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else if (VxmlEMPH.isMatch(stack)) {
                addContent(new VxmlEMPH(stack));
            } else if (VxmlSPELL.isMatch(stack)) {
                addContent(new VxmlSPELL(stack));
            } else if (VxmlSPEECH.isMatch(stack)) {
                addContent(new VxmlSPEECH(stack));
            } else if (VxmlRESET.isMatch(stack)) {
                addContent(new VxmlRESET(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlJVOICE((VxmlJVOICE)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "VOICE");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.OPTIONAL_ != null) {
            URelaxer.setAttributePropertyByString(element, "OPTIONAL", this.OPTIONAL_);
        }
        if (this.REQUIRED_ != null) {
            URelaxer.setAttributePropertyByString(element, "REQUIRED", this.REQUIRED_);
        }
        if (this.ALPHA_ != null) {
            URelaxer.setAttributePropertyByString(element, "ALPHA", this.ALPHA_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlJVOICEMixed value = (IVxmlJVOICEMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlJVOICE</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlJVOICE</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlJVOICE</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlJVOICE</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlJVOICE</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlJVOICE</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContent(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContent(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContentByString(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContentByString(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void setContent(org.w3c.dom.Node value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void addContent(org.w3c.dom.Node value) {
        addContent(new RString(value));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>OPTIONAL</b>.
     *
     * @return String
     */
    public String getOPTIONAL() {
        return (OPTIONAL_);
    }

    /**
     * Sets the String property <b>OPTIONAL</b>.
     *
     * @param OPTIONAL
     */
    public void setOPTIONAL(String OPTIONAL) {
        this.OPTIONAL_ = OPTIONAL;
    }

    /**
     * Gets the String property <b>REQUIRED</b>.
     *
     * @return String
     */
    public String getREQUIRED() {
        return (REQUIRED_);
    }

    /**
     * Sets the String property <b>REQUIRED</b>.
     *
     * @param REQUIRED
     */
    public void setREQUIRED(String REQUIRED) {
        this.REQUIRED_ = REQUIRED;
    }

    /**
     * Gets the String property <b>ALPHA</b>.
     *
     * @return String
     */
    public String getALPHA() {
        return (ALPHA_);
    }

    /**
     * Sets the String property <b>ALPHA</b>.
     *
     * @param ALPHA
     */
    public void setALPHA(String ALPHA) {
        this.ALPHA_ = ALPHA;
    }

    /**
     * Gets the IVxmlJVOICEMixed property <b>content</b>.
     *
     * @return IVxmlJVOICEMixed[]
     */
    public IVxmlJVOICEMixed[] getContent() {
        IVxmlJVOICEMixed[] array = new IVxmlJVOICEMixed[content_.size()];
        return ((IVxmlJVOICEMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlJVOICEMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlJVOICEMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlJVOICEMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlJVOICEMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlJVOICEMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlJVOICEMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlJVOICEMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlJVOICEMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlJVOICEMixed property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlJVOICEMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlJVOICEMixed
     */
    public IVxmlJVOICEMixed getContent(int index) {
        return ((IVxmlJVOICEMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlJVOICEMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlJVOICEMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlJVOICEMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlJVOICEMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlJVOICEMixed property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlJVOICEMixed property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlJVOICEMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlJVOICEMixed property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "VOICE", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (OPTIONAL_ != null) {
            buffer.append(" ");
            buffer.append("OPTIONAL");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getOPTIONAL())));
            buffer.append("\"");
        }
        if (REQUIRED_ != null) {
            buffer.append(" ");
            buffer.append("REQUIRED");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getREQUIRED())));
            buffer.append("\"");
        }
        if (ALPHA_ != null) {
            buffer.append(" ");
            buffer.append("ALPHA");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getALPHA())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlJVOICEMixed value = (IVxmlJVOICEMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlJVOICEMixed value = (IVxmlJVOICEMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "VOICE", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "VOICE", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (OPTIONAL_ != null) {
            buffer.write(" ");
            buffer.write("OPTIONAL");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getOPTIONAL())));
            buffer.write("\"");
        }
        if (REQUIRED_ != null) {
            buffer.write(" ");
            buffer.write("REQUIRED");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getREQUIRED())));
            buffer.write("\"");
        }
        if (ALPHA_ != null) {
            buffer.write(" ");
            buffer.write("ALPHA");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getALPHA())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlJVOICEMixed value = (IVxmlJVOICEMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlJVOICEMixed value = (IVxmlJVOICEMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "VOICE", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "VOICE", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (OPTIONAL_ != null) {
            buffer.print(" ");
            buffer.print("OPTIONAL");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getOPTIONAL())));
            buffer.print("\"");
        }
        if (REQUIRED_ != null) {
            buffer.print(" ");
            buffer.print("REQUIRED");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getREQUIRED())));
            buffer.print("\"");
        }
        if (ALPHA_ != null) {
            buffer.print(" ");
            buffer.print("ALPHA");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getALPHA())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlJVOICEMixed value = (IVxmlJVOICEMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlJVOICEMixed value = (IVxmlJVOICEMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "VOICE", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getOPTIONALAsString() {
        return (URelaxer.getString(getOPTIONAL()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getREQUIREDAsString() {
        return (URelaxer.getString(getREQUIRED()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getALPHAAsString() {
        return (URelaxer.getString(getALPHA()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setOPTIONALByString(String string) {
        setOPTIONAL(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setREQUIREDByString(String string) {
        setREQUIRED(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setALPHAByString(String string) {
        setALPHA(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlJVOICE</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "VOICE")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RString.isMatch(target)) {
            $match$ = true;
        }
        while (true) {
            if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProsody.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmotion.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlREGWORD.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCONTEXT.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlJVOICE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBreak.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPhoneme.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSayAs.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPITCH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPARTOFSP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRATE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVOLUME.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlParagraph.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPRON.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmphasis.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMark.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSentence.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlS.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBOOKMARK.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLANG.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSILENCE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEMPH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPELL.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPEECH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRESET.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlJVOICE</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlJVOICE</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
