/* -*- Mode: java; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * RecogMan2 for Galatea DM (for julius)
 *
 * (c)2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 *  $Id: RecogMan2.java,v 1.6 2006/12/11 10:07:09 nishi Exp $
 */

package galatea.recogman;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;

import galatea.util.AMBuffer;
import galatea.util.Util;


public class RecogMan2 implements RecogInterpreterListener
{
	private JuliusClient julius_;
	private AMBuffer ambuf_;
	private RecogInterpreter recogInterpreter_;
	
	public RecogMan2()	
	{
	}
	
	public void run()
	{
		recogInterpreter_ = new RecogInterpreter();
		recogInterpreter_.setListener(this);
		
		recogInterpreter_.setScript("/home/nishi/local/galatea-devel/DM/phoenix/chatbot/sim.js");
		recogInterpreter_.setEventHandler("onevent");
		
		ambuf_ = new AMBuffer(Util.getSystemDefaultCharset()); 
		julius_ = new JuliusClient("localhost", 5530);
		
		try {
			julius_.open();
		} catch (IOException e2) {
			e2.printStackTrace();
		}
		
		while (true) {
			
			// from Julius socket
			String msg;
			try {
				julius_.receive();
			} catch (CharacterCodingException e1) {
				e1.printStackTrace();
				break;
			} catch (IOException e1) {
				e1.printStackTrace();
				break;
			}
			while ((msg = julius_.getMessage()).length() > 0) {
				// System.err.println(msg);
				recogInterpreter_.receiveRecogMessage(msg);
			}
			
			// from AgentManager
			String str = ambuf_.receive();
			// do nothing with str
			try {
				Thread.sleep(1);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	
	public static void main(String argv[])
	{
		RecogMan2 recogManager = new RecogMan2();
		recogManager.run();
	}
	
	
	private void _debugPrint(String str)
	{
		// System.err.println(str);
	}
	
	
	private void _send(String str)
	{
		ambuf_.send(str);
	}
	
	private void _sendUserSpeakState(int s)
	{
		_send("to @DIM set UserSpeakState = " + s);
	}
	
	private void _sendSpeak(String str)
	{
		ambuf_.send("to @AM-MCL set Speak = " + str);
	}
	
	public void recogListenStarted() // implements RecogListener
	{
		_sendUserSpeakState(0);
		_send("to @DM From @SIM tell 201 LISTEN");
	}
	
	public void recogRecordStarted() // implements RecogListener
	{
		_sendUserSpeakState(1);
		// _send("to @DM From @SIM tell 202 INPUT_START from SRM");
	}
	
	public void recogProgressiveHypo(String text) // implements RecogListener
	{
	}
	
	public void recogRecordFinished() // implements RecogListener
	{
		_sendUserSpeakState(0);
	}
	
	public void recogPass1Finished() // implements RecogListener
	{
	}
	
	public void recogPass2Finished() // implements RecogListener
	{
		String script = recogInterpreter_.getScript();
		String text = recogInterpreter_.getText();
		_send("to @DM From @SIM tell 300 <ev src=\"SRM\" type=\"INPUT\"><interpreted>"
				+"<text>" + text + "</text>"
				+"<script>" + script + "</script></interpreted></ev>");
		
	}
	
	public void recogFailed() // implements RecogListener
	{
		// _send("to @DM From @SIM tell 301 RECOGFAIL");
	}
	
	public void recogException(Exception e, String str) // implements RecogListener
	{
		_debugPrint("[SIM] recogException(" + str +")");
		e.printStackTrace();
	}
	
}
