/**
 * 
 */
package galatea.io;

import galatea.dialog.ISystemEventLogger;
import galatea.httpserver.HttpAsyncResponse;
import galatea.httpserver.HttpSession;
import galatea.submodule.IReceiverFromSubModule;
import galatea.submodule.ISubModule;

import java.util.ArrayList;

class HttpSenderToDevice implements ISenderToDevice {
	private HttpSession session_;
	private ArrayList /*ISubModule*/ subModules_ = new ArrayList(); 
	
	public HttpSenderToDevice(HttpSession hs) {
		session_ = hs;
	}
	
	public void addSubModule(ISubModule s, 
			IReceiverFromSubModule r, ISystemEventLogger l) {
		subModules_.add(s);
		s.setSender(this);
		s.setReceiver(r);
		s.setLogger(l);
	}
	
	public void send(String msg) {
		HttpAsyncResponse ev = HttpAsyncResponse.newInstance(msg);
		session_.enqueueHttpAsyncResponse(ev);
	}
	
	public boolean checkInput(String module, String str) {
		for (int i = 0; i < subModules_.size(); i++) {
			ISubModule s = (ISubModule) subModules_.get(i);
			if ( s != null 
					&& s.getName().equals(module)
					&& s.receiveFromDevice(str) == true) {
				return true;
			}
		}
		return false;
	}
}