/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

import galatea.document.DocError;
import galatea.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NetUtil {
    private NetUtil() {
    }

    public static String getTopName(Element elem) {
        String topName = elem.getNodeType() == 1 ? elem.getNodeName() : "";
        return topName;
    }

    public static Element loadXMLFile(String filename) throws Exception {
        Document root;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (filename.startsWith("http:")) {
            int n;
            URL url = new URL(filename);
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setRequestMethod("GET");
            InputStream is = uc.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int SIZE = 8196;
            byte[] buf = new byte[8196];
            while ((n = is.read(buf, 0, 8196)) != -1) {
                os.write(buf, 0, n);
            }
            byte[] bytes = os.toByteArray();
            os.close();
            is.close();
            uc.disconnect();
            String encoding = "UTF-8";
            int pos = 0;
            int i = 0;
            while (i < bytes.length) {
                if (bytes[i] == 62 && i > 0 && bytes[i - 1] == 63) {
                    String s;
                    String e;
                    String line = new String(bytes, 0, i + 1);
                    if (line.startsWith("<?xml ") && (e = Util.getFirstGroup(".*encoding[\\s]*=[\\s]*'([^']+)'.*", s = line.replaceAll("\"", "'"))) != null) {
                        encoding = e;
                    }
                    pos = i + 1;
                    break;
                }
                ++i;
            }
            int len = bytes.length - pos;
            String content = new String(bytes, pos, len, encoding);
            ByteArrayInputStream is2 = new ByteArrayInputStream(content.getBytes("UTF-8"));
            root = builder.parse(is2);
        } else {
            root = builder.parse(filename);
        }
        Element elem = root.getDocumentElement();
        return elem;
    }

    public static String loadTextFile(String filename) throws Exception {
        String doc = Util.readURL(filename);
        if (Util.getError().equals("")) {
            return doc;
        }
        throw new DocError(Util.getError());
    }

    public static String makeString(Element element) {
        Transformer transformer;
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            transformer = factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            return e.toString();
        }
        DOMSource src = new DOMSource(element);
        StringWriter writer = new StringWriter();
        StreamResult target = new StreamResult(writer);
        try {
            transformer.transform(src, target);
        }
        catch (Exception e) {
            return e.toString();
        }
        String ws = new String(writer.getBuffer());
        return ws;
    }

    public static void main(String[] args) throws Exception {
        String s = NetUtil.loadXMLFile("http://localhost/bento/vxml/vxml-begin.php").toString();
        System.err.println(s);
    }
}

