/*
 * Decompiled with CFR 0.152.
 */
package galatea.scripting;

import galatea.dialog.RuntimeError;
import galatea.scripting.ScriptingTools;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.shell.Global;

public class ECMAScript {
    private Context context_ = null;
    private Scriptable scope_ = null;

    public ECMAScript() throws RuntimeError {
        try {
            this.context_ = Context.enter();
            this.scope_ = this.context_.initStandardObjects(null);
            Global global = new Global(this.context_);
            this.scope_.put("Shell", this.scope_, (Object)global);
            ScriptingTools tools = new ScriptingTools();
            this.scope_.put("Tools", this.scope_, (Object)tools);
        }
        catch (Exception e) {
            throw new RuntimeError(e.getMessage());
        }
    }

    public String evaluate(String script) throws RuntimeError {
        if (this.context_ == null) {
            return "context_error";
        }
        if (this.scope_ == null) {
            return "scope_error";
        }
        if (script == null) {
            return "error";
        }
        String str = "error";
        Object result = null;
        try {
            result = this.context_.evaluateString(this.scope_, script, "GalateaDialogManager", 1, null);
            str = result.toString();
        }
        catch (Exception e) {
            throw new RuntimeError(String.valueOf(e.getMessage()) + "\n" + script);
        }
        return str;
    }

    public String getVersion() {
        return this.context_.getImplementationVersion();
    }

    public static void main(String[] args) throws Exception {
        ECMAScript sc = new ECMAScript();
        String r = "";
        String s = "weather = new Object();weather.initial1 = undefined;weather.place  = undefined;weather.when   = undefined;weather.block2 = undefined;weather.initial1$ = new Object();weather.initial1$.promptcount = 1;weather.place$ = new Object();weather.place$.promptcount = 1;weather.place$.justfilled = false;weather.when$ = new Object();weather.when$.promptcount = 1;weather.when$.justfilled = false;weather.nextitem$ = 'hello';";
        r = sc.evaluate(s);
        System.err.println(r);
        s = "with(weather){ nextitem$ }";
        r = sc.evaluate(s);
        System.err.println(r);
        s = "with(weather){ 'hoge' }";
        r = sc.evaluate(s);
        System.err.println(r);
    }
}

