/*
 * Decompiled with CFR 0.152.
 */
package galatea.recogman;

import galatea.util.AMBuffer;
import galatea.util.Util;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;

public class JuliusClient {
    private String ADDRESS = "localhost";
    private int PORT = 10500;
    private SocketChannel channel;
    private Selector selector;
    private ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2048);
    private String inputBuffer = "";
    private Charset charset;
    private CharsetDecoder decoder;
    private CharsetEncoder encoder;

    public JuliusClient(String addr, int port) {
        this.ADDRESS = addr;
        this.PORT = port;
    }

    public void send(String str) {
        try {
            this.byteBuffer.clear();
            this.encoder.reset();
            this.encoder.encode(CharBuffer.wrap(str), this.byteBuffer, true);
            this.byteBuffer.flip();
            this.channel.write(this.byteBuffer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getMessage() {
        String ret = "";
        int pos = this.inputBuffer.indexOf(">.");
        if (pos > 0) {
            ret = this.inputBuffer.substring(0, pos + 1);
            this.inputBuffer = this.inputBuffer.substring(pos + 2);
        }
        return ret;
    }

    public void open() throws IOException {
        this.charset = Util.getSystemDefaultCharset();
        this.decoder = this.charset.newDecoder();
        this.encoder = this.charset.newEncoder();
        this.channel = SocketChannel.open();
        this.selector = Selector.open();
        InetSocketAddress address = new InetSocketAddress(this.ADDRESS, this.PORT);
        boolean connected = false;
        while (!connected) {
            try {
                this.channel.connect(address);
                connected = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.channel.configureBlocking(false);
        this.channel.register(this.selector, 1);
    }

    public void receive() throws CharacterCodingException, IOException {
        if (this.selector.selectNow() > 0) {
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                it.remove();
                if (!key.isReadable()) continue;
                this.byteBuffer.clear();
                this.channel.read(this.byteBuffer);
                this.byteBuffer.flip();
                this.decoder.reset();
                String str = this.decoder.decode(this.byteBuffer).toString();
                str = str.replaceAll("\\s+<", "<");
                str = str.replaceAll("\n", "");
                this.inputBuffer = String.valueOf(this.inputBuffer) + str;
            }
        }
    }

    public void close() {
        try {
            this.channel.close();
            this.selector.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        ambuf = new AMBuffer(Util.getSystemDefaultCharset());
        client = new JuliusClient("localhost", 10500);
        try {
            client.open();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        ambuf.send("open");
        while (true) {
            try {
                client.receive();
                if (true) ** GOTO lbl21
            }
            catch (CharacterCodingException e1) {
                e1.printStackTrace();
                break;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                break;
            }
            do {
                ambuf.send("tell " + msg);
lbl21:
                // 2 sources

            } while ((msg = client.getMessage()).length() > 0);
            in = ambuf.receive();
            if (in.length() > 0) {
                if (in.equals(".")) break;
                cmd = String.valueOf(in) + "\n";
                client.send(cmd);
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception var5_9) {}
        }
        client.close();
    }
}

