/*
 * Decompiled with CFR 0.152.
 */
package galatea.io;

import galatea.dialog.ISystemEventLogger;
import galatea.httpserver.HttpAsyncResponse;
import galatea.httpserver.HttpSession;
import galatea.io.ISenderToDevice;
import galatea.submodule.IReceiverFromSubModule;
import galatea.submodule.ISubModule;
import java.util.ArrayList;

class HttpSenderToDevice
implements ISenderToDevice {
    private HttpSession session_;
    private ArrayList subModules_ = new ArrayList();

    public HttpSenderToDevice(HttpSession hs) {
        this.session_ = hs;
    }

    public void addSubModule(ISubModule s, IReceiverFromSubModule r, ISystemEventLogger l) {
        this.subModules_.add(s);
        s.setSender(this);
        s.setReceiver(r);
        s.setLogger(l);
    }

    public void send(String msg) {
        HttpAsyncResponse ev = HttpAsyncResponse.newInstance(msg);
        this.session_.enqueueHttpAsyncResponse(ev);
    }

    public boolean checkInput(String module, String str) {
        int i = 0;
        while (i < this.subModules_.size()) {
            ISubModule s = (ISubModule)this.subModules_.get(i);
            if (s != null && s.getName().equals(module) && s.receiveFromDevice(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

