/*
 * Decompiled with CFR 0.152.
 */
package galatea.httpserver;

import galatea.httpserver.HttpAsyncResponse;
import galatea.httpserver.IHttpAsyncResponseListener;
import galatea.httpserver.IHttpRequestResponder;
import galatea.httpserver.IHttpResponseHtmlMaker;
import galatea.httpserver.IHttpServerResponse;
import galatea.util.Logger;
import galatea.util.StringHashArray;
import galatea.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

public class HttpSession
implements IHttpServerResponse,
IHttpAsyncResponseListener {
    private IHttpResponseHtmlMaker htmlMaker_;
    private IHttpRequestResponder responder_;
    private Logger dbg = new Logger("HTTP");
    private ArrayList httpAsyncResponses_ = new ArrayList();

    public HttpSession(IHttpResponseHtmlMaker o, IHttpRequestResponder r) {
        this.htmlMaker_ = o;
        this.responder_ = r;
        this.htmlMaker_.addHttpAsyncResponseListener(this);
    }

    public void enqueueHttpAsyncResponse(HttpAsyncResponse ev) {
        if (ev != null) {
            this.dbg.print("HttpServerResponse: update " + ev.toString());
            this.httpAsyncResponses_.add(ev);
        }
    }

    private void _dispHttpLog(String str) {
        this.dbg.print(str);
    }

    public String getResponse(String path) {
        this._dispHttpLog("getResponse " + path);
        String path2 = path;
        try {
            path2 = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String response = "";
        StringHashArray ha = Util.getQueryFromRequest(path2);
        if (ha.getAsString("m").length() > 0) {
            String ev = ha.getAsString("e");
            if (ev.equals("listen")) {
                this._dispHttpLog("listen (waiting)");
                while (this.httpAsyncResponses_.size() == 0) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                HttpAsyncResponse de = (HttpAsyncResponse)this.httpAsyncResponses_.remove(0);
                response = de.getString();
                this._dispHttpLog("asyncResponse " + response);
            } else {
                String arg = ha.getAsString("arg");
                String s = this.responder_.respondToHttpRequest(ha.getAsString("m"), ev, arg);
                this._dispHttpLog("response " + s);
            }
        } else {
            String file = Util.getFileNameFromRequest(path2);
            if (file.equals("/")) {
                response = this.htmlMaker_.getDialogMonitorHtml();
                this._dispHttpLog("doc " + file);
            }
            if (file.equals("/demo")) {
                response = this.htmlMaker_.getDemoAppHtml();
                this._dispHttpLog("doc " + file);
            }
        }
        return response;
    }

    public static void main(String[] argv) {
        String html = "<html>${script}</html>\n<html>${script}</html>\n";
        StringHashArray replaces = new StringHashArray();
        replaces.put("${script}", "var $hoge = 100;");
        String res = Util.getDocumentFromTemplate(html, replaces);
        System.out.println(res);
    }
}

