package relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlCONTEXT</b> is generated from vxml20.rxg by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="CONTEXT">
 *   <mixed>
 *     <choice occurs="*">
 *       <ref label="audio"/>
 *       <ref label="enumerate"/>
 *       <ref label="value"/>
 *       <ref label="break"/>
 *       <ref label="emphasis"/>
 *       <ref label="mark"/>
 *       <ref label="phoneme"/>
 *       <ref label="prosody"/>
 *       <ref label="say-as"/>
 *       <ref label="voice"/>
 *       <ref label="paragraph"/>
 *       <ref label="p"/>
 *       <ref label="sentence"/>
 *       <ref label="s"/>
 *       <ref label="emotion"/>
 *       <ref label="BOOKMARK"/>
 *       <ref label="CONTEXT"/>
 *       <ref label="EMPH"/>
 *       <ref label="LANG"/>
 *       <ref label="PARTOFSP"/>
 *       <ref label="PITCH"/>
 *       <ref label="PRON"/>
 *       <ref label="RATE"/>
 *       <ref label="REGWORD"/>
 *       <ref label="RESET"/>
 *       <ref label="SPELL"/>
 *       <ref label="SILENCE"/>
 *       <ref label="SPEECH"/>
 *       <ref label="VOICE"/>
 *       <ref label="VOLUME"/>
 *     </choice>
 *   </mixed>
 * </elementRule>
 * 
 * <tag name="CONTEXT">
 *   <attribute name="TYPE" type="NMTOKEN">
 *     <enumeration value="DEFAULT"/>
 *     <enumeration value="PERSON"/>
 *     <enumeration value="ADDRESS"/>
 *     <enumeration value="CHAT"/>
 *     <enumeration value="PHONE"/>
 *     <enumeration value="DATE"/>
 *     <enumeration value="TIME"/>
 *     <enumeration value="URL"/>
 *     <enumeration value="EMAIL"/>
 *     <enumeration value="LIST"/>
 *     <enumeration value="NUMBER"/>
 *     <enumeration value="DIGITS"/>
 *   </attribute>
 *   <attribute name="FORMAT" type="NMTOKEN"/>
 *   <attribute name="DELIM" type="NMTOKEN"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="CONTEXT"&gt;
 *   &lt;mixed&gt;
 *     &lt;choice occurs="*"&gt;
 *       &lt;ref label="audio"/&gt;
 *       &lt;ref label="enumerate"/&gt;
 *       &lt;ref label="value"/&gt;
 *       &lt;ref label="break"/&gt;
 *       &lt;ref label="emphasis"/&gt;
 *       &lt;ref label="mark"/&gt;
 *       &lt;ref label="phoneme"/&gt;
 *       &lt;ref label="prosody"/&gt;
 *       &lt;ref label="say-as"/&gt;
 *       &lt;ref label="voice"/&gt;
 *       &lt;ref label="paragraph"/&gt;
 *       &lt;ref label="p"/&gt;
 *       &lt;ref label="sentence"/&gt;
 *       &lt;ref label="s"/&gt;
 *       &lt;ref label="emotion"/&gt;
 *       &lt;ref label="BOOKMARK"/&gt;
 *       &lt;ref label="CONTEXT"/&gt;
 *       &lt;ref label="EMPH"/&gt;
 *       &lt;ref label="LANG"/&gt;
 *       &lt;ref label="PARTOFSP"/&gt;
 *       &lt;ref label="PITCH"/&gt;
 *       &lt;ref label="PRON"/&gt;
 *       &lt;ref label="RATE"/&gt;
 *       &lt;ref label="REGWORD"/&gt;
 *       &lt;ref label="RESET"/&gt;
 *       &lt;ref label="SPELL"/&gt;
 *       &lt;ref label="SILENCE"/&gt;
 *       &lt;ref label="SPEECH"/&gt;
 *       &lt;ref label="VOICE"/&gt;
 *       &lt;ref label="VOLUME"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/mixed&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="CONTEXT"&gt;
 *   &lt;attribute name="TYPE" type="NMTOKEN"&gt;
 *     &lt;enumeration value="DEFAULT"/&gt;
 *     &lt;enumeration value="PERSON"/&gt;
 *     &lt;enumeration value="ADDRESS"/&gt;
 *     &lt;enumeration value="CHAT"/&gt;
 *     &lt;enumeration value="PHONE"/&gt;
 *     &lt;enumeration value="DATE"/&gt;
 *     &lt;enumeration value="TIME"/&gt;
 *     &lt;enumeration value="URL"/&gt;
 *     &lt;enumeration value="EMAIL"/&gt;
 *     &lt;enumeration value="LIST"/&gt;
 *     &lt;enumeration value="NUMBER"/&gt;
 *     &lt;enumeration value="DIGITS"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="FORMAT" type="NMTOKEN"/&gt;
 *   &lt;attribute name="DELIM" type="NMTOKEN"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version vxml20.rxg (Thu Aug 14 17:30:01 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class VxmlCONTEXT implements java.io.Serializable, Cloneable, IRNSContainer, IVxmlJVOICEMixed, IVxmlJVOICEMixedChoice, IVxmlPITCHMixed, IVxmlPITCHMixedChoice, IVxmlEmphasisMixed, IVxmlEmphasisMixedChoice, IVxmlLANGMixed, IVxmlLANGMixedChoice, IVxmlParagraphMixed, IVxmlParagraphMixedChoice, IVxmlSentenceMixed, IVxmlSentenceMixedChoice, IVxmlPARTOFSPMixed, IVxmlPARTOFSPMixedChoice, IVxmlPMixed, IVxmlPMixedChoice, IVxmlSMixed, IVxmlSMixedChoice, IVxmlPRONMixed, IVxmlPRONMixedChoice, IVxmlRATEMixed, IVxmlRATEMixedChoice, IVxmlVOLUMEMixed, IVxmlVOLUMEMixedChoice, IVxmlEnumerateMixed, IVxmlEnumerateMixedChoice, IVxmlEMPHMixed, IVxmlEMPHMixedChoice, IVxmlSPELLMixed, IVxmlSPELLMixedChoice, IVxmlSPEECHMixed, IVxmlSPEECHMixedChoice, IVxmlCONTEXTMixed, IVxmlCONTEXTMixedChoice, IRVisitable, IRNode, IVxmlEmotionMixed, IVxmlEmotionMixedChoice, IVxmlVoiceMixed, IVxmlVoiceMixedChoice, IVxmlProsodyMixed, IVxmlProsodyMixedChoice, IVxmlAudioMixed, IVxmlAudioMixedChoice, IVxmlChoiceMixed, IVxmlChoiceMixedChoice, IVxmlPromptMixed, IVxmlPromptMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String TYPE_;
    private String FORMAT_;
    private String DELIM_;
    // List<IVxmlCONTEXTMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlCONTEXT</code>.
     *
     */
    public VxmlCONTEXT() {
    }

    /**
     * Creates a <code>VxmlCONTEXT</code>.
     *
     * @param source
     */
    public VxmlCONTEXT(VxmlCONTEXT source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlCONTEXT</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlCONTEXT(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlCONTEXT</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlCONTEXT(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlCONTEXT</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlCONTEXT(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlCONTEXT</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCONTEXT(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlCONTEXT</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCONTEXT(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlCONTEXT</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCONTEXT(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlCONTEXT</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCONTEXT(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlCONTEXT</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCONTEXT(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlCONTEXT</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCONTEXT(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code> by the VxmlCONTEXT <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlCONTEXT source) {
        int size;
        setTYPE(source.getTYPE());
        setFORMAT(source.getFORMAT());
        setDELIM(source.getDELIM());
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlCONTEXTMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        TYPE_ = URelaxer.getAttributePropertyAsString(element, "TYPE");
        FORMAT_ = URelaxer.getAttributePropertyAsString(element, "FORMAT");
        DELIM_ = URelaxer.getAttributePropertyAsString(element, "DELIM");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlProsody.isMatch(stack)) {
                addContent(new VxmlProsody(stack));
            } else if (VxmlVoice.isMatch(stack)) {
                addContent(new VxmlVoice(stack));
            } else if (VxmlEmotion.isMatch(stack)) {
                addContent(new VxmlEmotion(stack));
            } else if (VxmlREGWORD.isMatch(stack)) {
                addContent(new VxmlREGWORD(stack));
            } else if (VxmlJVOICE.isMatch(stack)) {
                addContent(new VxmlJVOICE(stack));
            } else if (VxmlCONTEXT.isMatch(stack)) {
                addContent(new VxmlCONTEXT(stack));
            } else if (VxmlPITCH.isMatch(stack)) {
                addContent(new VxmlPITCH(stack));
            } else if (VxmlBreak.isMatch(stack)) {
                addContent(new VxmlBreak(stack));
            } else if (VxmlEmphasis.isMatch(stack)) {
                addContent(new VxmlEmphasis(stack));
            } else if (VxmlPhoneme.isMatch(stack)) {
                addContent(new VxmlPhoneme(stack));
            } else if (VxmlSayAs.isMatch(stack)) {
                addContent(new VxmlSayAs(stack));
            } else if (VxmlParagraph.isMatch(stack)) {
                addContent(new VxmlParagraph(stack));
            } else if (VxmlP.isMatch(stack)) {
                addContent(new VxmlP(stack));
            } else if (VxmlSentence.isMatch(stack)) {
                addContent(new VxmlSentence(stack));
            } else if (VxmlS.isMatch(stack)) {
                addContent(new VxmlS(stack));
            } else if (VxmlLANG.isMatch(stack)) {
                addContent(new VxmlLANG(stack));
            } else if (VxmlPARTOFSP.isMatch(stack)) {
                addContent(new VxmlPARTOFSP(stack));
            } else if (VxmlPRON.isMatch(stack)) {
                addContent(new VxmlPRON(stack));
            } else if (VxmlRATE.isMatch(stack)) {
                addContent(new VxmlRATE(stack));
            } else if (VxmlVOLUME.isMatch(stack)) {
                addContent(new VxmlVOLUME(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlMark.isMatch(stack)) {
                addContent(new VxmlMark(stack));
            } else if (VxmlBOOKMARK.isMatch(stack)) {
                addContent(new VxmlBOOKMARK(stack));
            } else if (VxmlEMPH.isMatch(stack)) {
                addContent(new VxmlEMPH(stack));
            } else if (VxmlSPELL.isMatch(stack)) {
                addContent(new VxmlSPELL(stack));
            } else if (VxmlSILENCE.isMatch(stack)) {
                addContent(new VxmlSILENCE(stack));
            } else if (VxmlSPEECH.isMatch(stack)) {
                addContent(new VxmlSPEECH(stack));
            } else if (VxmlRESET.isMatch(stack)) {
                addContent(new VxmlRESET(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlCONTEXT(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "CONTEXT");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.TYPE_ != null) {
            URelaxer.setAttributePropertyByString(element, "TYPE", this.TYPE_);
        }
        if (this.FORMAT_ != null) {
            URelaxer.setAttributePropertyByString(element, "FORMAT", this.FORMAT_);
        }
        if (this.DELIM_ != null) {
            URelaxer.setAttributePropertyByString(element, "DELIM", this.DELIM_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCONTEXTMixed value = (IVxmlCONTEXTMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlCONTEXT</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContent(String text) {
        setContent(new RString(text));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContentByString(String text) {
        setContent(new RString(text));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>TYPE</b>.
     *
     * @return String
     */
    public final String getTYPE() {
        return (TYPE_);
    }

    /**
     * Sets the String property <b>TYPE</b>.
     *
     * @param TYPE
     */
    public final void setTYPE(String TYPE) {
        this.TYPE_ = TYPE;
    }

    /**
     * Gets the String property <b>FORMAT</b>.
     *
     * @return String
     */
    public final String getFORMAT() {
        return (FORMAT_);
    }

    /**
     * Sets the String property <b>FORMAT</b>.
     *
     * @param FORMAT
     */
    public final void setFORMAT(String FORMAT) {
        this.FORMAT_ = FORMAT;
    }

    /**
     * Gets the String property <b>DELIM</b>.
     *
     * @return String
     */
    public final String getDELIM() {
        return (DELIM_);
    }

    /**
     * Sets the String property <b>DELIM</b>.
     *
     * @param DELIM
     */
    public final void setDELIM(String DELIM) {
        this.DELIM_ = DELIM;
    }

    /**
     * Gets the IVxmlCONTEXTMixed property <b>content</b>.
     *
     * @return IVxmlCONTEXTMixed[]
     */
    public final IVxmlCONTEXTMixed[] getContent() {
        IVxmlCONTEXTMixed[] array = new IVxmlCONTEXTMixed[content_.size()];
        return ((IVxmlCONTEXTMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlCONTEXTMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlCONTEXTMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlCONTEXTMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlCONTEXTMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlCONTEXTMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlCONTEXTMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlCONTEXTMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlCONTEXTMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlCONTEXTMixed property <b>content</b>.
     *
     * @return int
     */
    public final int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlCONTEXTMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlCONTEXTMixed
     */
    public final IVxmlCONTEXTMixed getContent(int index) {
        return ((IVxmlCONTEXTMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlCONTEXTMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IVxmlCONTEXTMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlCONTEXTMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void addContent(int index, IVxmlCONTEXTMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlCONTEXTMixed property <b>content</b> by index.
     *
     * @param index
     */
    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlCONTEXTMixed property <b>content</b> by object.
     *
     * @param content
     */
    public final void removeContent(IVxmlCONTEXTMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlCONTEXTMixed property <b>content</b>.
     *
     */
    public final void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "CONTEXT", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (TYPE_ != null) {
            buffer.append(" ");
            buffer.append("TYPE");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getTYPE())));
            buffer.append("\"");
        }
        if (FORMAT_ != null) {
            buffer.append(" ");
            buffer.append("FORMAT");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFORMAT())));
            buffer.append("\"");
        }
        if (DELIM_ != null) {
            buffer.append(" ");
            buffer.append("DELIM");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDELIM())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCONTEXTMixed value = (IVxmlCONTEXTMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCONTEXTMixed value = (IVxmlCONTEXTMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "CONTEXT", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "CONTEXT", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (TYPE_ != null) {
            buffer.write(" ");
            buffer.write("TYPE");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getTYPE())));
            buffer.write("\"");
        }
        if (FORMAT_ != null) {
            buffer.write(" ");
            buffer.write("FORMAT");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFORMAT())));
            buffer.write("\"");
        }
        if (DELIM_ != null) {
            buffer.write(" ");
            buffer.write("DELIM");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDELIM())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCONTEXTMixed value = (IVxmlCONTEXTMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCONTEXTMixed value = (IVxmlCONTEXTMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "CONTEXT", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "CONTEXT", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (TYPE_ != null) {
            buffer.print(" ");
            buffer.print("TYPE");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getTYPE())));
            buffer.print("\"");
        }
        if (FORMAT_ != null) {
            buffer.print(" ");
            buffer.print("FORMAT");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFORMAT())));
            buffer.print("\"");
        }
        if (DELIM_ != null) {
            buffer.print(" ");
            buffer.print("DELIM");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDELIM())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCONTEXTMixed value = (IVxmlCONTEXTMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCONTEXTMixed value = (IVxmlCONTEXTMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "CONTEXT", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTYPEAsString() {
        return (URelaxer.getString(getTYPE()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFORMATAsString() {
        return (URelaxer.getString(getFORMAT()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDELIMAsString() {
        return (URelaxer.getString(getDELIM()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTYPEByString(String string) {
        setTYPE(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFORMATByString(String string) {
        setFORMAT(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDELIMByString(String string) {
        setDELIM(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlCONTEXT</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "CONTEXT")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProsody.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmotion.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlREGWORD.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlJVOICE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCONTEXT.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPITCH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBreak.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmphasis.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPhoneme.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSayAs.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlParagraph.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSentence.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlS.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLANG.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPARTOFSP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPRON.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRATE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVOLUME.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMark.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBOOKMARK.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEMPH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPELL.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSILENCE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPEECH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRESET.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlCONTEXT</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlCONTEXT</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
