package relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>GramOneOf</b> is generated from vxml20.rxg by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="one-of">
 *   <ref label="item" occurs="*"/>
 * </elementRule>
 * 
 * <tag name="one-of"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="one-of"&gt;
 *   &lt;ref label="item" occurs="*"/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="one-of"/&gt;
 * </pre>
 *
 * @version vxml20.rxg (Thu Aug 14 17:30:01 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class GramOneOf implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IGramItemMixed, IGramItemMixedChoice, IGramRuleMixed, IGramRuleMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
    // List<GramItem>
    private java.util.List item_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>GramOneOf</code>.
     *
     */
    public GramOneOf() {
    }

    /**
     * Creates a <code>GramOneOf</code>.
     *
     * @param source
     */
    public GramOneOf(GramOneOf source) {
        setup(source);
    }

    /**
     * Creates a <code>GramOneOf</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public GramOneOf(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>GramOneOf</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public GramOneOf(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>GramOneOf</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public GramOneOf(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>GramOneOf</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public GramOneOf(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>GramOneOf</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public GramOneOf(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>GramOneOf</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public GramOneOf(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>GramOneOf</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public GramOneOf(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>GramOneOf</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public GramOneOf(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>GramOneOf</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public GramOneOf(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>GramOneOf</code> by the GramOneOf <code>source</code>.
     *
     * @param source
     */
    public void setup(GramOneOf source) {
        int size;
        this.item_.clear();
        size = source.item_.size();
        for (int i = 0;i < size;i++) {
            addItem((GramItem)source.getItem(i).clone());
        }
    }

    /**
     * Initializes the <code>GramOneOf</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>GramOneOf</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>GramOneOf</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        item_.clear();
        while (true) {
            if (GramItem.isMatch(stack)) {
                addItem(new GramItem(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new GramOneOf(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS", "one-of");
        rNSContext_.setupNamespace(element);
        int size;
        size = this.item_.size();
        for (int i = 0;i < size;i++) {
            GramItem value = (GramItem)this.item_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>GramOneOf</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>GramOneOf</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>GramOneOf</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>GramOneOf</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>GramOneOf</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>GramOneOf</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the GramItem property <b>item</b>.
     *
     * @return GramItem[]
     */
    public final GramItem[] getItem() {
        GramItem[] array = new GramItem[item_.size()];
        return ((GramItem[])item_.toArray(array));
    }

    /**
     * Sets the GramItem property <b>item</b>.
     *
     * @param item
     */
    public final void setItem(GramItem[] item) {
        this.item_.clear();
        for (int i = 0;i < item.length;i++) {
            addItem(item[i]);
        }
        for (int i = 0;i < item.length;i++) {
            item[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the GramItem property <b>item</b>.
     *
     * @param item
     */
    public final void setItem(GramItem item) {
        this.item_.clear();
        addItem(item);
        if (item != null) {
            item.rSetParentRNode(this);
        }
    }

    /**
     * Adds the GramItem property <b>item</b>.
     *
     * @param item
     */
    public final void addItem(GramItem item) {
        this.item_.add(item);
        if (item != null) {
            item.rSetParentRNode(this);
        }
    }

    /**
     * Adds the GramItem property <b>item</b>.
     *
     * @param item
     */
    public final void addItem(GramItem[] item) {
        for (int i = 0;i < item.length;i++) {
            addItem(item[i]);
        }
        for (int i = 0;i < item.length;i++) {
            item[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the GramItem property <b>item</b>.
     *
     * @return int
     */
    public final int sizeItem() {
        return (item_.size());
    }

    /**
     * Gets the GramItem property <b>item</b> by index.
     *
     * @param index
     * @return GramItem
     */
    public final GramItem getItem(int index) {
        return ((GramItem)item_.get(index));
    }

    /**
     * Sets the GramItem property <b>item</b> by index.
     *
     * @param index
     * @param item
     */
    public final void setItem(int index, GramItem item) {
        this.item_.set(index, item);
        if (item != null) {
            item.rSetParentRNode(this);
        }
    }

    /**
     * Adds the GramItem property <b>item</b> by index.
     *
     * @param index
     * @param item
     */
    public final void addItem(int index, GramItem item) {
        this.item_.add(index, item);
        if (item != null) {
            item.rSetParentRNode(this);
        }
    }

    /**
     * Remove the GramItem property <b>item</b> by index.
     *
     * @param index
     */
    public final void removeItem(int index) {
        this.item_.remove(index);
    }

    /**
     * Remove the GramItem property <b>item</b> by object.
     *
     * @param item
     */
    public final void removeItem(GramItem item) {
        this.item_.remove(item);
    }

    /**
     * Clear the GramItem property <b>item</b>.
     *
     */
    public final void clearItem() {
        this.item_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
        buffer.append("<");
        URelaxer.makeQName(prefix, "one-of", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.append(">");
        size = this.item_.size();
        for (int i = 0;i < size;i++) {
            GramItem value = (GramItem)this.item_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "one-of", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
        buffer.write("<");
        URelaxer.makeQName(prefix, "one-of", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.write(">");
        size = this.item_.size();
        for (int i = 0;i < size;i++) {
            GramItem value = (GramItem)this.item_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "one-of", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
        buffer.print("<");
        URelaxer.makeQName(prefix, "one-of", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.print(">");
        size = this.item_.size();
        for (int i = 0;i < size;i++) {
            GramItem value = (GramItem)this.item_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "one-of", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(item_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>GramOneOf</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS", "one-of")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (!GramItem.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>GramOneOf</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>GramOneOf</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
