/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: AudioOutItem.java,v 1.3 2006/10/20 08:11:38 nishi Exp $
 */

package outitem;

import util.Util;
import main.*;

public class AudioOutItem extends OutItem
{
    private String src_;
	private Debug dbg = new Debug("SND", 0);

	private boolean useSND = Util.getPropertyBoolean("UseSND", false);
	
    public String getArg() { 
    	return doEvaluate(src_); 
    }

    public AudioOutItem(String src, boolean bargein)
    {
		myDevice_ = OutputDevices.Type.AUDIO;
		if (useSND) {
			isInstant_ = false;
		} else {
			isInstant_ = true;
		}
		src_ = src;
		bargein_ = bargein;
    }

    public AudioOutItem(String src)
    {
		myDevice_ = OutputDevices.Type.AUDIO;
		if (useSND) {
			isInstant_ = false;
		} else {
			isInstant_ = true;
		}
		src_ = src;
		gs_ = null;
    }

    public void doOutput(OutputDevices od)
    {
		if (useSND) {
			OutputDevice d = od.getDevice(myDevice_);
			d.outputDeviceStart(this);
		} else {
			dbg.print("doOutput ignored");
		}
    }

    public String toString()
    {
		String s = "<audio";
		if ( bargein_ == false ) {
		    s += " bargein=\"false\"";
		}
		s += ">";
		s += src_;
		s += "</audio>";
		return s;
    }
}
