/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: InteractionControler.java,v 1.2 2006/10/18 08:16:36 nishi Exp $
 */

package main;

import java.util.*;
import java.net.*;
import java.io.File;
import scripting.ECMAScript;
import util.*;
import outitem.*;
import command.*;


public class InteractionControler
implements MMMListener, HttpManagerListener
{
	
	private Debug dbg = new Debug("IC", 0);
	private InterpreterContextManager icm_;
	private MultiModalManager mmm_;
	private OutQueueManager oqm_;
	private HttpManager httpm_;
	
	private ECMAScript script_ = null;  // ECMAScript Ķ
	
	// ѻ??
	private URL fetchingURL_;
	private boolean reservefetch_ = false; // եå䤯
	private boolean fetching_ = false;  // ɥȥեå
	
	// ʲ loadDocument Ȥ׽
	private boolean endflag_ = false;   // λ
	private boolean endimm_ = false;    // ľ˽λ
	private boolean nextout_ = false;   // νϥƥ
	private boolean nextcmd_ = true;    // Υޥ
	private boolean inputbusy_ = false; // ϥӥ
	private Vector commands_ = null;
	private String nextDocFile_ = ""; // mainLoop λ˺ٸƤФ
	
	//private Vector instantouts_ = null; // bargein ˤϤɬפȤʤ OutItem
	
	public void setNextDocFile(String s) 
	{ 
		nextDocFile_ = s; 
	}
	
	public String getNextDocFile() 
	{ 
		if (nextDocFile_ == null) return "";
		return nextDocFile_; 
	}
	
	// :ƥ饹
	public InteractionControler() throws Exception 
	{
		dbg.print("IC: constructor begin.");
		icm_ = new InterpreterContextManager();
		mmm_ = new MultiModalManager();
		
		oqm_ = new OutQueueManager();
		httpm_ = HttpManager.getInstance();
		mmm_.setListener(this);
		
		//instantouts_ = new Vector();
		
		script_ = new ECMAScript();
		mmm_.setECMAScript(script_);
		dbg.print("IC: constructor done.");
	}
	
	public void loadDocument(String fn) throws Exception
	{
		DocLoader doc = new DocLoader(fn, fn);
		icm_.setDocument(doc);
		mmm_.prepareGrammar(icm_.getGrammarSet());
		
		endflag_ = false;   // λ
		endimm_ = false;    // ľ˽λ
		nextout_ = false;   // νϥƥ
		nextcmd_ = true;    // Υޥ
		inputbusy_ = false; // ϥӥ
		commands_ = null;
		nextDocFile_ = ""; // mainLoop λ˺ٸƤФ
		
	}
	
	
	//
	// INPUT_END νԤ wait()
	//
	// IC: waitWhileInputBusy: begin.
	// IC: update: INPUT_END event from Thread-AM
	// IC: update: icm.inputText Ϥ
	// IC: update: mmm.instantOutput <break length="10.0"/>
	// IC: waitWhileInputBusy: done.
	//
	private synchronized void waitWhileInputBusy()
	{
		dbg.print("IC: waitWhileInputBusy: begin.");
		while (inputbusy_) {
			try { wait(); } catch(Exception e){e.printStackTrace();}
		}
		dbg.print("IC: waitWhileInputBusy: done.");
	}
	
	private void executeAllCommands()
	{
		while (!commands_.isEmpty()) {
			//dbg.print("IC: removing command...");
			Command cmd = (Command)commands_.remove(0);
			
			String _str = cmd.toString();
			_str = Util.removeNewLines(_str);
			if ( _str.length() > 40 ) {
				_str = _str.substring(0,40) + "...";
			}
			dbg.print("IC: cmd:" + _str);
			cmd.setECMAScript(script_);
			cmd.execute(this);
		}
	}
	
	//
	// OutQueue  item Ϥ
	// λ
	//  1: (return true)  ֻϤϤ
	//  2: (return false) ֻϤΤߤ OutQueue Ϥ
	//
	// nextout_ = true ˤʤ
	//  1: OUTPUT_END event 
	//  2: AddOutItemCommand
	//
	private boolean outputItems()
	{
		boolean output_something = false;
		while (nextout_) {
			dbg.print("IC: outputItems: begin.");
			//_nextOutItem();
			OutItem o = oqm_.dequeue();
			if (o != null) {
				String _s =  o.getClass().getName();
				nextout_ = mmm_.output(o); 
				dbg.print("IC: outputItems: "+ _s +" done. nextout=" + nextout_);	
				if ( ! nextout_ ) {
					// ֻϤǤʤΤ¹
					dbg.print("IC: outputItems: output_something = true");	
					output_something = true;
				}
			} else { // o == null
				if(reservefetch_) {
					reservefetch_ = false;
					fetchstart();
				} else {
					icm_.noinput();
				}
				nextout_ = false;
				nextcmd_ = true;
			}
		}
		return output_something;
	}
	
	// updateMMMStatus() Ԥ
	// 
	// IC: waitOutputEndEvent: begin.
	// IC: update: INPUT_START event from Thread-AM
	// IC: update: mmm.stop
	// IC: update: OUTPUT_END event from Thread-AM
	// IC: update: OUTPUT_END event from Thread-AM
	// IC: waitOutputEndEvent: done.
	// 
	private synchronized void waitOutputEndEvent()
	{
		dbg.print("IC: waitOutputEndEvent: begin.");
		try { wait(); } catch(Exception e){e.printStackTrace();}
		dbg.print("IC: waitOutputEndEvent: done.");
	}
	
	
	private boolean iteration()
	{
		/*
		 dbg.print("IC ----- Go nextcmd:" + nextcmd_ + " nextout:" + nextout_ 
		 + " endflag:" + endflag_ + " endimm:" + endimm_, 8);
		 dbg.print("IC ----- inputbusy:" + inputbusy_ 
		 + " reservefetch:" + reservefetch_, 8);
		 */
		
		boolean output_something = false; // by nishi
		
		// while(nextcmd_)
		// nextcmd_: Ϥ٤ command ĤäƤ=true
		do {
			
			waitWhileInputBusy();
			
			if (nextcmd_ && !endflag_) {
				nextcmd_ = false;
				
				//_process(icm_.getCmd());
				//dbg.print("IC: icm.getCmd");
				commands_ = icm_.getCmd();
				dbg.print("IC: iteration: icm.getCmd done.");
				
				executeAllCommands();
			}
			
			dbg.print("IC:" + 
					" endflag:" + endflag_ + " endimm:" + endimm_ +
					" nextcmd:" + nextcmd_ + " nextout:" + nextout_ +
					" inputbusy:" + inputbusy_ 		      
			);
			
			/*
			 if (endflag_ && (endimm_ || nextcmd_)) {
			 return false;
			 }
			 */
			if (endflag_) {
				if ( endimm_ || (nextout_ == false) ) { 
					commands_.removeAllElements();
					oqm_.discard();
					dbg.print("IC: iteration done.");
					return false;
				}
			}
			
			output_something = outputItems();
			
		} while (nextcmd_);
		
		if ( output_something ) {
			waitOutputEndEvent();
		} else {
			// noinput ٥ȤνԤ
			icm_.noinput();
			dbg.print("IC: iteration: icm.noinput done. inputbusy = false.");
			
			inputbusy_ = false;
			nextcmd_ = true;
		}
		return true;
	}
	
	
	// ᥤ롼
	public void mainLoop()
	{
		while (iteration())
			;
		dbg.print("IC: mainLoop done.");
	}
	
	
	private void _finalize()
	{
		String fincom = System.getProperty("FinCommand");
		if (fincom != null) {
			SubProcess fin = new SubProcess(fincom);
			if(!fin.Run()) {
				System.err.println("Cannot run fin.");
			}
			fin.destroy();
		}
	}
	
	public void terminate()
	{
		mmm_.terminate();
//		ECMAScript.doExit();
		_finalize();
	}
	
	public synchronized void updateHTTPMStatus(HttpManagerEvent evt)
	{
		dbg.print("IC: HTTPManager event");
		fetching_ = false;
		fetchingURL_ = null;
		mmm_.stop();
		nextcmd_ = true;
		String path = evt.getUrl().toString();
		try {
			//icm_.newDocument(httpm_.getFile(evt.getUrl()), path);
			icm_.newDocument(evt.getUrl().toString(), path);
		} catch(DocError e){
			System.err.println();
			System.err.println(e);
			System.err.println("IC: stopped.");
			e.printStackTrace();
		} catch(java.lang.Exception e){
			e.printStackTrace();
		}
		notifyAll();
		
	}
	
	public synchronized void updateMMMStatus(MMMEvent evt)
	{
		
		MMMEvent.Type type = evt.getEventType();
		String sender = Thread.currentThread().getName();
		
		if(type == MMMEvent.Type.INPUT_END) {
			
			String text = evt.getString();
			dbg.print("IC: update: INPUT_END event "+ text +" from " + sender );
			
			if(inputbusy_ != true) {
				dbg.print("IC: update: ignored (because inputbusy == false)");
				return;
			}
			
			if(fetching_) {
				httpm_.maskEvent(fetchingURL_);
				fetchingURL_ = null;
				fetching_ = false;
			}
			
			dbg.print("IC: update: icm.inputText " + text );
			icm_.inputText(text);
			
			String ct = Thread.currentThread().getName();
			if ( ct.equals("main") ) {
				OutItem o;
				while((o = oqm_.dequeue()) != null) {
					//dbg.print("IC: update: mmm.instantOutput " + o.toString() );
					//mmm_.instantOutput(o);
					if(o.isInstant()) {
						mmm_.outputNow(o);
					}
				}
				dbg.print("IC: update: inputbusy = false");
				nextcmd_ = true;
			} else {
				oqm_.removeDelayedItems();
			}
			inputbusy_ = false;
			notifyAll();
		}
		else if(type == MMMEvent.Type.INPUT_START) {
			
			dbg.print("IC: update: INPUT_START event from " + sender );
			dbg.print("IC: update: mmm.stop");
			mmm_.stop();
			
			dbg.print("IC: update: inputbusy = true");
			inputbusy_ = true;
			
		}
		else if(type == MMMEvent.Type.OUTPUT_END) {
			dbg.print("IC: update: OUTPUT_END event from " + sender );
			nextout_ = true;
			notifyAll();
		}
	}
	
	public void enqueueOutput(OutItem oi)
	{
		oqm_.enqueue(oi);
	}
	
	public void setNextOut(boolean b)
	{
		nextout_ = b;
	}
	
	public void setEndFlag(boolean b)
	{
		dbg.print("IC: setEndFlag " + b );
		endflag_ = b;
	}
	
	public void setEndImm(boolean b)
	{
		dbg.print("IC: setEndImm " + b );
		endimm_ = b;
	}
	
	public void setFetchingURL(URL u)
	{
		fetchingURL_ = u;
	}
	
	// called from HttpGetCommand
	public void setReserveFetch(boolean b)
	{
		reservefetch_ = b;
	}
	
	/*
	 public ECMAScript getScript()
	 {
	 return script_;
	 }
	 */
	
	public synchronized int getNumCommands()
	{
		if ( commands_ == null ) return 0;
		return commands_.size();
	}
	
	
	public synchronized void insertCommandsTop(Vector v)
	{
		if ( commands_ == null ) return;
		commands_.addAll(0, v);
	}
	
	
	public void fetchstart()
	{
		
		if(httpm_.isCached(fetchingURL_)) {
			String path = fetchingURL_.toString();
			try {
				icm_.newDocument(fetchingURL_.toString(), path);
			} catch(DocError e){
				System.err.println();
				System.err.println(e);
				System.err.println("IntractionControler stopped.");
				e.printStackTrace();
			} catch(java.lang.Exception e){
				e.printStackTrace();
			}
			fetchingURL_ = null;
		}
		else {
			
			fetching_ = true;
			httpm_.fetchStart(fetchingURL_, this);
			
		}
		
	}
	
	public void setNextState(String state)
	{
		dbg.print("IC: next: "+state);
		icm_.setNextState(state);
	}
	
	public void gotoState(String state)
	{
		dbg.print("IC: goto: "+state);
		icm_.setNextState(state);
		commands_.removeAllElements();
	}
	
}
