/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: DocLoader.java,v 1.1 2006/08/24 03:45:43 nishi Exp $
 */

package main;

import java.util.*;
import java.io.*;
import javax.xml.parsers.*;
import java.net.*;
import org.w3c.dom.*;
import document.*;

public class DocLoader
{

    private AbstractDoc doc;
    private StateMap stateMap;

    /**
     * http ͳǤ path ν
     * @param file: ˥å夵줿ե
     * @param path: å帵Υեpath
     */
    public DocLoader(String filename, String path) throws Exception
    {
	//ɥȥӥ
	DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	DocumentBuilder builder = factory.newDocumentBuilder();
	//ѡ
	Document root;
	if (filename.startsWith("http:")) {
	    String buf = "";
	    URL url = new URL(filename);
	    HttpURLConnection uc;
	    uc = (HttpURLConnection)url.openConnection();
	    uc.setRequestMethod("GET");
	    InputStreamReader isr = new InputStreamReader(uc.getInputStream());
	    BufferedReader br = new BufferedReader(isr);
	    while(true) {
		String line = br.readLine();
		if (line == null) 
		    break;
		buf += line;
	    }
	    root = builder.parse(new ByteArrayInputStream(buf.getBytes()));
	    br.close();
	    uc.disconnect();
	} else {
	    root = builder.parse(filename);
	}

	//ɥǤμФ
	Element elem = root.getDocumentElement();
	
	String topName;
	if (elem.getNodeType() == Node.ELEMENT_NODE) {
	    topName = elem.getNodeName();
	} else {
	    topName = "";
	}
	
	// Ǿ <vxml> <rdoc> ʤɤˤäʬ
	if( topName.equals("vxml") )
	    doc = new VXMLDoc(elem, path);
	else if( topName.equals("pdoc") )
	    doc = new RawPhoenixDoc(elem, path);
	else {
	    doc = null;
	    throw new DocError("Not a valid document.");
	}
    }

    public StateMap getStateMap()
    {

	if(doc != null)
	    return (stateMap = (doc.getStateMap()));
	else
	    return null;

    }

    public static void convert(String src)
    {
	try {

	    DocLoader loader = new DocLoader(src, src);
	    StateMap stateMap = loader.getStateMap();
	    if (stateMap == null) {
		System.err.println("DocLoader stopped: stateMap null.");
		return;
	    }
	    
	    // stateMap  XML ɽ
	    String s = stateMap.toString();
	    System.out.print(s);
	} catch(DocError e){
	    System.err.println();
	    System.err.println(e);
	    System.err.println("DocLoader stopped.");
	} catch(java.io.FileNotFoundException e){
	    System.err.println();
	    System.err.println(e);
	    System.err.println("DocLoader stopped.");
	} catch(org.xml.sax.SAXParseException e){
	    System.err.println();
	    System.err.println(e);
	    System.err.println("Source:"+src);
	    System.err.println("Line:"+e.getLineNumber()+" Column:"+e.getColumnNumber());
	    System.err.println("DocLoader stopped.");
	} catch(java.lang.Exception e){
	    e.printStackTrace();
	}
    }

}
