/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: ContentState.java,v 1.1 2006/08/24 03:45:43 nishi Exp $
 */

package main;

import java.util.*;

import command.*;
import outitem.*;
import util.*;

public class ContentState
{

    private String name_;
    private boolean isExecOnly_; // ٥ȤȤʤ֤
    private Vector commands_;    // Vector<Command>
    private HashArray evtHandler_;     // Map<String, String> ()

    public ContentState()
    {
	commands_ = new Vector();
	evtHandler_ = new HashArray(); 
	//evtHandler_ = new Hashtable();
	//isExecOnly_ = true;
	isExecOnly_ = false;
    }

    public Vector getCommands()
    {
	return commands_;
    }

    public void addCommand(Command c)
    {
	commands_.add((Object)c);
    }

    public void addCommandOnTop(Command c)
    {
	// [0] ľ insert 뤿ź 1 
	commands_.add(1,(Object)c);
    }

    /*
    public HashArray getEventHandlers()
    {
	return evtHandler_;
    }
    */ 

    public String getEventHandler(String name)
    {
	return (String)evtHandler_.get(name);
    }

    public String findEventHandler(String input)
    {
	// matches ¸
	for ( int k = 0; k < evtHandler_.size(); k++ ) {
	    String regex = evtHandler_.getKey(k);
	    if (input.matches(regex)) {
		return (String)evtHandler_.get(regex);
	    }
	}
	return null;
    }

    public String putEventHandler(String name, String next)
    {
	// Ԥ null
	return (String)evtHandler_.put(name, (Object)next);
    }

    public String toString()
    {
	StringBuffer s = new StringBuffer("");
	s.append("<state id=\""+name_+"\"");

	if ( evtHandler_.has("<next>") ) {
	    s.append(" next=\"" + evtHandler_.get("<next>") + "\"");
	}

	s.append(">\n");

	//
	// <command>
	//
	s.append(" <cmd>\n");
	Iterator j = commands_.iterator();
	while ( j.hasNext() ) {
	    Command c = (Command) j.next();
	    s.append(c.toString());
	    s.append("\n");
	}
	s.append(" </cmd>\n");

	//
	// <weather>
	//  <when></when>
	// </weather>
	//
	// <catch object="//weather/when">
	//  <assign var="form_weather.field_when" path="./when">
	//  <script>weather.when$.justfilled = true</script>
	//  <goto>'@weather.@process'</goto>
	// </catch>
	//
	for ( int k = 0; k < evtHandler_.size(); k++ ) {
	    String s1 = evtHandler_.getKey(k);
	    if (s1.equals("<next>")) 
		continue;
	    String s1x = Util.encodeXmlChars(s1);
	    String s2 = (String)evtHandler_.get(k);
	    if (s1.equals("<nomatch>")) {
		s.append(" <nomatch><goto>'"+s2+"'</goto></nomatch>\n");
	    } else {
		s.append(" <catch text=\""+s1x+"\">\n");
		s.append("  <goto>'"+s2+"'</goto>\n");
		s.append(" </catch>\n");
	    }
	}

	s.append("</state>\n");
	return s.toString();
    }

    public String getName()
    {
	return name_;
    }

    public void setName(String s)
    {
	name_ = s;
    }

    public boolean isExecOnly()
    {
	return isExecOnly_;
    }

    public void setExecOnly(boolean b)
    {
	isExecOnly_ = b;
    }


    public static void main(String args[]) throws Exception
    {
	String s1, regex;

	s1 = "֤ˤƲ";
	regex = ".*";
	System.out.println("match:"+ s1.matches(regex));

	s1 = "λޤ";
	regex = "(λޤ|ޤ)";
	System.out.println("match:"+ s1.matches(regex));
    }
}
