/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: BreakThread.java,v 1.1 2006/08/24 03:45:43 nishi Exp $
 */
package main;
import outitem.*;

public class BreakThread extends Thread implements OutputDevice
{

    private Debug dbg = new Debug(0);
    private DeviceListener listener_;
    private long millis_ = 0;
    private boolean start_ = false;
    private boolean term_ = false;

    public BreakThread()
    {
	setName("Thread Break");
    }

    public synchronized void outputDeviceStart(OutItem obj)
    {
	if (obj instanceof BreakOutItem) {
	    BreakOutItem bo = (BreakOutItem)obj;
	    dbg.print("Break output\n");
	    //Double ms = new Double(((Double)obj).doubleValue() * 1000.0);
	    Double ms = new Double(bo.getArgAsDouble() * 1000.0);
	    millis_ = ms.longValue();
	    start_ = true;
	    notify();
	}
    }

    public void setOutputListener(DeviceListener l)
    {

	listener_ = l;

    }

    public synchronized void outputDeviceStop()
    {

	notify();

    }

    public synchronized void terminate()
    {

	term_ = true;
	notify();

    }

    public void run()
    {
	synchronized(this) {
	    for(;;) {

		dbg.print("BreakThread wait");
		try{wait();} catch(Exception e) {e.printStackTrace();}
		if(start_) {
		    dbg.print("Break Start : " + millis_ + " msec");
		    listener_.update(new DeviceEvent(this,
						     DeviceEvent.Type.OUTPUT,
						     DeviceEvent.State.BUSY,
						     null));
		    try{wait(millis_);} catch(Exception e) {e.printStackTrace();}
		    start_ = false;
		    dbg.print("Break End : " + millis_ + " msec");
		    listener_.update(new DeviceEvent(this,
						     DeviceEvent.Type.OUTPUT,
						     DeviceEvent.State.READY,
						     null));

		}
		if(term_) {
		    break;
		}

	    }
	}

	dbg.print("BreakThread exitting...");
	
    }

}
