/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: AMThread.java,v 1.5 2006/10/20 08:11:38 nishi Exp $
 */
package main;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import outitem.AudioOutItem;
import outitem.LogOutItem;
import outitem.NativeOutItem;
import outitem.OutItem;
import outitem.VoiceOutItem;
import util.SubProcess;
import util.Util;

public class AMThread extends Thread implements OutputDevice, InputDevice
{
	private int srmstate = 30; // not prepared
	//
	// 30 : initRecog ¹ 
	// 20 : initRecog ¹Ը LISTEN Ե
	// 10 : to @SIM set SRM_XXX ¹Ը LISTEN Ե
	//  0 : LISTEN λ
	//
	
	private Debug dbg = new Debug("AMThread", 0);
	private DeviceListener recoglistener_;
	private DeviceListener synthlistener_;
	private SubProcess sp_;
//	private String grammar_path = "";
	private boolean showStdErr_ = true;
	
	private boolean useSIM = false;
	private boolean useMON = false;
	private boolean useSND = false;
	private boolean doInitRecogAtConstructor = false;
	
	private boolean doCheckSrmLog = false;
	private String srmMkdfaLogFile = "";
	private String srmJulianLogFile = "";

	private boolean srmError = false;
	private String srmErrorLog = "";

	private boolean srmInsideRecogoutTag = false;
	private boolean srmInsideShypoRankOneTag = false;
	private String srmResult = "";
	
	private String AMCom_;
	
	public AMThread()
	{
		doCheckSrmLog = Util.getPropertyBoolean("DoCheckSrmLog", true);
		srmMkdfaLogFile = Util.getPropertyStr("SrmMkdfaLogFile", "../SRM/temp/mkdfa.log");
		srmJulianLogFile = Util.getPropertyStr("SrmJulianLogFile", "../SRM/temp/julian.log");
		useSND = Util.getPropertyBoolean("UseSND", false);
		useMON = Util.getPropertyBoolean("UseMON", false);
		useSIM = Util.getPropertyBoolean("UseSIM", false);

		String showerr = System.getProperty("AMThread.ShowStdErr");
		if (showerr != null && showerr.equals("1")) {
			showStdErr_ = true;
			dbg.print("AMT: ShowStdErr = true");
		}
		
		String amcom = System.getProperty("AMCommand");
		if (amcom == null) {
			Util.halt("AMThread(): Cannot run AM");
		}
		dbg.print("AMT: AMCommand = "+ amcom);
		AMCom_ = amcom;
		sp_ = new SubProcess(AMCom_);
		
		if(!sp_.Run()) {
			Util.halt("AMThread(): Cannot run AM; " + AMCom_);
		}
		
		setName("Thread-AM");
		
		if (doInitRecogAtConstructor) {
			if ( srmstate == 30 ) {
				_initRecog();
				srmstate = 20;
			}
		}
		
		String s = System.getProperty("AMThread.StartupWait", "10.0");
		int waitms = (int)(Double.parseDouble(s) * 1000.0);
		dbg.print("AMT: StartupWait " + waitms);
		try { 
			Thread.sleep(waitms);
		} catch (Exception e) {e.printStackTrace();}
		dbg.print("AMT: StartupWait " + waitms + " done.");
		
	}
	
	
	public boolean isReady()
	{
		if (doInitRecogAtConstructor) {
			if ( srmstate == 20 ) {
				dbg.print("AMT: isReady = false");
				return false;
			}
		}
		dbg.print("AMT: isReady = true");
		return true;
	}
	
	public boolean isListening() throws GalateaRuntimeError
	{
		if (doCheckSrmLog) {
			try {
				String mkdfaLog = Util.loadFromFile(srmMkdfaLogFile);
				// if not found, indexOf returns -1
				if (mkdfaLog != null && mkdfaLog.indexOf("Error:") > 0) {
					srmErrorLog = "\n[" + srmMkdfaLogFile + "]\n" + mkdfaLog;
					srmError = true;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			try {
				String julianLog = Util.loadFromFile(srmJulianLogFile);
				// if not found, indexOf returns -1
				if (julianLog != null && julianLog.indexOf("cannot access") > 0) {
					srmErrorLog += "\n[" + srmJulianLogFile + "]\n" + julianLog;
					srmError = true;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		if (srmError) {
			dbg.print("AMT: isReady = false (SRM Error)");
			//return false;
			throw new GalateaRuntimeError(srmErrorLog);
		}
		if ( srmstate != 0 )
			return false;
		return true;
	}
	
	
	// SRM 
	//
	private void _initRecog() 
	{
		// _outputNative(initRecogCmd_);
		if (useSIM) {
			outputNative("to @SIM set SRM_Recog = START");
		} else {
			outputNative("to @SRM set Run = INIT");
			outputNative("to @SRM set Run = START");
		}
	}
	
	public void setInputListener(DeviceListener l)
	{
		recoglistener_ = l;
	}
	
	public void setOutputListener(DeviceListener l)
	{
		synthlistener_ = l;
	}
	
	public void outputDeviceStart(OutItem obj)
	{
		if (obj instanceof VoiceOutItem) {
			VoiceOutItem o = (VoiceOutItem)obj;
			outputSpeak(o.getArg());
		} else if (obj instanceof AudioOutItem) {
			AudioOutItem o = (AudioOutItem)obj;
			outputAudio(o.getArg());
		} else if (obj instanceof LogOutItem) {
			LogOutItem o = (LogOutItem)obj;
			outputLog(o.getArg());
		} else if (obj instanceof NativeOutItem) {
			NativeOutItem o = (NativeOutItem)obj;
			outputNative(o.getArg());
		}
	}
	
	public void outputNative(String str)
	{
		sp_.ToStdin(str);
		dbg.print(str);
		if (useMON) {
			// outputNative  Syslog ˽Ϥ
			String lines[] = str.split("\n");
			for (int i = 0; i < lines.length; i++) {
				sp_.ToStdin("to @MON set SysLogText = " + lines[i]);
			}
		}
	}
	
	public void outputSpeak(String str)
	{
		outputNative("to @AM-MCL set Speak = " + str);
	}
	
	public void outputAudio(String str)
	{
		if (useSND) {
			outputNative("to @SND set Play = " + str);
		} else {
			dbg.print("AMT: outputAudio " + str + " ignored.");
		}
	}
	
	public void outputLog(String str)
	{
		if (useMON) {
			outputNative("to @MON set AppLogText = " + str);
		} else {
			dbg.print("AMT: outputLog " + str + " ignored.");
		}
	}
	
	public void outputDeviceStop()
	{
		outputNative("to @AM-MCL set Speak = STOP");
	}
	
	public void setSpeaker(String str)
	{
		outputNative("to @SSM set Speaker = " + str);
	}
	
	/**
	 * return true : wait for ready needed.
	 * return false: ignored
	 */
	public synchronized boolean prepareGrammar(GrammarSet gs)
	{
		dbg.print("AMT: prepareGrammar: " + gs);
		
		if (doInitRecogAtConstructor) {
			if (srmstate == 30 || srmstate == 20) {
				dbg.print("AMT: prepareGrammar: ignored (srmstate" + srmstate +")");
				return false;
			}
		}
		
		if ( gs.getJulian() == true ) {
			String gram = gs.getJulianGramName();
			if (gram == null) {
				//dbg.print("AMT: prepareGrammar: gram == null");
				return false;
			} 
			if (useSIM) {
				outputNative("to @SIM set SRM_Julian = " + gram);
			} else {
				// outputNative("to @SRM set Run = PAUSE");
				outputNative("to @SRM set Run = INIT");
				outputNative("to @SRM set Grammar = " + gram + ".dfa");
				outputNative("to @SRM set Dic = " + gram + ".dict");
				// outputNative("to @SRM set Run = RESUME");
				outputNative("to @SRM set Run = START");
			}
			srmstate = 10;
			
		} else {
			
			String gramStr = gs.getSRMGramStr();
			if ( gramStr == null ) {
				//dbg.print("AMT: prepareGrammar: gramStr == null");
				return false;
			}
			if (useSIM) {
				outputNative("to @SIM set SRM_XML_String = " + gramStr);
			} else {
				// outputNative("to @SRM set Run = RESUME");
				outputNative("to @SRM set Run = INIT");
				outputNative("to @SRM set Grammar << EOF");
				outputNative("to @SRM <?xml version=\"1.0\" encoding=\"EUC-JP\"?>");
				
				gramStr = gramStr.replaceAll("<rule", "\n<rule");
				gramStr = gramStr.replaceAll("<token", "\n <token");
				String lines[] = gramStr.split("\n");
				for (int i = 0; i < lines.length; i++) {
					outputNative("to @SRM " + lines[i]);
				}
				outputNative("to @SRM EOF");
				outputNative("to @SRM set Run = START");
			}
			srmstate = 10;
		}
		dbg.print("AMT: prepareGrammar: waiting for LISTEN");
		return true;
	}
	
	// returns
	//  true  : repeat
	//  false : quit 
	private synchronized boolean iteration()
	{
		if(recoglistener_ == null) {
			dbg.err("AMThread.run(): recoglistener not set");
			return false;
		}
		if(synthlistener_ == null) {
			dbg.err("AMThread.run(): synthlistener not set");
			return false;
		}
		
		String str;
		
		str = sp_.FromStdoutNB();
		if(str == null) {
			dbg.print("AMT: *** sp_.FromStdout() == null ***");
			return false;
		}
		if ( str.length() > 0 ) {
			dbg.print("AMT: " + str);
		} else {
			// dbg.print("AMT: no input");
		}
		
		if (useSIM) {
			Pattern pListen = Pattern.compile("From \\@SIM\\s+tell\\s+status\\s+LISTEN$");
			if (pListen.matcher(str).matches()) {
				if ( srmstate == 10 ) {
					dbg.print("AMT: SRM READY");
					srmstate = 0;
				} 
				if ( srmstate == 20 ) {
					dbg.print("AMT: SRM default grammar active");
					srmstate = 15;
				}
			}
			/*
			 if (srmstate == 20) {
			 dbg.print("AMT: still waiting for SRM READY",2);
			 return true;
			 }
			 */
			Pattern pGrammarError = Pattern.compile("From \\@SIM\\s+tell\\s+status\\s+GRAMMAR_ERROR$");
			if (pGrammarError.matcher(str).matches()) {
				Util.halt("GRAMMAR_ERROR");
			}
			// From @SIM tell status input start from xxx
			// perl.match("/From \\@SIM\\s+tell\\s+status INPUT_START(.*)$/", str)
			// str = perl.group(1);
			Pattern pSIMStart = Pattern.compile
			("From \\@SIM\\s+tell\\s+status INPUT_START (.*)$");
			Matcher mSIMStart = pSIMStart.matcher(str);
			if (mSIMStart.matches()) {
				String g1 = mSIMStart.group(1);
				dbg.print("AMT:SIM tell status INPUT_START " + g1);
				recoglistener_.update
				(new DeviceEvent
						(this, 
								DeviceEvent.Type.INPUT,
								DeviceEvent.State.BUSY,
								g1)
				);
				notify();
			}
			// From @SIM tell result ǧ
			// perl.match("/From \\@SIM\\s+tell\\s+result\\s+(.*)$/", str)
			// srmsentence = perl.group(1);
			Pattern pSIMResult = Pattern.compile
			("From \\@SIM\\s+tell\\s+result\\s+(.*)$");
			Matcher mSIMResult = pSIMResult.matcher(str);
			if (mSIMResult.matches()) {
				String srmsentence = mSIMResult.group(1);
				dbg.print("AMT:SIM tell result " + srmsentence);
				recoglistener_.update
				(new DeviceEvent
						(this,
								DeviceEvent.Type.INPUT,
								DeviceEvent.State.READY,
								srmsentence)
				);
				notify();
				dbg.print("AMT:SIM tell result done.");
			}
		} else { 
			// do not use SIM
			if (str.startsWith("From @SRM tell <INPUT STATUS=\"LISTEN\" ")) {
				if ( srmstate == 10 ) {
					dbg.print("AMT: " + str);
					dbg.print("AMT: SRM READY");
					srmstate = 0;
				} 
			}
			if (str.startsWith("From @SRM tell <INPUT STATUS=\"STARTREC\" ")) {
				recoglistener_.update
				(new DeviceEvent
						(this, 
								DeviceEvent.Type.INPUT,
								DeviceEvent.State.BUSY,
								"")
				);
				notify();
			}
			if (str.startsWith("From @SRM <RECOGOUT>")) {
				srmInsideRecogoutTag = true;
			}
			if (str.startsWith("From @SRM </RECOGOUT>")) {
				srmInsideRecogoutTag = false;
			}
			if (str.startsWith("From @SRM   <SHYPO RANK=\"1\" ")) {
				srmInsideShypoRankOneTag = true;
				srmResult = "";
			}
			if (str.startsWith("From @SRM   </SHYPO>")) {
				srmInsideShypoRankOneTag = false;
				dbg.print("AMT: SRM RESULT " + srmResult);
				recoglistener_.update
				(new DeviceEvent
						(this,
								DeviceEvent.Type.INPUT,
								DeviceEvent.State.READY,
								srmResult)
				);
				notify();
			}
			if (srmInsideRecogoutTag && srmInsideShypoRankOneTag) {
				if (str.startsWith("From @SRM     <WHYPO ")) {
					String s = str.replaceAll("From @SRM     <WHYPO ", "");
					Pattern pat = Pattern.compile(".*WORD=\"([^\"]+)\".*");
					Matcher mat = pat.matcher(s);
					if (mat.matches()) {
						String g1 = mat.group(1);
						dbg.print("AMT: SRM matches word " + g1);
						if (!g1.equals("silB") && !g1.equals("silE") ) {
							int p = g1.indexOf(':');
							if (p >= 0) {
								srmResult += g1.substring(p + 1);
							} else {
								srmResult += g1;
							}
						}
					}
				}
			}
			
		} // useSIM end
		
		//
		// From @SSM rep Speak.stat = SPEAKING
		// From @SSM rep Speak.len = 2210
		// From @SSM rep Speak.utt = sil[290] i[75] ch[100] i[60] i[85] ...
		// From @SSM rep Speak.stat = IDLE
		//
		// perl.match("/From \\@SSM\\s+(.*)$/", str)
		// str = perl.group(1);
		// perl.match("/rep Speak.stat = (.*)$/", str)
		//
		Pattern pSSMSpeakStat = Pattern.compile
		("From \\@SSM\\s+rep Speak.stat = (.*)$");
		Matcher mSSMSpeakStat = pSSMSpeakStat.matcher(str);
		if (mSSMSpeakStat.matches()) {
			String g1 = mSSMSpeakStat.group(1);
			if ( g1.equals("IDLE") ) {
				synthlistener_.update
				(new DeviceEvent
						(this,
								DeviceEvent.Type.OUTPUT,
								DeviceEvent.State.READY,
								null)
				);
			} else if ( g1.equals("ERROR") ) {
				synthlistener_.update
				(new DeviceEvent
						(this,
								DeviceEvent.Type.OUTPUT,
								DeviceEvent.State.READY,
								null)
				);
			} else if ( g1.equals("PROCESSING") ) {
				synthlistener_.update
				(new DeviceEvent
						(this,
								DeviceEvent.Type.OUTPUT,
								DeviceEvent.State.BUSY,
								null)
				);
			}
		}
		
		if (useSND) {
			//
			// From @SND tell start sample.au
			// From @SND tell end sample.au
			//
			// perl.match("/From \\@SND tell start/", str)
			// perl.match("/From \\@SND tell end/", str)
			//
			Pattern pSNDTell = Pattern.compile
			("From \\@SND tell (\\S+) (.*)$");
			Matcher mSNDTell = pSNDTell.matcher(str);
			if (mSNDTell.matches()) {
				String g1 = mSNDTell.group(1);
				String g2 = mSNDTell.group(2);
				if ( g1.equals("start") ) {
					synthlistener_.update
					(new DeviceEvent
							(this,
									DeviceEvent.Type.OUTPUT,
									DeviceEvent.State.BUSY,
									g2)
					);
				} else if ( g1.equals("end") ) {
					synthlistener_.update
					(new DeviceEvent
							(this,
									DeviceEvent.Type.OUTPUT,
									DeviceEvent.State.READY,
									g2)
					);
				}
			}
		} // useSND end
		
		while((str = sp_.FromStderrNB()).length() > 0) {
			if (showStdErr_) {
				dbg.print("AMT: (err) " + str);
			}
		}
		
		return true;
	}
	
	// Runnable Interface
	public void run()
	{
		while(iteration()) {
			try { 
				Thread.sleep(0, 1);
			} catch (Exception e) {e.printStackTrace();}
		}
	}
	
	
	public void terminate()
	{
		/*
		 // outputNative("to @SRM set Run = STOP");
		  // outputNative("to @AM-MCL AM quit");
		   
		   _outputNative(terminateCmd_);
		   
		   try { 
		   Thread.sleep(2000);
		   } catch (Exception e) {e.printStackTrace();}
		   
		   sp_.destroy();
		   */
	}

	/**
	 * @return Returns the srmError.
	 */
	public boolean isSrmError() {
		return srmError;
	}

	/**
	 * @param srmError The srmError to set.
	 */
	public void setSrmError(boolean srmError) {
		this.srmError = srmError;
	}

	/**
	 * @return Returns the srmErrorLog.
	 */
	public String getSrmErrorLog() {
		return srmErrorLog;
	}
	
}
