/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 *  $Id: SetNextCommand.java,v 1.2 2006/10/18 08:16:35 nishi Exp $
 */

package command;
import main.InteractionControler;

public class SetNextCommand extends Command
{
 //	private Debug dbg = new Debug(1);
	
	private String next_;
	
	public SetNextCommand(String next)
	{
		next_ = next;
	}
	
	public SetNextCommand(String next, String cond)
	{
		next_ = next;
		setCondition(cond);
	}
	
	public String getNext()
	{
		return(next_);
	}
	
	
	public String toString()
	{
		String s = "  <next";
		if ( hasCondition() ) {
			s += " cond=\"" + getConditionAsEncodedString() + "\"";
		}
		s += ">";
		s += next_ + "</next>";
		return s;
	}
	
	
	public void execute(InteractionControler ic)
	{
		String state = doEvaluate(next_);
		
		if ( evaluateCondition() == true ) {
			ic.setNextState(state);
		}
	}
	
}
