/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: HttpGetCommand.java,v 1.1 2006/08/24 03:45:42 nishi Exp $
 */

package command;
import outitem.*;
import main.*;
import java.net.URL;

public class HttpGetCommand extends Command
{

    private OutItem fetchaudio_;
    private URL url_;

    public HttpGetCommand(URL url)
    {

	this(url, new BreakOutItem(0));

    }

    public HttpGetCommand(URL url, OutItem oi)
    {

	fetchaudio_ = oi;
	url_ = url;

    }

    public OutItem getFetchAudio()
    {
	return(fetchaudio_);
    }

    public URL getUrl()
    {
	return(url_);
    }

    public void execute(InteractionControler ic)
    {
	if ( evaluateCondition() == true ) {
	    ic.setFetchingURL(url_);
	    if(ic.getNumCommands() == 1) {
		ic.fetchstart();
	    } else {
		ic.setReserveFetch(true);
	    }
	}
    }

}
