/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: CompositeCommand.java,v 1.2 2006/10/18 08:16:35 nishi Exp $
 */

package command;
import java.util.Vector;

import main.Debug;
import main.InteractionControler;

public class CompositeCommand extends Command
{
    private Debug dbg = new Debug("CC");
    private Vector commands_ = null;

    public CompositeCommand(Vector v)
    {
	commands_ = v;
    }

    public CompositeCommand(Vector v, String cond)
    {
	commands_ = v;
	setCondition(cond);
    }

    public void setCommands(Vector v)
    {
	commands_ = v;
    }
    
    public Vector getCommands()
    {
	return commands_;
    }

    public void addCommand(Command c)
    {
	commands_.add(c);
    }

    public void addScriptCommand(String script)
    {
	commands_.add(new EvaluateCommand(script));
    }

    public void addScriptCommand(String script, String with)
    {
	commands_.add(new EvaluateCommand(script, with));
    }


    public String toString()
    {
	String s = "  <cmd";
	if (hasCondition()) {
	    s += " cond=\"" + getConditionAsEncodedString() + "\"";
	}
	s += ">\n";
	int n = commands_.size();
	for(int i=0; i<n; i++) {
	    Command cmd = (Command)commands_.get(i);
	    s += " " + cmd.toString();
	    s += "\n";
	}
	s += "  </cmd>";
	return s;
    }

    public void execute(InteractionControler ic)
    {
	if ( evaluateCondition() == true ) {
	    dbg.print("CC:adding "+commands_.size()+" command(s).");
	    ic.insertCommandsTop(commands_);
	}
    }
}
