/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: Command.java,v 1.2 2006/10/18 08:16:35 nishi Exp $
 */

package command;
import main.Debug;
import main.InteractionControler;
import scripting.ECMAScript;
import util.Util;

public abstract class Command
{
	protected Debug dbg = new Debug("Command");
	
	protected ECMAScript ecmascript_ = null;
	
	public void setECMAScript(ECMAScript sc)
	{
		ecmascript_ = sc;
	}
	
	public String doEvaluate(String str)
	{
		return ecmascript_.evaluate(str);
	}
	
	private String condition_ = "true";
	
	public void setCondition(String s)
	{
		if (s == null) {
			condition_ = "true";
		}
		condition_ = s;
	}
	
	public String getConditionAsEncodedString()
	{
		return Util.encodeXmlChars(condition_);
	}
	
	public boolean hasCondition()
	{
		if (condition_ == null) 
			return false;
		return ! condition_.equals("true");
	}
	
	private String with_ = "";
	
	public void setWith(String s) {
		with_ = s;
	}
	public String getWith() {
		return with_;
	}
	
	public boolean evaluateCondition()
	{
		if (condition_ == null)
			return true;
		if (with_.length() > 0) {
			condition_ = "with(" + with_ + "){" + condition_ + "}";
		}
		
		String r = doEvaluate(condition_); 
		boolean b = false;
		if (r.equals("true")) {
			b = true;
		}
		return b;
	}
	
	public String toString()
	{
		String s = "<command/>";
		return s;
	}
	
	public void execute(InteractionControler ic)
	{
		//if ( evaluateCondition() == true ) {
		//    // do something
		//}
	}
	
}
