/*
 * Decompiled with CFR 0.152.
 */
package relaxer.vxml20;

import relaxer.vxml20.IRNode;
import relaxer.vxml20.IRVisitable;
import relaxer.vxml20.IRVisitor;

public final class URVisitor {
    public static void traverse(IRNode node, IRVisitor visitor) {
        URVisitor.traverseDepth(node, visitor);
    }

    public static void traverseDepth(IRNode node, IRVisitor visitor) {
        IRVisitable visitable = (IRVisitable)((Object)node);
        if (visitable.enter(visitor)) {
            URVisitor.traverseDepthChildren(node, visitor);
            visitable.leave(visitor);
        }
    }

    public static void traverseDepthChildren(IRNode node, IRVisitor visitor) {
        IRNode[] children = node.rGetRNodes();
        int i = 0;
        while (i < children.length) {
            URVisitor.traverseDepth(children[i], visitor);
            ++i;
        }
    }

    public static void traverseBreadth(IRNode node, IRVisitor visitor) {
        IRVisitable visitable = (IRVisitable)((Object)node);
        if (visitable.enter(visitor)) {
            URVisitor.traverseBreadthChildren(node, visitor);
        }
        visitable.leave(visitor);
    }

    public static void traverseBreadthChildren(IRNode node, IRVisitor visitor) {
        IRNode[] children = node.rGetRNodes();
        boolean[] enterResult = new boolean[children.length];
        int i = 0;
        while (i < children.length) {
            IRVisitable visitable = (IRVisitable)((Object)children[i]);
            enterResult[i] = visitable.enter(visitor);
            visitable.leave(visitor);
            ++i;
        }
        i = 0;
        while (i < children.length) {
            IRNode child = children[i];
            if (enterResult[i]) {
                URVisitor.traverseBreadthChildren(child, visitor);
            }
            ++i;
        }
    }
}

