/*
 * Decompiled with CFR 0.152.
 */
package relaxer.vxml20;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.vxml20.GramOneOf;
import relaxer.vxml20.GramRuleref;
import relaxer.vxml20.GramTag;
import relaxer.vxml20.GramToken;
import relaxer.vxml20.IGramItemMixed;
import relaxer.vxml20.IGramItemMixedChoice;
import relaxer.vxml20.IGramRuleMixed;
import relaxer.vxml20.IGramRuleMixedChoice;
import relaxer.vxml20.IRNSContainer;
import relaxer.vxml20.IRNode;
import relaxer.vxml20.IRVisitable;
import relaxer.vxml20.IRVisitor;
import relaxer.vxml20.RNSContext;
import relaxer.vxml20.RStack;
import relaxer.vxml20.RString;
import relaxer.vxml20.UJAXP;
import relaxer.vxml20.URelaxer;
import relaxer.vxml20.URelaxer2;

public class GramItem
implements Serializable,
Cloneable,
IRNSContainer,
IGramItemMixed,
IGramItemMixedChoice,
IRVisitable,
IRNode,
IGramRuleMixed,
IGramRuleMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
    private String repeat_;
    private String repeatProb_;
    private String weight_;
    private List content_ = new ArrayList();
    private IRNode parentRNode_;

    public GramItem() {
    }

    public GramItem(GramItem source) {
        this.setup(source);
    }

    public GramItem(RStack stack) {
        this.setup(stack);
    }

    public GramItem(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public GramItem(Element element) {
        this.setup(element);
    }

    public GramItem(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public GramItem(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public GramItem(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public GramItem(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public GramItem(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public GramItem(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(GramItem source) {
        this.setRepeat(source.getRepeat());
        this.setRepeatProb(source.getRepeatProb());
        this.setWeight(source.getWeight());
        this.content_.clear();
        int size = source.content_.size();
        int i = 0;
        while (i < size) {
            this.addContent((IGramItemMixed)source.getContent(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.repeat_ = URelaxer.getAttributePropertyAsString(element, "repeat");
        this.repeatProb_ = URelaxer.getAttributePropertyAsString(element, "repeat-prob");
        this.weight_ = URelaxer.getAttributePropertyAsString(element, "weight");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                this.addContent(new RString(stack));
                continue;
            }
            if (GramRuleref.isMatch(stack)) {
                this.addContent(new GramRuleref(stack));
                continue;
            }
            if (GramItem.isMatch(stack)) {
                this.addContent(new GramItem(stack));
                continue;
            }
            if (GramToken.isMatch(stack)) {
                this.addContent(new GramToken(stack));
                continue;
            }
            if (GramOneOf.isMatch(stack)) {
                this.addContent(new GramOneOf(stack));
                continue;
            }
            if (!GramTag.isMatch(stack)) break;
            this.addContent(new GramTag(stack));
        }
    }

    public Object clone() {
        return new GramItem(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS", "item");
        this.rNSContext_.setupNamespace(element);
        if (this.repeat_ != null) {
            URelaxer.setAttributePropertyByString(element, "repeat", this.repeat_);
        }
        if (this.repeatProb_ != null) {
            URelaxer.setAttributePropertyByString(element, "repeat-prob", this.repeatProb_);
        }
        if (this.weight_ != null) {
            URelaxer.setAttributePropertyByString(element, "weight", this.weight_);
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IGramItemMixed value = (IGramItemMixed)this.content_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public void setContent(String text) {
        this.setContent(new RString(text));
    }

    public void setContentByString(String text) {
        this.setContent(new RString(text));
    }

    public final RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public final String getRepeat() {
        return this.repeat_;
    }

    public final void setRepeat(String repeat) {
        this.repeat_ = repeat;
    }

    public final String getRepeatProb() {
        return this.repeatProb_;
    }

    public final void setRepeatProb(String repeatProb) {
        this.repeatProb_ = repeatProb;
    }

    public final String getWeight() {
        return this.weight_;
    }

    public final void setWeight(String weight) {
        this.weight_ = weight;
    }

    public final IGramItemMixed[] getContent() {
        IGramItemMixed[] array = new IGramItemMixed[this.content_.size()];
        return this.content_.toArray(array);
    }

    public final void setContent(IGramItemMixed[] content) {
        this.content_.clear();
        int i = 0;
        while (i < content.length) {
            this.addContent(content[i]);
            ++i;
        }
        i = 0;
        while (i < content.length) {
            content[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setContent(IGramItemMixed content) {
        this.content_.clear();
        this.addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void addContent(IGramItemMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void addContent(IGramItemMixed[] content) {
        int i = 0;
        while (i < content.length) {
            this.addContent(content[i]);
            ++i;
        }
        i = 0;
        while (i < content.length) {
            content[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeContent() {
        return this.content_.size();
    }

    public final IGramItemMixed getContent(int index) {
        return (IGramItemMixed)this.content_.get(index);
    }

    public final void setContent(int index, IGramItemMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void addContent(int index, IGramItemMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    public final void removeContent(IGramItemMixed content) {
        this.content_.remove(content);
    }

    public final void clearContent() {
        this.content_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        IGramItemMixed value;
        String prefix = this.rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
        buffer.append("<");
        URelaxer.makeQName(prefix, "item", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.repeat_ != null) {
            buffer.append(" ");
            buffer.append("repeat");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRepeat())));
            buffer.append("\"");
        }
        if (this.repeatProb_ != null) {
            buffer.append(" ");
            buffer.append("repeat-prob");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRepeatProb())));
            buffer.append("\"");
        }
        if (this.weight_ != null) {
            buffer.append(" ");
            buffer.append("weight");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getWeight())));
            buffer.append("\"");
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            value = (IGramItemMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.append(">");
        size = this.content_.size();
        i = 0;
        while (i < size) {
            value = (IGramItemMixed)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "item", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        IGramItemMixed value;
        String prefix = this.rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
        buffer.write("<");
        URelaxer.makeQName(prefix, "item", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.repeat_ != null) {
            buffer.write(" ");
            buffer.write("repeat");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRepeat())));
            buffer.write("\"");
        }
        if (this.repeatProb_ != null) {
            buffer.write(" ");
            buffer.write("repeat-prob");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRepeatProb())));
            buffer.write("\"");
        }
        if (this.weight_ != null) {
            buffer.write(" ");
            buffer.write("weight");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getWeight())));
            buffer.write("\"");
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            value = (IGramItemMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.write(">");
        size = this.content_.size();
        i = 0;
        while (i < size) {
            value = (IGramItemMixed)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "item", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        IGramItemMixed value;
        String prefix = this.rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
        buffer.print("<");
        URelaxer.makeQName(prefix, "item", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.repeat_ != null) {
            buffer.print(" ");
            buffer.print("repeat");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRepeat())));
            buffer.print("\"");
        }
        if (this.repeatProb_ != null) {
            buffer.print(" ");
            buffer.print("repeat-prob");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRepeatProb())));
            buffer.print("\"");
        }
        if (this.weight_ != null) {
            buffer.print(" ");
            buffer.print("weight");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getWeight())));
            buffer.print("\"");
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            value = (IGramItemMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.print(">");
        size = this.content_.size();
        i = 0;
        while (i < size) {
            value = (IGramItemMixed)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "item", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getRepeatAsString() {
        return URelaxer.getString(this.getRepeat());
    }

    public String getRepeatProbAsString() {
        return URelaxer.getString(this.getRepeatProb());
    }

    public String getWeightAsString() {
        return URelaxer.getString(this.getWeight());
    }

    public void setRepeatByString(String string) {
        this.setRepeat(string);
    }

    public void setRepeatProbByString(String string) {
        this.setRepeatProb(string);
    }

    public void setWeightByString(String string) {
        this.setWeight(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS", "item")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (true) {
            if (GramRuleref.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (GramItem.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (GramToken.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (GramOneOf.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!GramTag.isMatchHungry(target)) break;
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return GramItem.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (GramItem.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

