/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.IPdocHeadChoice;
import relaxer.pdoc.PdocRule;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocGrammar
implements Serializable,
Cloneable,
IPdocHeadChoice {
    private float version_;
    private List rule_ = new ArrayList();

    public PdocGrammar() {
    }

    public PdocGrammar(PdocGrammar source) {
        this.setup(source);
    }

    public PdocGrammar(RStack stack) {
        this.setup(stack);
    }

    public PdocGrammar(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public PdocGrammar(Element element) {
        this.setup(element);
    }

    public PdocGrammar(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocGrammar(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public PdocGrammar(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public PdocGrammar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public PdocGrammar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public PdocGrammar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocGrammar source) {
        this.setVersion(source.getVersion());
        this.rule_.clear();
        int size = source.rule_.size();
        int i = 0;
        while (i < size) {
            this.addRule((PdocRule)source.getRule(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.version_ = URelaxer.getAttributePropertyAsFloat(element, "version");
        this.rule_.clear();
        while (PdocRule.isMatch(stack)) {
            this.addRule(new PdocRule(stack));
        }
    }

    public Object clone() {
        return new PdocGrammar(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("grammar");
        URelaxer.setAttributePropertyByFloat(element, "version", this.version_);
        int size = this.rule_.size();
        int i = 0;
        while (i < size) {
            PdocRule value = (PdocRule)this.rule_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final float getVersion() {
        return this.version_;
    }

    public final void setVersion(float version) {
        this.version_ = version;
    }

    public final PdocRule[] getRule() {
        PdocRule[] array = new PdocRule[this.rule_.size()];
        return this.rule_.toArray(array);
    }

    public final void setRule(PdocRule[] rule) {
        this.rule_.clear();
        int i = 0;
        while (i < rule.length) {
            this.addRule(rule[i]);
            ++i;
        }
    }

    public final void setRule(PdocRule rule) {
        this.rule_.clear();
        this.addRule(rule);
    }

    public final void addRule(PdocRule rule) {
        this.rule_.add(rule);
    }

    public final void addRule(PdocRule[] rule) {
        int i = 0;
        while (i < rule.length) {
            this.addRule(rule[i]);
            ++i;
        }
    }

    public final int sizeRule() {
        return this.rule_.size();
    }

    public final PdocRule getRule(int index) {
        return (PdocRule)this.rule_.get(index);
    }

    public final void setRule(int index, PdocRule rule) {
        this.rule_.set(index, rule);
    }

    public final void addRule(int index, PdocRule rule) {
        this.rule_.add(index, rule);
    }

    public final void removeRule(int index) {
        this.rule_.remove(index);
    }

    public final void removeRule(PdocRule rule) {
        this.rule_.remove(rule);
    }

    public final void clearRule() {
        this.rule_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<grammar");
        buffer.append(" version=\"");
        buffer.append(URelaxer.getString(this.getVersion()));
        buffer.append("\"");
        buffer.append(">");
        int size = this.rule_.size();
        int i = 0;
        while (i < size) {
            PdocRule value = (PdocRule)this.rule_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</grammar>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<grammar");
        buffer.write(" version=\"");
        buffer.write(URelaxer.getString(this.getVersion()));
        buffer.write("\"");
        buffer.write(">");
        int size = this.rule_.size();
        int i = 0;
        while (i < size) {
            PdocRule value = (PdocRule)this.rule_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</grammar>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<grammar");
        buffer.print(" version=\"");
        buffer.print(URelaxer.getString(this.getVersion()));
        buffer.print("\"");
        buffer.print(">");
        int size = this.rule_.size();
        int i = 0;
        while (i < size) {
            PdocRule value = (PdocRule)this.rule_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</grammar>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getVersionAsString() {
        return URelaxer.getString(this.getVersion());
    }

    public void setVersionByString(String string) {
        this.setVersion(Float.parseFloat(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "grammar")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "version")) {
            return false;
        }
        $match$ = true;
        if (!PdocRule.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        while (PdocRule.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocGrammar.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocGrammar.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

