/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Vector;
import main.AMThread;
import main.BreakThread;
import main.Debug;
import main.DeviceEvent;
import main.DeviceListener;
import main.GalateaRuntimeError;
import main.GrammarSet;
import main.InputDevice;
import main.MMMEvent;
import main.MMMListener;
import main.OutputDevices;
import outitem.OutItem;
import scripting.ECMAScript;

public class MultiModalManager
implements DeviceListener {
    private Debug dbg = new Debug("MMM", 0);
    private OutputDevices odevs_;
    private Vector idevs_;
    private MMMListener mmml_;
    private OutItem currOutItem_;
    private boolean nowOutput_ = false;
    private AMThread amt_;
    private GrammarSet gs_ = new GrammarSet();
    private ECMAScript script_ = null;

    public MultiModalManager() {
        this.amt_ = new AMThread();
        this.amt_.setOutputListener(this);
        this.amt_.setInputListener(this);
        this.amt_.start();
        BreakThread bt = new BreakThread();
        bt.setOutputListener(this);
        bt.start();
        this.odevs_ = new OutputDevices();
        this.odevs_.addDevice(bt, OutputDevices.Type.BREAK);
        this.odevs_.addDevice(this.amt_, OutputDevices.Type.VOICE);
        this.odevs_.addDevice(this.amt_, OutputDevices.Type.AUDIO);
        this.odevs_.addDevice(this.amt_, OutputDevices.Type.LOG);
        this.odevs_.addDevice(this.amt_, OutputDevices.Type.NATIVE);
        this.idevs_ = new Vector();
        this.idevs_.add(this.amt_);
        this.idevs_.trimToSize();
        while (!this.amt_.isReady()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void terminate() {
        this.dbg.print("MMM Terminate");
        while (!this.idevs_.isEmpty()) {
            ((InputDevice)this.idevs_.remove(0)).terminate();
        }
        this.odevs_.terminate(OutputDevices.Type.BREAK);
        this.amt_.terminate();
    }

    public void prepareGrammar(GrammarSet gs) throws GalateaRuntimeError {
        this.dbg.print("MMM: AMT.prepareGrammar");
        if (this.amt_.prepareGrammar(gs)) {
            while (!this.amt_.isListening()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void outputNow(OutItem item) {
        item.doOutput(this.odevs_);
    }

    public synchronized boolean output(OutItem item) {
        this.dbg.print("MMM: output start: " + Thread.currentThread().getName());
        this.dbg.ASSERT(Thread.currentThread().getName().equals("main"), "bad thread");
        this.dbg.print(String.valueOf(item.toString()) + " isInstant=" + item.isInstant());
        if (item.isInstant()) {
            item.setECMAScript(this.script_);
            this.outputNow(item);
            this.dbg.print("MMM: output done: " + Thread.currentThread().getName());
            return true;
        }
        this.currOutItem_ = item;
        this.currOutItem_.setECMAScript(this.script_);
        this.currOutItem_.doOutput(this.odevs_);
        while (!this.nowOutput_) {
            this.dbg.print("MMM: output : outStart wait");
            try {
                this.wait(5000L);
                this.nowOutput_ = false;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dbg.print("MMM: output : outStart wait end...");
            }
        }
        this.dbg.print("MMM: output : " + Thread.currentThread().getName());
        return false;
    }

    public synchronized void stop() {
        if (this.currOutItem_ != null) {
            this.dbg.print("MMM.stop()");
            this.currOutItem_.stop(this.odevs_);
        }
    }

    public synchronized void updateInput(DeviceEvent evt) {
        DeviceEvent.State state = evt.getState();
        boolean canInput = false;
        if (this.currOutItem_ != null) {
            canInput = this.currOutItem_.canInput();
        }
        this.dbg.print("MMM : currOutItem=" + this.currOutItem_ + " caninput=" + canInput);
        if (canInput) {
            if (state == DeviceEvent.State.BUSY) {
                this.mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.INPUT_START));
            } else if (state == DeviceEvent.State.READY) {
                String s = evt.getString();
                while (this.nowOutput_) {
                    this.dbg.print("---- MMM.update : outEnd wait");
                    try {
                        this.wait(5000L);
                        this.nowOutput_ = false;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.dbg.print("---- MMM.output : outEnd wait end...");
                    }
                }
                if (s != null && !s.equals("")) {
                    this.mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.INPUT_END, s));
                } else {
                    this.mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.INPUT_END));
                }
            }
        }
    }

    public synchronized void updateOutput(DeviceEvent evt) {
        DeviceEvent.State state = evt.getState();
        if (state == DeviceEvent.State.READY) {
            if (this.currOutItem_.isLoop()) {
                this.output(this.currOutItem_);
            } else {
                this.nowOutput_ = false;
                this.mmml_.updateMMMStatus(new MMMEvent(MMMEvent.Type.OUTPUT_END));
                this.notify();
            }
        } else {
            this.nowOutput_ = true;
            this.notify();
        }
    }

    public void update(DeviceEvent evt) {
        DeviceEvent.Type type = evt.getDeviceType();
        DeviceEvent.State state = evt.getState();
        this.dbg.print("::::::::::: MMM : INPUT EVENT");
        this.dbg.print("   " + type.toString());
        this.dbg.print("   " + state.toString());
        this.dbg.print("   String = " + evt.getString());
        this.dbg.print(":::::::::::::::::::::::::::::");
        this.dbg.print("---- MMM.update");
        if (this.mmml_ != null) {
            if (type == DeviceEvent.Type.INPUT) {
                this.updateInput(evt);
            } else if (type == DeviceEvent.Type.OUTPUT) {
                this.updateOutput(evt);
            }
        }
    }

    public void setListener(MMMListener l) {
        this.mmml_ = l;
    }

    public void setECMAScript(ECMAScript sc) {
        this.script_ = sc;
    }
}

