/*
 * Decompiled with CFR 0.152.
 */
package main;

import command.Command;
import java.net.URL;
import java.util.Vector;
import main.Debug;
import main.DocError;
import main.DocLoader;
import main.HttpManager;
import main.HttpManagerEvent;
import main.HttpManagerListener;
import main.InterpreterContextManager;
import main.MMMEvent;
import main.MMMListener;
import main.MultiModalManager;
import main.OutQueueManager;
import outitem.OutItem;
import scripting.ECMAScript;
import util.SubProcess;
import util.Util;

public class InteractionControler
implements MMMListener,
HttpManagerListener {
    private Debug dbg = new Debug("IC", 0);
    private InterpreterContextManager icm_;
    private MultiModalManager mmm_;
    private OutQueueManager oqm_;
    private HttpManager httpm_;
    private ECMAScript script_ = null;
    private URL fetchingURL_;
    private boolean reservefetch_ = false;
    private boolean fetching_ = false;
    private boolean endflag_ = false;
    private boolean endimm_ = false;
    private boolean nextout_ = false;
    private boolean nextcmd_ = true;
    private boolean inputbusy_ = false;
    private Vector commands_ = null;
    private String nextDocFile_ = "";

    public void setNextDocFile(String s) {
        this.nextDocFile_ = s;
    }

    public String getNextDocFile() {
        if (this.nextDocFile_ == null) {
            return "";
        }
        return this.nextDocFile_;
    }

    public InteractionControler() throws Exception {
        this.dbg.print("IC: constructor begin.");
        this.icm_ = new InterpreterContextManager();
        this.mmm_ = new MultiModalManager();
        this.oqm_ = new OutQueueManager();
        this.httpm_ = HttpManager.getInstance();
        this.mmm_.setListener(this);
        this.script_ = new ECMAScript();
        this.mmm_.setECMAScript(this.script_);
        this.dbg.print("IC: constructor done.");
    }

    public void loadDocument(String fn) throws Exception {
        DocLoader doc = new DocLoader(fn, fn);
        this.icm_.setDocument(doc);
        this.mmm_.prepareGrammar(this.icm_.getGrammarSet());
        this.endflag_ = false;
        this.endimm_ = false;
        this.nextout_ = false;
        this.nextcmd_ = true;
        this.inputbusy_ = false;
        this.commands_ = null;
        this.nextDocFile_ = "";
    }

    private synchronized void waitWhileInputBusy() {
        this.dbg.print("IC: waitWhileInputBusy: begin.");
        while (this.inputbusy_) {
            try {
                this.wait();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dbg.print("IC: waitWhileInputBusy: done.");
    }

    private void executeAllCommands() {
        while (!this.commands_.isEmpty()) {
            Command cmd = (Command)this.commands_.remove(0);
            String _str = cmd.toString();
            if ((_str = Util.removeNewLines(_str)).length() > 40) {
                _str = String.valueOf(_str.substring(0, 40)) + "...";
            }
            this.dbg.print("IC: cmd:" + _str);
            cmd.setECMAScript(this.script_);
            cmd.execute(this);
        }
    }

    private boolean outputItems() {
        boolean output_something = false;
        while (this.nextout_) {
            this.dbg.print("IC: outputItems: begin.");
            OutItem o = this.oqm_.dequeue();
            if (o != null) {
                String _s = o.getClass().getName();
                this.nextout_ = this.mmm_.output(o);
                this.dbg.print("IC: outputItems: " + _s + " done. nextout=" + this.nextout_);
                if (this.nextout_) continue;
                this.dbg.print("IC: outputItems: output_something = true");
                output_something = true;
                continue;
            }
            if (this.reservefetch_) {
                this.reservefetch_ = false;
                this.fetchstart();
            } else {
                this.icm_.noinput();
            }
            this.nextout_ = false;
            this.nextcmd_ = true;
        }
        return output_something;
    }

    private synchronized void waitOutputEndEvent() {
        this.dbg.print("IC: waitOutputEndEvent: begin.");
        try {
            this.wait();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dbg.print("IC: waitOutputEndEvent: done.");
    }

    private boolean iteration() {
        boolean output_something = false;
        do {
            this.waitWhileInputBusy();
            if (this.nextcmd_ && !this.endflag_) {
                this.nextcmd_ = false;
                this.commands_ = this.icm_.getCmd();
                this.dbg.print("IC: iteration: icm.getCmd done.");
                this.executeAllCommands();
            }
            this.dbg.print("IC: endflag:" + this.endflag_ + " endimm:" + this.endimm_ + " nextcmd:" + this.nextcmd_ + " nextout:" + this.nextout_ + " inputbusy:" + this.inputbusy_);
            if (this.endflag_ && (this.endimm_ || !this.nextout_)) {
                this.commands_.removeAllElements();
                this.oqm_.discard();
                this.dbg.print("IC: iteration done.");
                return false;
            }
            output_something = this.outputItems();
        } while (this.nextcmd_);
        if (output_something) {
            this.waitOutputEndEvent();
        } else {
            this.icm_.noinput();
            this.dbg.print("IC: iteration: icm.noinput done. inputbusy = false.");
            this.inputbusy_ = false;
            this.nextcmd_ = true;
        }
        return true;
    }

    public void mainLoop() {
        while (this.iteration()) {
        }
        this.dbg.print("IC: mainLoop done.");
    }

    private void _finalize() {
        String fincom = System.getProperty("FinCommand");
        if (fincom != null) {
            SubProcess fin = new SubProcess(fincom);
            if (!fin.Run()) {
                System.err.println("Cannot run fin.");
            }
            fin.destroy();
        }
    }

    public void terminate() {
        this.mmm_.terminate();
        this._finalize();
    }

    public synchronized void updateHTTPMStatus(HttpManagerEvent evt) {
        this.dbg.print("IC: HTTPManager event");
        this.fetching_ = false;
        this.fetchingURL_ = null;
        this.mmm_.stop();
        this.nextcmd_ = true;
        String path = evt.getUrl().toString();
        try {
            this.icm_.newDocument(evt.getUrl().toString(), path);
        }
        catch (DocError e) {
            System.err.println();
            System.err.println(e);
            System.err.println("IC: stopped.");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.notifyAll();
    }

    public synchronized void updateMMMStatus(MMMEvent evt) {
        MMMEvent.Type type = evt.getEventType();
        String sender = Thread.currentThread().getName();
        if (type == MMMEvent.Type.INPUT_END) {
            String text = evt.getString();
            this.dbg.print("IC: update: INPUT_END event " + text + " from " + sender);
            if (!this.inputbusy_) {
                this.dbg.print("IC: update: ignored (because inputbusy == false)");
                return;
            }
            if (this.fetching_) {
                this.httpm_.maskEvent(this.fetchingURL_);
                this.fetchingURL_ = null;
                this.fetching_ = false;
            }
            this.dbg.print("IC: update: icm.inputText " + text);
            this.icm_.inputText(text);
            String ct = Thread.currentThread().getName();
            if (ct.equals("main")) {
                OutItem o;
                while ((o = this.oqm_.dequeue()) != null) {
                    if (!o.isInstant()) continue;
                    this.mmm_.outputNow(o);
                }
                this.dbg.print("IC: update: inputbusy = false");
                this.nextcmd_ = true;
            } else {
                this.oqm_.removeDelayedItems();
            }
            this.inputbusy_ = false;
            this.notifyAll();
        } else if (type == MMMEvent.Type.INPUT_START) {
            this.dbg.print("IC: update: INPUT_START event from " + sender);
            this.dbg.print("IC: update: mmm.stop");
            this.mmm_.stop();
            this.dbg.print("IC: update: inputbusy = true");
            this.inputbusy_ = true;
        } else if (type == MMMEvent.Type.OUTPUT_END) {
            this.dbg.print("IC: update: OUTPUT_END event from " + sender);
            this.nextout_ = true;
            this.notifyAll();
        }
    }

    public void enqueueOutput(OutItem oi) {
        this.oqm_.enqueue(oi);
    }

    public void setNextOut(boolean b) {
        this.nextout_ = b;
    }

    public void setEndFlag(boolean b) {
        this.dbg.print("IC: setEndFlag " + b);
        this.endflag_ = b;
    }

    public void setEndImm(boolean b) {
        this.dbg.print("IC: setEndImm " + b);
        this.endimm_ = b;
    }

    public void setFetchingURL(URL u) {
        this.fetchingURL_ = u;
    }

    public void setReserveFetch(boolean b) {
        this.reservefetch_ = b;
    }

    public synchronized int getNumCommands() {
        if (this.commands_ == null) {
            return 0;
        }
        return this.commands_.size();
    }

    public synchronized void insertCommandsTop(Vector v) {
        if (this.commands_ == null) {
            return;
        }
        this.commands_.addAll(0, v);
    }

    public void fetchstart() {
        if (this.httpm_.isCached(this.fetchingURL_)) {
            String path = this.fetchingURL_.toString();
            try {
                this.icm_.newDocument(this.fetchingURL_.toString(), path);
            }
            catch (DocError e) {
                System.err.println();
                System.err.println(e);
                System.err.println("IntractionControler stopped.");
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fetchingURL_ = null;
        } else {
            this.fetching_ = true;
            this.httpm_.fetchStart(this.fetchingURL_, this);
        }
    }

    public void setNextState(String state) {
        this.dbg.print("IC: next: " + state);
        this.icm_.setNextState(state);
    }

    public void gotoState(String state) {
        this.dbg.print("IC: goto: " + state);
        this.icm_.setNextState(state);
        this.commands_.removeAllElements();
    }
}

