/*
 * Decompiled with CFR 0.152.
 */
package document;

import command.AddOutItemCommand;
import command.Command;
import command.CompositeCommand;
import command.EndCommand;
import command.EvaluateCommand;
import command.GotoCommand;
import command.SetNextCommand;
import document.AbstractDoc;
import java.util.Vector;
import main.Debug;
import main.DocError;
import main.GrammarSet;
import main.StateMap;
import org.w3c.dom.Element;
import outitem.AudioOutItem;
import outitem.BreakOutItem;
import outitem.LogOutItem;
import outitem.NativeOutItem;
import outitem.OutItem;
import outitem.VoiceOutItem;
import relaxer.pdoc.IPdocAddChoice;
import relaxer.pdoc.IPdocCmdContentsChoice;
import relaxer.pdoc.PdocAdd;
import relaxer.pdoc.PdocAudio;
import relaxer.pdoc.PdocBody;
import relaxer.pdoc.PdocBreak;
import relaxer.pdoc.PdocCatch;
import relaxer.pdoc.PdocCmd;
import relaxer.pdoc.PdocEnd;
import relaxer.pdoc.PdocGoto;
import relaxer.pdoc.PdocGrammar;
import relaxer.pdoc.PdocHead;
import relaxer.pdoc.PdocJulian;
import relaxer.pdoc.PdocLog;
import relaxer.pdoc.PdocNative;
import relaxer.pdoc.PdocNext;
import relaxer.pdoc.PdocNomatch;
import relaxer.pdoc.PdocPdoc;
import relaxer.pdoc.PdocScript;
import relaxer.pdoc.PdocState;
import relaxer.pdoc.PdocVoice;
import relaxer.vxml20.GramGrammar;

public class RawPhoenixDoc
implements AbstractDoc {
    private Debug dbg = new Debug("RawPhoenixDoc");
    private String docAddress_;
    private Element element_;
    private StateMap stateMap_;
    private GrammarSet gram_ = null;

    public StateMap getStateMap() {
        return this.stateMap_;
    }

    public String getDocAddress() {
        return this.docAddress_;
    }

    public void setDocAddress(String adrs) {
        this.docAddress_ = adrs;
    }

    private Command getCompositeCommand(PdocCmd composite) {
        Vector<Command> vec = new Vector<Command>();
        int j = 0;
        while (j < composite.sizeCmdContents()) {
            Command c;
            Command c2;
            String cond;
            String next;
            String cond2;
            IPdocCmdContentsChoice cc = composite.getCmdContents(j);
            if (cc instanceof PdocAdd) {
                AddOutItemCommand c3;
                OutItem o;
                String text;
                String with;
                PdocAdd add = (PdocAdd)cc;
                cond2 = ((PdocAdd)cc).getCond();
                IPdocAddChoice ac = add.getContent();
                if (ac instanceof PdocAudio) {
                    String src = ((PdocAudio)ac).getContent();
                    AudioOutItem o2 = new AudioOutItem(src);
                    o2.setBargein(((PdocAudio)ac).getBargein());
                    AddOutItemCommand c4 = new AddOutItemCommand(o2, cond2);
                    vec.add(c4);
                } else if (ac instanceof PdocBreak) {
                    BreakOutItem o3 = new BreakOutItem((PdocBreak)ac);
                    AddOutItemCommand c5 = new AddOutItemCommand(o3, cond2);
                    vec.add(c5);
                } else if (ac instanceof PdocLog) {
                    with = ((PdocLog)ac).getWith();
                    text = ((PdocLog)ac).getContent();
                    o = new LogOutItem(text, with);
                    c3 = new AddOutItemCommand(o, cond2);
                    vec.add(c3);
                } else if (ac instanceof PdocNative) {
                    with = ((PdocNative)ac).getWith();
                    text = ((PdocNative)ac).getContent();
                    o = new NativeOutItem(text, with);
                    c3 = new AddOutItemCommand(o, cond2);
                    vec.add(c3);
                } else if (ac instanceof PdocVoice) {
                    with = ((PdocVoice)ac).getWith();
                    text = ((PdocVoice)ac).getContent();
                    o = new VoiceOutItem(text, with);
                    o.setBargein(((PdocVoice)ac).getBargein());
                    c3 = new AddOutItemCommand(o, cond2);
                    vec.add(c3);
                }
            } else if (cc instanceof PdocCmd) {
                Command c6 = this.getCompositeCommand((PdocCmd)cc);
                vec.add(c6);
            } else if (cc instanceof PdocEnd) {
                next = ((PdocEnd)cc).getContent();
                boolean now = ((PdocEnd)cc).getNow();
                cond = ((PdocEnd)cc).getCond();
                c2 = new EndCommand(next, cond, now);
                vec.add(c2);
            } else if (cc instanceof PdocGoto) {
                next = ((PdocGoto)cc).getContent();
                cond2 = ((PdocGoto)cc).getCond();
                c = new GotoCommand(next, cond2);
                vec.add(c);
            } else if (cc instanceof PdocNext) {
                next = ((PdocNext)cc).getContent();
                cond2 = ((PdocNext)cc).getCond();
                c = new SetNextCommand(next, cond2);
                vec.add(c);
            } else if (cc instanceof PdocScript) {
                String content = ((PdocScript)cc).getContent();
                String with = ((PdocScript)cc).getWith();
                cond = ((PdocScript)cc).getCond();
                c2 = new EvaluateCommand(content, with, cond);
                vec.add(c2);
            }
            ++j;
        }
        String cmdcond = composite.getCond();
        return new CompositeCommand(vec, cmdcond);
    }

    public RawPhoenixDoc(Element e, String path) throws Exception {
        this.element_ = e;
        this.docAddress_ = path;
        if (!PdocPdoc.isMatch(e)) {
            throw new DocError("Not a valid <pdoc> document.");
        }
        PdocPdoc pdoc = new PdocPdoc(e);
        this.stateMap_ = new StateMap();
        this.stateMap_.setPdocVersion(pdoc.getVersion());
        PdocHead head = pdoc.getHead();
        if (head.getContent() instanceof PdocGrammar) {
            this.gram_ = new GrammarSet();
            this.gram_.setJulian(false);
            String gramstr = ((PdocGrammar)head.getContent()).toString();
            GramGrammar vg = new GramGrammar(gramstr);
            this.gram_.addRules(vg, this.docAddress_);
            this.stateMap_.setGrammarSet(this.gram_);
        } else if (head.getContent() instanceof PdocJulian) {
            this.gram_ = new GrammarSet();
            this.gram_.setJulian(true);
            String name = ((PdocJulian)head.getContent()).getName();
            this.gram_.setJulianGramName(name);
            this.stateMap_.setGrammarSet(this.gram_);
        }
        PdocBody body = pdoc.getBody();
        String start = body.getStart();
        this.stateMap_.setFirstStateName(start);
        int i = 0;
        while (i < body.sizeState()) {
            PdocState state = body.getState(i);
            this.dbg.print(String.valueOf(i) + ">" + state.toString());
            String stateId = state.getId();
            this.stateMap_.newState(stateId);
            PdocCmd cmd = state.getCmd();
            Command c = this.getCompositeCommand(cmd);
            this.stateMap_.addCommand(stateId, c);
            PdocNomatch nomatch = state.getNomatch();
            if (nomatch != null) {
                String dst = nomatch.getGoto().getContent().replaceAll("'", "");
                this.stateMap_.addNomatch(stateId, dst);
            }
            int j = 0;
            while (j < state.sizeCatch()) {
                PdocCatch pcatch = state.getCatch(j);
                String next = "";
                String content = pcatch.getText();
                int k = 0;
                while (k < pcatch.sizeContent()) {
                    if (pcatch.getContent(k) instanceof PdocGoto) {
                        next = ((PdocGoto)pcatch.getContent(k)).getContent();
                        next = next.replaceAll("'", "");
                        this.stateMap_.addTrans(stateId, next, content);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

