/*
 * Decompiled with CFR 0.152.
 */
package command;

import command.Command;
import command.EvaluateCommand;
import java.util.Vector;
import main.Debug;
import main.InteractionControler;

public class CompositeCommand
extends Command {
    private Debug dbg = new Debug("CC");
    private Vector commands_ = null;

    public CompositeCommand(Vector v) {
        this.commands_ = v;
    }

    public CompositeCommand(Vector v, String cond) {
        this.commands_ = v;
        this.setCondition(cond);
    }

    public void setCommands(Vector v) {
        this.commands_ = v;
    }

    public Vector getCommands() {
        return this.commands_;
    }

    public void addCommand(Command c) {
        this.commands_.add(c);
    }

    public void addScriptCommand(String script) {
        this.commands_.add(new EvaluateCommand(script));
    }

    public void addScriptCommand(String script, String with) {
        this.commands_.add(new EvaluateCommand(script, with));
    }

    public String toString() {
        String s = "  <cmd";
        if (this.hasCondition()) {
            s = String.valueOf(s) + " cond=\"" + this.getConditionAsEncodedString() + "\"";
        }
        s = String.valueOf(s) + ">\n";
        int n = this.commands_.size();
        int i = 0;
        while (i < n) {
            Command cmd = (Command)this.commands_.get(i);
            s = String.valueOf(s) + " " + cmd.toString();
            s = String.valueOf(s) + "\n";
            ++i;
        }
        s = String.valueOf(s) + "  </cmd>";
        return s;
    }

    public void execute(InteractionControler ic) {
        if (this.evaluateCondition()) {
            this.dbg.print("CC:adding " + this.commands_.size() + " command(s).");
            ic.insertCommandsTop(this.commands_);
        }
    }
}

