<?php

require_once (dirname(__FILE__) . '/../config.php');
require_once 'fsutil.php';

//-------------------------------------------------

function _hmac_signature_hmac( $data, $secret){
  return hash_hmac('ripemd160', $blob64, $secret);
}

function hmac_signature_encode($blob, $secret){
  $blob64 = base64_urlsafe_encode($blob);
  $cert = _hmac_signature_hmac($blob64, $secret);
  return $cert.$blob64;
}

function hmac_signature_decode($token, $secret, $default = false){
  if(strlen($token) < 40){return $default;}
  $cert = substr($token, 0, 40);
  $blob64 = substr($token, 40);
  $formal = _hmac_signature_hmac($blob64, $secret);
  if($cert == $formal){
    return base64_urlsafe_decode($blob64);
  }else{
    return $default;
  }
}

function hmac_signature_secret() {
  if (!function_exists('_hmac_signature_secret')){
    global $ROOTDIR;
    $path = $ROOTDIR . '/_hmac_signature_secret.php';
    if (!file_exists($path)) {
      $code = '<?php function _hmac_signature_secret(){return "' . mcrypt_create_iv(40) . '";}';
      file_put_contents( $path, $code );
    }
    require_once $path;
  }
  return _hmac_signature_secret();
}
//-------------------------------------------------

function rsa_signature_encode($blob, $privatekey) {
  $blob64 = base64_encode($blob);
  openssl_sign($blob64, $sign, $privatekey);
  return $blob64 . "." . base64_encode($sign);
}

function rsa_signature_decode($token, $publickey, $default=false) {
  $parts = explode('.', $token);
  if(count($parts) != 2){return $default;}
  $blob64 = $parts[0];
  $sign = base64_decode( $parts[1] );
  if(openssl_verify($blob64, $sign, $publickey) == 1){
    return base64_decode($blob64);
  }else{
    return $default;
  }
}

function rsa_signature_payload($token, $default=false) {
  $parts = explode('.', $token);
  if(count($parts) != 2){return $default;}
  return base64_decode($parts[0]);
}

function rsa_signature_keypair() {
  if(!function_exists('_rsa_signature_keypair')){
    global $ROOTDIR;
    $path = $ROOTDIR . '/_rsa_signature_keypair.php';
    if (!file_exists($path)) {
      $keyres = openssl_pkey_new();
      $detail = openssl_pkey_get_details( $keyres );
      $pubkey = $detail['key'];
      openssl_pkey_export($keyres, $private );
      openssl_pkey_free($keyres);
      $code = '<?php function _rsa_signature_keypair(){return array('
        . '"private" => "' . $private . '",'
        . '"public" => "' . $pubkey . '");}';
      file_put_contents( $path, $code );
    }
    require_once $path;
  }
  return _rsa_signature_keypair();
}

//-------------------------------------------------

function make_dir_hashbook($contdir) {
  $files = find_files( $contdir );
  $signPath = $contdir . _PGET_SIGNATURE_;
  $book = array();
  foreach ($files as $file) {
    if($file === $signPath) { continue; }
    $entry = str_replace($contdir,"",$file);
    $book[$entry] = hash_file('ripemd160', $file);
  }
  return $book;
}

function make_thread_signature($url) {
  $basenames = urlToBasename($url);
  $contdir = readConfig("CONTDIR") . $basenames["CONT"];
  $key = rsa_signature_keypair();
  $book = array();
  $book['issuer'] = hash('ripemd160', $key['public']);
  $book['files'] = make_dir_hashbook($contdir);
  $book['meta'] = publishInfo(readUrlInfo($url));
  return rsa_signature_encode(json_encode($book), $key['private']);
}

function decode_thread_signature($file) {
  $key = rsa_signature_keypair();
  $token = file_get_contents($file);
  return rsa_signature_decode($token, $key['public']);
}
