<?php
/**
 * ページャー描画用
 *
 */
require_once (dirname(__FILE__) . '/../config.php');
require_once (dirname(__FILE__) . '/smarty/Smarty.class.php');

function futa_pager($current_page, $total_rec, $page_rec, $action, $options=array()) {
  $total_page = max(ceil($total_rec / $page_rec),1); //総ページ数
  $current_page = max($current_page,1);
  $prev_page = $current_page - 1;
  $next_page = $current_page + 1;
  
  $smarty = new Smarty();
    
  $smarty->template_dir = dirname(__FILE__) . '/../templates/';
  $smarty->compile_dir  = dirname(__FILE__) . '/../templates_c/';
  
  $smarty->assign("current_page", $current_page);
  $smarty->assign("prev_page", $prev_page);
  $smarty->assign("next_page", $next_page);
  $smarty->assign("page_rec", $page_rec);
  $smarty->assign("total_page", $total_page);
  
  $smarty->assign("action", $action);
  
  $opts = array();
  reset($options);
  while (list($key, $val) = each($options)) {
    $opts[] = array("key" => $key, "value" => $val);
  }
  $smarty->assign("options", $opts);
  
  $smarty->assign("prange", range(1,$total_page));
  
  return $smarty->fetch('pager.tpl');
}

