<?php

/**
 * metaファイル(スレッド情報)を
 * Sqlite3を利用して格納するkvs
 *
 * PHP5標準のため普及率も高く
 * 一覧処理が得意でバランスが良い
**/

//sqlite3が利用出来るかの判断
function enable_sqlite3(){
  return extension_loaded("sqlite3");
}

class DBA_sqlite3{
  var $con;
  var $lock;
  var $write;

  //modeには'r'か'w'を指定
  function DBA_sqlite3($mode, $dbpath){
    $lockpath =  $dbpath . ".lck";
    if(!is_file($lockpath)){ touch($lockpath); }
    $this->lock = fopen($lockpath, $mode) or die("can't open sqlite.lck");
    flock($this->lock, LOCK_EX) or die("can't lock sqlite.lck");

    if(!is_file($dbpath)){
      $this->con = new SQLite3($dbpath);
      //db テーブル作成

      $this->con->query(
        "create table if not exists metainfos  ".
        " (url text, date integer, info blob, PRIMARY KEY(url)) ");
      $this->con->exec(
        "create index if not exists dateidx on metainfos (date) ");
    }else{
      $this->con = new SQLite3($dbpath);
    }
    $this->con->exec("pragma synchronous=off;");
    $this->con->exec("pragma journal_mode=memory;");
    
    $this->write = false;
  }

  function _trybegin()
  {
    if(!$this->write){
      $this->con->exec("BEGIN DEFERRED;");
      $this->write = true;
    }
  }
  
  function _trycommit()
  {
    if($this->write){
      $this->con->exec("COMMIT;");
      $this->write = false;
    }
  }
  
  function close(){
    $this->_trycommit();
    $this->con->close();
    flock($this->lock, LOCK_UN);
    fclose($this->lock);
  }

  function optimize()
  {
    $this->_trycommit();
    $this->con->exec("VACUUM");
  }

  function get($key){
    $stmt = $this->con->prepare(
      "select info from metainfos ".
      " where url =:url ");
    $stmt->bindValue(":url", $key, SQLITE3_TEXT );

    $result = $stmt->execute();
    $arr = $result->fetchArray(SQLITE3_NUM);

    if($arr){
      return _dba_sqlite_unpack($arr[0]);
    }else{
      return false;
    }
  }

  function set($key, $value){
    $this->_trybegin();
    $stmt = $this->con->prepare(
      " REPLACE INTO metainfos ".
      " values(:url,:date,:info) ");
    $stmt->bindValue(":url", $key, SQLITE3_TEXT );
    $stmt->bindValue(":date", $value["date"], SQLITE3_INTEGER );
    $stmt->bindValue(":info", _dba_sqlite_pack($value), SQLITE3_BLOB );
    $stmt->execute();
  }

  function del($key){
    $this->_trybegin();
    $stmt = $this->con->prepare(
      "delete from metainfos ".
      " where url =:url ");
    $stmt->bindValue(":url", $key, SQLITE3_TEXT );
    $stmt->execute();
  }

  function exists($key){
    return $this->get($key)?true:false;
  }

  function allKeys()
  {
    $stmt = $this->con->prepare(
      "select url from metainfos ".
      " order by date DESC ");

    $result = $stmt->execute();
    $keys = array();
    while($arr = $result->fetchArray(SQLITE3_NUM)){
      $keys[] = $arr[0];
    }
    return $keys;
  }

  function allValues()
  {
    $stmt = $this->con->prepare(
      "select info from metainfos ".
      " order by date DESC ");

    $result = $stmt->execute();
    $values = array();
    while($arr = $result->fetchArray(SQLITE3_NUM)){
      $values[] = _dba_sqlite_unpack( $arr[0] );
    }
    return $values;
  }
}

function _dba_sqlite_pack($value)
{
  if(readDBAConfig("msgpack")){
    return msgpack_pack($value);
  }else{
    return json_encode($value);
  }
}

function _dba_sqlite_unpack($value)
{
  if(readDBAConfig("msgpack")){
    return msgpack_unpack($value);
  }else{
    return json_decode($value,true);
  }
}
