<?php

require_once 'common.php';

class CronLock
{
  var $lockpath;
  var $lock;

  function CronLock($lockname)
  {
    $this->lockpath = readConfig("METADIR") . "CronLock_" . $lockname . ".lck";
  }
  
  function lock($maxexectime=3600)
  {
    if (PHP_OS == "WIN32" || PHP_OS == "WINNT") {
      // windowsł̓t@C݃`FbNōς܂
      // ősԂ߂Ăꍇ
      // OWu^CAEgȂǂŏIĂƂ݂Ȃ
      if(is_file($this->lockpath)){
        if(filemtime($this->lockpath) + $maxexectime > time()){
          return false;
        }
      }
      touch($this->lockpath);
      return true; 
    } else {
      $this->lock = fopen($this->lockpath, "w") or die("can't open cron lock");
      $result = flock($this->lock, LOCK_EX | LOCK_NB);
      if($result){
        log2file("CronLock ". $this->lockpath);
      }
      return $result;
    }
  }
  
  function close()
  {
    if (PHP_OS == "WIN32" || PHP_OS == "WINNT") {
      unlink($this->lockpath);
    } else {
      flock($this->lock, LOCK_UN);
      fclose($this->lock);
    }
  }
  
};



