<?php
/**
 * サイトで保持しているスレッドの一覧を表示する
 *
 * GET パラメータ
 *  a={0,1} 0の場合自己登録スレのみ表示、1の場合全件表示
 *  p=      表示するページ
 *  s=      検索ワード
 *  mode=   表示モード(c=カタログ)
 */

require_once 'config.php';
require_once 'phplib/session.php';
init_session();

require_once 'autotag.php';
require_once 'phplib/common.php';
require_once 'phplib/pager.php';
require_once 'phplib/const.php';

define ('USEBAYES',false);//タグ予測を表示する場合true
if(USEBAYES&&readConfig("BAYESIANTAG")){
  require_once 'phplib/analyze/naivebayes_cache.php';
}

//read metafile
$metaInfoList = readAllInfoCached () ;
$alltags = readalltag($metaInfoList, true);

//calc disk usage
$diskUsageAll = getDiskUsageAll($metaInfoList);

//-----------------------------------
//板名分割

$boards = array_column($boardBook, "name");
$boardtags = array();
$usertags  = array();

foreach($alltags as $tag)
{
  if( in_array( $tag["name"] , $boards) ){
    $boardtags[] = $tag;
  }else{
    $usertags[]  = $tag;
  }
}
$alltags = $usertags;

//-----------------------------------
//表示モード取得
$viewmode = get_value($_GET,"mode",false);
if($viewmode===false){
  $viewmode = get_value($_COOKIE,"VIEWMODE","l");
}
setcookie("VIEWMODE", $viewmode);
$catalogmode = ($viewmode == "c" || $viewmode == "cm");

//-----------------------------------
//表示順の再ソート
$vieworder = false;
if(readConfig("VIEWORDER") && get_value($_GET,"ord",false)){
  $vieworder = true;
  $infos = array();
  $infosSort = array();
  foreach($metaInfoList as $info){
    $infos[] = $info;
    $infosSort[] = $info["first_date"];
  }
  array_multisort($infosSort, SORT_DESC, $infos);

  $metaInfoList = $infos;
}

//-----------------------------------
//お気に入りのみ表示
$favoarg = get_value($_GET,"favo", false);
if($favoarg === false){
  $favoarg = get_value($_COOKIE,"FAVOARG", "0");
}
if(readConfig("STOCKLIST")){
  setcookie("FAVOARG", $favoarg);
}

$favosearch = (readConfig("STOCKLIST") && $favoarg);

if ( $favosearch ) {
  $userkey = read_regid();

  $newlist = array();
  foreach ( $metaInfoList as $meta) {
    if(in_array($userkey, $meta['alluserid'])){
      $newlist [] = $meta;
    }
  }
  $metaInfoList = $newlist;
}

//-------------------------------------------
$searchWord = "";
$fullsv = false;
//検索ワードでの絞込
if(isset($_GET["s"]) && $_GET["s"]!="") {
  $searchWord = htmlspecialchars ($_GET["s"]);

  //全文検索を利用するかどうか
  if(readConfig("USESEARCHSV")) {
    $fullsv = get_value($_GET,"f",false);
  }

  if($fullsv) {
    //レス全体から検索
    $sv = makeFullTextDB();
    $matchurls = $sv->Search($searchWord);
    $sv->close();
    
    sort($matchurls);
    $newlist = array();
    foreach($metaInfoList as $info) {
      if(fast_in_array($info["url"], $matchurls)) {
        $newlist[] = $info;
      }
    }
    $metaInfoList = $newlist;
  }else{
    //1レス目とタグで検索
    $newlist = array();
    foreach($metaInfoList as $info) {
      $res   = $info["res"];

      $tagstr = "";
      foreach($info["tags"] as $tag) {
        $tagstr .= $tag[0];
      }

      if( isContainsWord($tagstr . $res, $searchWord) !== FALSE)
      {
        $newlist[] = $info;
      }
    }
    $metaInfoList = $newlist;
  }
}

//-------------------------------------------------
//添付で絞込
$withFile = false;
if(readConfig("WITHFILE")){
  if(get_value($_GET, "w","0") !="0"){
    $threshold = readConfig("WITHFILE_THRESHOLD", 2);
    $withFile = true;
    $newlist = array();
    foreach($metaInfoList as $info) {

      if( $info['other_files'] >= $threshold )
      {
        $newlist[] = $info;
      }
    }
    $metaInfoList = $newlist;
  }
}

//-------------------------------------------------
//絵被りで絞込
$orign = false;
if(readConfig("USEFILEHASHING")){
  require_once "phplib/filehashing.php";

  $orign = get_value($_GET, "in", false);
  if($orign){
    $dbpath    = readConfig("METADIR") . METAFILEHASH;
    $db = new FileHashDB($dbpath);
    $nearby = $db->near_orign($orign);
    $db->close();
    $newlist = array();
    sort($nearby);
    foreach($metaInfoList as $info) {
      if( fast_in_array($info['url'], $nearby ) )
      {
        $newlist[] = $info;
      }
    }
    $metaInfoList = $newlist;
  }
}

//--------------------------------------------------
//mobileデバイス判定

$ua = mb_strtolower($_SERVER['HTTP_USER_AGENT']);
$mobile = false;
if(strpos($ua,'iphone') !== false){
  $mobile = true;
}elseif(strpos($ua,'ipod') !== false){
  $mobile = true;
}elseif((strpos($ua,'android') !== false) && (strpos($ua, 'mobile') !== false)){
  $mobile = true;
}elseif((strpos($ua,'windows') !== false) && (strpos($ua, 'phone') !== false)){
  $mobile = true;
}elseif((strpos($ua,'firefox') !== false) && (strpos($ua, 'mobile') !== false)){
  $mobile = true;
}elseif(strpos($ua,'blackberry') !== false){
  $mobile = true;
}

//--------------------------------------------------
//pager
$maxPage = 1;
$showPage = 1;
$allCount = count($metaInfoList);
$pageCap = readConfig("PAGECAP");
if($pageCap > 0) {
  $showPage = 1;
  if(isset($_GET["p"])) {
    $showPage = intval($_GET["p"], 10);
  }
  if( $catalogmode ) {
    $pageCap *= 2; //カタログは２倍表示
  }
  $cap = $pageCap;
  $maxPage = ceil(count($metaInfoList) / $cap );
  if( $showPage <= 0 ){
    $showPage = 1;
  }
  if( $showPage > $maxPage ){
    $showPage = $maxPage;
  }

  $metaInfoList = array_slice($metaInfoList, ($showPage-1) * $cap, $cap);
}

//----------------------------------------------------------
function mul_substr($str, $offset, $length)
{
  mb_substr($str, $offset, $length);
}

//----------------------------------------------------------
function my_html_entity_decode($str)
{
  if((version_compare( phpversion(), '5.0' ) < 0)) {
    return html_entity_decode($str);
  } else {
    return html_entity_decode($str, ENT_COMPAT, 'UTF-8');
  }
}

//----------------------------------------------------------
//付加情報の追加

$AUTOBOARDNAME = readConfig("AUTOBOARDNAME");

$userhost = gethostbyaddr(getClientIp());

$tagbook = array();
$itemTables = array();
$newlist = array();
foreach($metaInfoList as $meta) {
  $basenames = urlToBasename($meta["url"]);

  $meta["life_time"] = getLifetime($meta);
  //サムネイル系
  $meta["use_thumb"] = readConfig("THUMB") && $meta["has_thumb"];
  //サイズ計算
  $meta["thumb_h"] = 125;
  $meta["thumb_w"] = 125;

  //タグ系
  $tags = array();
  $tagvals = array();
  foreach($meta["tags"] as $tag) {
    $newtag = array();
    $newtag["value"] = $tag[0];
    $newtag["host"] = $tag[1];
    $tags[] = $newtag;

    $tagvals[] = array(
      "value" => $tag[0],
      "owner" => ($tag[1] == $userhost)
      );
  }
  $meta["tags"] = $tags;
  $tagbook[$meta["url"]] = $tagvals;

  //表示用加工
  $meta["date_v"] = date("Y/m/d H:i:s", $meta["date"]);
  $meta["first_date_v"] = date("Y/m/d H:i:s", $meta["first_date"]);

  $meta["res_count_v"] = number_format($meta["res_count"]-1);
  $meta["du_v"] = number_format(ceil($meta["du"]/1000/100)*0.1,1);

  $meta["life_time_v"] = floor(max($meta["life_time"],0)/60/60);

  $meta["firstregister"] =( $meta["user_regid"] == read_regid()
                            && $meta["user_ip"] == getClientIp());

  if($AUTOBOARDNAME){
    $meta["boardname"] = getBoardName($meta["url"]);
  }else{
    $meta["boardname"] = false;
  }

  $meta["stocked"] = in_array(read_regid(), $meta['alluserid']);

  //-------
  if($catalogmode){
    //カタログの中身生成
    $meta["filebasename"] = basename($meta["url"]);
    $meta["restitle"] = preg_replace("/<.*?>/","", $meta["res"]);

    if($viewmode == "cm"){
      if($meta['has_catalog']){
        $meta['thumb'] = $meta['catalog_path'];
      }
      $meta["reshead"] = htmlentities( mb_substr( my_html_entity_decode( $meta["restitle"] ),0,4), ENT_QUOTES, 'UTF-8' );
      $meta["cattime"] = mb_substr($meta["src1res_day"],strlen($meta["src1res_day"])-2,2) ." ". mb_substr($meta["src1res_time"], 0,5);
    }else{
      $meta["reshead"] = htmlentities( mb_substr( my_html_entity_decode( $meta["restitle"] ),0,8), ENT_QUOTES, 'UTF-8' );
    }

    $smarty = new Smarty();
    $smarty->assign('meta', $meta);
    $smarty->assign('USEZIP', readConfig("USEZIP"));
    $smarty->assign('NEARBY', readConfig("USEFILEHASHING"));
    
    if($viewmode == "cm"){
      $itemTables[] = $smarty->fetch('index-catitemmin.tpl');
    }else{
      $itemTables[] = $smarty->fetch('index-catitem.tpl');
    }
  }
  //-------
  $newlist[] = $meta;
}
$metaInfoList = $newlist;

//タグ予測
if(USEBAYES && !$catalogmode && readConfig("BAYESIANTAG")) {
  $newlist = array();
  $bayes = new NaiveBayesCache();
  foreach($metaInfoList as $meta) {
    $meta['bayestag'] = $bayes->classifier( $meta["res"], $meta["url"]);
    $newlist[] = $meta;
  }
  $bayes->close();
  $metaInfoList = $newlist;
}

// ページャの作成
$pageropt = array();
if($searchWord != ""){
  $pageropt["s"] = $searchWord;
}
if($viewmode){
  $pageropt["mode"] = $viewmode;
}
if($fullsv){
  $pageropt["f"] = 1;
}
if(readConfig("STOCKLIST")){
  $pageropt["favo"] = $favoarg;
}
if($withFile){
  $pageropt["w"] = 1;
}
if($orign){
  $pageropt["in"] = $orign;
}
if($vieworder){
  $pageropt["ord"] = 1;
}

$pager = "";
if($pageCap > 0) {
  $pager = futa_pager($showPage,$allCount,$pageCap,"index.php",$pageropt);
}


$options = array();
reset($options);
while (list($key, $val) = each($pageropt)) {
  if($key != 'mode'){
    $options[] = array("key" => $key, "value" => $val);
  }
}

//テンプレート呼び出し

$smarty = new Smarty();

$smarty->assign('title',  readConfig("TITLE") );
$smarty->assign('USEZIP', readConfig("USEZIP"));
$smarty->assign('LIMITCAP', readConfig("LIMITCAP"));
$smarty->assign('LIFETIME', readConfig("LIFETIME"));
$smarty->assign('searchWord', $searchWord);

$smarty->assign('metaInfoListCount', $allCount);
$smarty->assign('metaInfoList', $metaInfoList);
$smarty->assign('totaldu', number_format(ceil($diskUsageAll / 1000 / 100)*0.1));

$smarty->assign('pager', $pager);

$smarty->assign('alltag', $alltags);
$smarty->assign('boardtags', $boardtags);

$smarty->assign('bookmarklet', "javascript:(function(){window.open('" . get_current_uri_dir() . "scrapshot.php?rooturl='+encodeURIComponent(document.URL));})()");

$smarty->assign('showPage', $showPage);
$smarty->assign('searchWord', $searchWord);

$smarty->assign('USECONTACT', readConfig("USECONTACT"));

$smarty->assign('itemtables', $itemTables);
$smarty->assign('catalogmode', $catalogmode);

$smarty->assign('USESEARCHSV', readConfig("USESEARCHSV"));
$smarty->assign('fullsv', $fullsv);

$smarty->assign('BAYESIANTAG',USEBAYES&&readConfig("BAYESIANTAG") );
$smarty->assign('tagbook', json_encode($tagbook) );

$smarty->assign('STOCKLIST', readConfig("STOCKLIST"));
$smarty->assign('favoarg', $favoarg);

$smarty->assign('USEWITHFILE', readConfig("WITHFILE"));
$smarty->assign('WITHFILE_MSG', readConfig("WITHFILE_MSG"));
$smarty->assign('withFile', $withFile);
$smarty->assign('NEARBY', readConfig("USEFILEHASHING"));

$smarty->assign('USEVIEWORDER', readConfig("VIEWORDER"));
$smarty->assign('VIEWORDER', $vieworder);

$smarty->assign('options', $options);

$smarty->assign('MINICATALOG', $viewmode == "cm");

$smarty->assign('mobile', $mobile);

$smarty->display('index.tpl');
