<?php
/**
 * 削除ページ
 * 指定のスレッド１件あたりの削除を行う
 * 
 * POSTパラメータ
 *  rooturl      削除スレッドの取得元url
 *  passwd       管理者パスワード
 *
 * GETパラメータ(表からのリンク用)
 *  rooturl      削除スレッドの取得元url
 *               POSTの同パラメータが無い場合のみ利用
 *  retaddr      処理後に表示するページ
 *
 *
 */


require_once 'config.php';
require_once 'phplib/session.php';
init_session();

require_once 'phplib/common.php';
require_once 'phplib/result.php';
require_once 'blacklist.php';

require_once 'phplib/smarty/Smarty.class.php';

//----------------------------------
//query param

$GETURL=get_value($_POST,"rooturl");
$PASSWD=get_value($_POST,"passwd");
$RETADDR = get_value($_REQUEST,"retaddr");

//-----------------------------------------------------------------
//body

$succ = false;

if(!$GETURL) {
  $GETURL=get_value($_GET,"rooturl");
}

//-----------------------------------------------------------------
//ホストがブラックリストに無いかチェック
if (isWriteBlockHost(getClientIp())) {
  echo errorPage( "アクセス規制中です" );
  return ;
}

//-----------------------------------------------------------------
//表示モードが全件で
//自己登録スレッドでないスレッドの削除の場合は
//管理者パスワードを要求する
//

$errmsg = "";
if($GETURL) {
  
  $metadata = readUrlInfo($GETURL);
  
  
  //対象ファイルを保持っているかチェック
  if($metadata){
    $userid = read_regid();
    if(readConfig("STOCKLIST") && in_array(read_regid(), $metadata['alluserid']) ){
      //ストックされている場合まずストック一覧から外し
      //以降の処理はスキップする
      $newuserids = array();
      foreach( $metadata['alluserid'] as $id){
        if($id != $userid){
          $newuserids[] = $id;
        }
      }
      $metadata['alluserid'] = $newuserids;
      saveInfo($metadata);
      removeJsonApiCache();
      $errmsg = "ストック一覧から削除しました<br>ログも削除する場合は続けて入力してください";
    }else
    
    //自己登録スレッドか
    //管理者パスワードが正しい場合は削除
    if( (readConfig("FIRSTUSERDEL")
      && $metadata["user_regid"] == read_regid()
      && $metadata["user_ip"] == getClientIp() )
     || md5($PASSWD) == readConfig("RMPASSWD"))
    {
      log2file("remove.php " . $GETURL );
      
      removePage($GETURL);//ページの削除
      
      //メッセージ変更
      $errmsg = "指定したスレッドを削除しました";
      $GETURL = "";
      $PASSWD = "";
      $succ = true;
    }else{
      if(isset($_POST["rooturl"])){
        $errmsg = "削除パスワードが一致しません ";
      }
    }
  }else{
    $errmsg = "削除対象ファイルがありません";
  }
}

//ページへ移動
if($RETADDR){
  header('Location: ' . $RETADDR);
  return ;
}

//--------------------------------------------------
//load template

$smarty = new Smarty();

$smarty->assign('title', readConfig("TITLE"));
$smarty->assign('geturl', $GETURL);
$smarty->assign('passwd', $PASSWD);
$smarty->assign('errmsg', $errmsg);
$smarty->assign('succ',$succ);
$smarty->assign('FIRSTUSERDEL', readConfig("FIRSTUSERDEL"));

$smarty->display('remove.tpl');

