<?php

/**
 * 短縮urlの生成
 * param:
 *  $url      短縮するurl
 *  $storedir リンクファイルを置くディレクトリ (末尾 /)
 *  $storeurl リンクファイルを置くディレクトリのurl (末尾 /)
 * result:
 *  array
 *   0 => 短縮url
 *   1 => リンクファイルのパス
**/
function shortly_url($url, $storedir, $storeurl) {
  $hash = sr_hex2s64(md5($url));
  
  $linkpath = $storedir . $hash . ".htm";
  $linkurl  = $storeurl . $hash . ".htm";
  
  if(!is_file($linkpath)) {
    //リンクファイル書き込み
    $cont = '<meta http-equiv="refresh" content="0;URL=' . $url . '">';
    file_put_contents ($linkpath, $cont);
  }
  
  return array($linkurl, $linkpath);
}

//-----------------------------------------------------------------
//以下実装用関数

/**
 * md5()等が生成する16進文字列を受け取り
 * 短縮url用の独自の64進文字列にする
**/
function sr_hex2s64($hex) {
  $char_table = "0123456789qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM-_";
  $tablelen = strlen($char_table);
  
  $output = "";
  $cut = 6;
  $hex = strrev($hex);
  
  while(strlen($hex) > 0) {
    $dec = hexdec( strrev(substr($hex,0,$cut)) ) ;
    
    $dec = ((int)($dec / 4096)) xor ($dec % 4096);
    
    while( $dec > 0 ) {
      $cnum = $dec % $tablelen;
      $output .= $char_table[$cnum];
      $dec = (($dec - $cnum) / $tablelen);
    }
    $hex = substr($hex,$cut);
  }
  return $output;
}

