<?php
/**
 * 一括削除管理用ページ
 */

require_once 'config.php';
require_once 'phplib/session.php';
init_session();

require_once 'phplib/common.php';
require_once 'phplib/pager.php';
require_once 'phplib/smarty/Smarty.class.php';

//----------------------------------
//query param

$PASSWD=get_value($_REQUEST,"passwd");
$CHKURL=get_value($_REQUEST,"chk",array());
$DELTAG=get_value($_REQUEST,"deltag",array());
$CHKSRC=get_value($_REQUEST,"chksrc",array());

//-----------------------------------
//指定されたスレッドの削除

foreach($CHKURL as $url) {
  log2file("admin.php del " . $url );
  removePage($url);
}

//----------------------------------

//read metafile
$metaInfoList = readAllInfoCached () ;

$metaInfoListCount = count( $metaInfoList );

//指定したタグの削除

if(count($DELTAG) > 0) {
  $newmetalist = array();
  foreach ($metaInfoList as $meta){
    $newtags = array();
    foreach($meta['tags'] as $tag) {
      $hash = "t_" . md5($meta["url"] . $tag[0]);
      if(!in_array($hash,$DELTAG)) {
        $newtags[] = $tag;
      }
    }
    if(count($meta['tags']) != count($newtags)) {
      //削除タグが存在した場合はセーブ
      $meta['tags'] = $newtags;

      saveInfo($meta);
    }
    $newmetalist[] = $meta;
  }
  $metaInfoList = $newmetalist;
}

//-----------------------------------

//calc disk usage
$diskUsageAll = getDiskUsageAll($metaInfoList);

$searchWord = "";

//検索ワードでの絞込
if(isset($_REQUEST["s"]) && $_REQUEST["s"]!="") {
  $searchWord = $_REQUEST["s"];

  $newlist = array();
  foreach($metaInfoList as $info) {
    $res     = $info["res"];
    $host    = $info["user_host"];
    $regid   = $info["user_regid"];

    $tagstr = "";
    foreach($info["tags"] as $tag) {
      $tagstr .= $tag[0];
    }

    if( isContainsWord($tagstr . $res, $searchWord) !== FALSE
     || strpos($host, $searchWord) !== FALSE
     || strpos($regid, $searchWord) !== FALSE )
    {
      $newlist[] = $info;
    }
  }
  $metaInfoList = $newlist;
}


//連絡のあるスレのみ
if(in_array("contact", $CHKSRC)){
  $newlist = array();

  foreach($metaInfoList as $info) {
    if( count( $info["contacts"] ) > 0 )
    {
      $newlist[] = $info;
    }
  }

  $metaInfoList = $newlist;
}

//--------------------------------------------------
//pager
$maxPage = 1;
$showPage = 1;
$allCount = count($metaInfoList);
$pageCap = readConfig("PAGECAP");
if($pageCap > 0) {
  $showPage = 1;
  if(isset($_GET["p"])) {
    $showPage = intval($_GET["p"], 10);
  }
  $cap = $pageCap;
  $maxPage = ceil(count($metaInfoList) / $cap );
  if( $showPage <= 0 ){
    $showPage = 1;
  }
  if( $showPage > $maxPage ){
    $showPage = $maxPage;
  }

  $metaInfoList = array_slice($metaInfoList, ($showPage-1) * $cap, $cap);
}

//---------------------------------------------------
//付加情報の追加
$newlist = array();
foreach($metaInfoList as $meta) {

  //サムネイル系
  $meta["use_thumb"] = readConfig("THUMB") && $meta["has_thumb"];
  //サイズ計算
  $meta["thumb_h"] = 0;
  $meta["thumb_w"] = 0;
  if($meta["use_thumb"]){
    //$size = GetImageSize($meta["thumb"]);
    $meta["thumb_w"] = 125;//$size[0] / 2;
    $meta["thumb_h"] = 125;//$size[1] / 2;
  }
  //タグ系
  $tags = array();
  foreach($meta["tags"] as $tag) {
    $newtag = array();
    $newtag["value"] = $tag[0];
    $newtag["host"] = $tag[1];
    $newtag["tagfrm"] = "t_" . md5($meta["url"] . $tag[0]);

    $tags[] = $newtag;
  }
  $meta["tags"] = $tags;

  //連絡系
  $contacts = array();
  foreach($meta["contacts"] as $contact) {
    $newtag = array();
    $newtag["value"] = $contact[0];
    $newtag["host"] = $contact[1];

    $contacts[] = $newtag;
  }
  $meta["contacts"] = $contacts;

  $meta["formid"] = "f_" . md5($meta["url"]);

  //表示用加工
  $meta["date_v"] = date("Y/m/d H:i:s", $meta["date"]);
  $meta["first_date_v"] = date("Y/m/d H:i:s", $meta["first_date"]);

  $meta["res_count_v"] = number_format($meta["res_count"]-1);
  $meta["du_v"] = number_format(ceil($meta["du"]/1000/100)*0.1,1);

  $newlist[] = $meta;
}
$metaInfoList = $newlist;

// ページャの作成
$pageropt = array();
if($searchWord != ""){
  $pageropt["s"] = $searchWord;
}
$pageropt["passwd"] = $PASSWD;

$pager = "";
if($pageCap > 0) {
  $pager = futa_pager($showPage,$allCount,$pageCap,"admin.php",$pageropt);
}

//--------------------------------------

$smarty = new Smarty();

$smarty->assign('title',  readConfig("TITLE") );
$smarty->assign('USEZIP', readConfig("USEZIP"));
$smarty->assign('LIMITCAP', readConfig("LIMITCAP"));
$smarty->assign('PASSWD', $PASSWD);
$smarty->assign('MD5PASSWD', md5($PASSWD));

$smarty->assign('searchWord', $searchWord);

$smarty->assign('metaInfoList', $metaInfoList);
$smarty->assign('metaInfoListCount', $metaInfoListCount);
$smarty->assign('conform', md5($PASSWD) == readConfig("RMPASSWD"));
$smarty->assign('totaldu', number_format(ceil($diskUsageAll / 1000 / 100)*0.1));

$smarty->assign('CHK_CONTACT', in_array("contact", $CHKSRC));

$smarty->assign('pager', $pager);
$smarty->assign('alltag', readalltag($metaInfoList, true));

$smarty->display('admin.tpl');
