<?php

if(!defined ( 'CONFIG_PHP_INC_' )) {
define('CONFIG_PHP_INC_', 't' );


$ROOTURL = "";            //公開するURLを手動で指定する場合変更
$ROOTDIR = dirname(__FILE__) . "/";

/*
 *設定情報一覧
 * "LIMITCAP" "LIFETIME" "RMPASSWD" 辺りの設定が重要です
 *
 *-----------------------
 * "TITLE"
 * タイトルを変更したい場合に修正してください
 *
 *-----------------------
 * "CONTDIR"
 * "METADIR"
 * "ZIPDIR"
 * "LOCKDIR"
 * "CONTURL"
 * "ZIPURL" 
 *　ディレクトリ配置などを設定します
 * 変更不要です。
 *
 *-----------------------
 *　"THUMB"
 * 保存しているスレッド一覧画面に
 * サムネイル画像と1レス目テキストを表示する場合にtrue
 * falseの場合はスレッドtitleのみ表示されます
 *
 *-----------------------
 *　"USEZIP"
 * zip/mhtファイルのダウンロード機能を有効にするばあいtrue
 * 一覧画面に"download"のリンクを生成します
 * zip/mhtファイルを生成するため
 * ディスク容量を最大で３倍消費する事に注意してください
 *
 *-----------------------
 * "URLREGX"
 * ダウンロード対象スレッドurlを正規表現で記載します
 * ダウンロード先の板の制限をしたい場合はこれを修正します
 * 例) 双葉全体を許可(デフォルト)
 * "/http:\/\/...\.2chan\.net\/(.*)\/res/i"
 * 例) 虹裏(may)のみ許可
 * "/http:\/\/may\.2chan\.net\/b\/res/i"
 *
 *-----------------------
 * "RMPASSWD"
 * 管理者パスワードを設定します
 * 削除時に入力したりします
 * md5値で設定してください
 *
 *-----------------------
 * "LIFETIME"
 * 保存したスレッドを時間制限型で削除する場合に利用します
 * ログの生存秒数を設定し0で無視になります
 * 時間制限型で削除する場合は この設定の他に
 * cron_del.phpをcrontab等で動作させる必要があります
 *
 *-----------------------
 * "PAGECAP"
 * 一覧ページの1ページあたりに表示するスレッド数を指定します
 * 0で無制限
 *
 *-----------------------
 *　"LIMITCAP"
 *　保存するスレッドの上限数を指定します(0で無制限)
 * スレッド数上限を設けてログ数制御する場合に利用します
 * crontabが利用できない場合でも
 * こちらの設定ではスレッド数制限を行えます
 * 
 * 保存したスレッドを時間制限型で削除する場合に0を指定します
 *
 *-----------------------
 *　"RMADLINK"
 * 取得ログ中のふたばの広告を削除する場合trueに設定します
 * 双葉由来のデータなので広告を表示するかは設置者の判断に任せます
 *
 * また実装方法が div タグをばっさり削除する方法を使っているため
 * 将来的にうまく動作しなくなる可能性もあります
 *
 *-----------------------
 *　"COOLTIME"
 *　スレッドを取得してから再度取得するまでに必要な秒数を設定します
 *　ボタン連打等の連続更新を無効化するための機能です
 * 連続更新された場合はふたばへのアクセスは行わず
 * 前回分のデータがそのまま表示されます。
 *
 * またzipファイル作成のコストが気になる場合や
 * スレッドを追尾して自動更新する場合は
 * この数値設定を長めに設定するのもいいでしょう
 *
 *-----------------------
 * "SIO_LOCK"
 * 塩辛瓶からのファイル取得時のロックファイルのパスを指定します
 * このパスのファイルをロックすることで塩辛瓶からの取得のwait秒の調整をしています
 * 
 * デフォルトではこの双葉写本１つ辺りのロックファイルを指定していますが
 * 同じサーバーに複数の双葉写本を設置する場合は
 * 共通のロックファイルを参照するように設定してください
 * そうでないと同時アクセスしてしまい塩辛瓶からIP BANされてしまいます
 *
 *-----------------------
 * "COOKIE"
 *「自分が登録したスレッドのみ一覧に表示する機能」で利用されます
 * 経緯上でこの名称を踏襲していますが
 * falseの場合でもユーザー特定等でクッキーやセッションの利用は行います
 * 
 *-----------------------
 * "COOKIE_EXP"
 * "COOKIE" が trueの場合のみ利用されます
 * クッキーとセッションの有効日数を設定します
 *
 *-----------------------
 * "SESSPATH"
 * "COOKIE" が trueの場合のみ利用されます
 * サーバー上でのセッションの保存先を指定します
 * セッション保存きかんを長くする関係上
 * デフォルトのphpセッション保存先とは別に用意する必要があります
 * 設定では"/tmp"としていますが再起動時に消える等問題があるため
 * サーバーの状況に合わせて設定する必要があります
 * 
 *-----------------------
 * "USEJSON"
 * スレッドデータ保存にjson形式を利用します
 * 
 *-----------------------
 * "LIFETIME_TYPE"
 * 定時削除を利用する際の
 * 生存秒数の基準をどの時刻にするかを設定する
 * 0 最終更新時刻     (自動更新で更新される)
 * 1 最終ユーザー更新 (自動更新で更新されない)
 * 2 初回登録時刻
 * 
 *-----------------------
 * "COUNT_FILES"
 * 保有コンテンツ数を数える場合にtrue
 *
 *-----------------------
 * "IMGDIR_SYNC"
 * スレッドで削除済みの画像をキャッシュから消す場合true
 *
 *-----------------------
 * "USELIGHTBOX"
 * リンク先の画像表示にlightboxを使う場合true
 * ダイアログで画像表示するようになる
 *
 *-----------------------
 * "REMOTEROOT"
 * ホスト写本URLを指定する場合入力
 * ホスト写本経由でスレッドの取得を行います
 *
 *-----------------------
 * "ZIPONTHEFLY"
 * trueの場合zip/mhtをオンザフライでダウンロードさせます
 * zip/mhtファイルを保存しなくなるため
 * ディスク容量の消費を抑えることができますが
 * ダウンロード開始時にファイルの総容量がわからないため
 * ダウンロードプログレスバーが表示出来なくなる欠点もあります
 *
 *-----------------------
 * "USECONTACT"
 * "削除連絡"機能を使う場合にtrueを設定します
 * 
 * 
 *-----------------------
 * "MAILTOCONTACT"
 * 削除連絡を受けた時にメール送信を行う場合
 * 送信先メールアドレスを指定します
 * 設置鯖をメール鯖として利用できる場合のみ
 * メール送付できます
 * 
 *-----------------------
 * "AUTOBOARDNAME"
 * trueの場合ふたばスレッド取得時に
 * 取得元の板の名前を自動でタグ付けします
 * 
 *-----------------------
 * "USESEARCHSV"
 * 外部の全文検索エンジンを利用する場合true
 * Elasticsearchに対応しています
 * 
 *-----------------------
 * "SEARCHSVADDR"
 * Elasticsearchのサーバー名/インデックス名を設定します
 * サーバーが localhost:9200
 * インデックスが test の場合は
 * "http://localhost:9200/test/" と指定します
 * 
**/
$APPCONST = array(
  "TITLE"   => "双葉写本",
  "CONTDIR" => $ROOTDIR . "cont/",
  "METADIR" => $ROOTDIR . "meta/",
  "ZIPDIR"  => $ROOTDIR . "zip/",
  "LOCKDIR" => $ROOTDIR . "lock/",
  "CONTURL" => $ROOTURL . "cont/",
  "ZIPURL"  => $ROOTURL . "zip/",
  "THUMB"   => true,                                     //一覧にサムネイルを表示する場合true
  "USEZIP"  => true,                                     //zipダウンロードさせる場合true
  "URLREGX" => "/^http:\/\/[^\/]*.kemoren.com/i", //ダウンロード対象url（正規表現)
  "RMPASSWD" => md5("passwd"),                           //共通削除パスワードのmd5値(変更必須)
  "LIFETIME" => 0,                                       //cronで削除する場合のログの生存秒数(0で無視)
  "PAGECAP"  => 20,                                      //1ページに表示するスレッド数(0で無制限)
  "LIMITCAP" => 2000,                                    //保存するスレッドの上限(0で無制限)
  "RMADLINK" => true,                                    //ふたばの広告を削除する場合true
  "COOLTIME" => 10,                                      //連続した更新を無効にする秒数
  "SIO_LOCK" => $ROOTDIR . "lock/SIO_GET.lock",          //塩辛瓶の取得ウェイト用のロックパス名
  "COOKIE"   => false,                                   //クッキーとセッションを利用する機能を有効にする場合true
  "COOKIE_EXP" => 10,                                    //クッキーとセッションの有効日数
  "SESSPATH" => "/tmp",                                  //セッションの保存先
  "USEJSON"  => false,                                   //データ保存にjsonを利用する場合true
  "LIFETIME_TYPE" => 0,                                  //生存秒数の基準
  "COUNT_FILES" => false,                                //スレッドのファイル数を数える場合true
  "IMGDIR_SYNC" => true,                                 //スレッドで削除済みの画像をキャッシュから消す場合true
  "USELIGHTBOX" => false,                                //画像表示にlightboxを使う場合true
  "REMOTEROOT" => "",                                    //ホスト写本URLを指定
  "ZIPONTHEFLY" => false,                                //zip/mhtファイルをオンザフライにする場合true
  "USECONTACT" => false,                                 //"連絡"機能を表示する場合true
  "MAILTOCONTACT" => "",                                 //"連絡"機能の送信先メールアドレス
  "AUTOBOARDNAME" => false,                              //自動で"板名"のタグを付ける場合true
  "USESEARCHSV" => false,                                //全文検索エンジンを利用する場合true
  "SEARCHSVADDR" => "",                                  //全文検索エンジンのURL情報
);

function readConfig($key,$default=FALSE)
{
  global $APPCONST;
  if(array_key_exists($key,$APPCONST)){
    return $APPCONST[$key];
  }else{
    return $default;
  }
}


//------------------------------------------------------
//initial function

#ini_set( 'display_errors', 1 ); 

function getEncoding(){
  return "SJIS";  //ふたばのhtmlのエンコードを指定
}

mb_language("ja");
mb_internal_encoding("UTF8");
mb_regex_encoding( "UTF8" );

if (function_exists('date_default_timezone_set')) {
  date_default_timezone_set('Asia/Tokyo');
}

//タイムアウト設定
set_time_limit(600);

//ユーザー切断による強制終了を無効化
ignore_user_abort(1);

//エラー出力を行う
ini_set( 'display_errors', 1 );


//------------------------------------------------------
//common function

function get_current_uri(){
    return "http://".$_SERVER["HTTP_HOST"].$_SERVER["SCRIPT_NAME"];
}

function get_current_uri_dir() {
    global $ROOTURL;
    if($ROOTURL != "") {
      return $ROOTURL;
    }
    if(isset($_SERVER["HTTP_X_FORWARDED_HOST"]) && $_SERVER["HTTP_X_FORWARDED_HOST"] != "") {
      return "http://".$_SERVER["HTTP_X_FORWARDED_HOST"].dirname($_SERVER["SCRIPT_NAME"])."/";
    }
    return "http://".$_SERVER["HTTP_HOST"].dirname($_SERVER["SCRIPT_NAME"])."/";
}

function saniPath($basename) {
  return str_replace(".htm","",str_replace("/","_",$basename));
}

function saniCookie($basename) {
  return str_replace(".htm","",str_replace(".","_",str_replace("/","_",$basename)));
}

function metaFileSfx() {

  $meta_sfx = ".info";
  if(readConfig("USEJSON")){
    $meta_sfx = ".json";
  }
  return $meta_sfx;
}

function urlToBasename($url) {

  //URLから各種関連情報を抽出
  $basename = substr($url, 7);

  $result = array(
    "CONT" => saniPath($basename) . "/",
    "ZIP"  => saniPath($basename) . ".zip",
    "MHT"  => saniPath($basename) . ".mht",
    "LOCK" => saniPath($basename) . ".lock",
    "META" => saniPath($basename) . metaFileSfx()
  );
  
  return $result;
}

} //if(!defined ( 'CONFIG_PHP_INC_' ))

