<?php

include_once 'config.php';
include_once 'phplib/common.php';

//metaファイル配下を参照し
//古いmetaファイルと関連するファイルを自動で削除する

if (readConfig("LIFETIME") > 0){

//read metafile
$metaInfoList = readAllInfo () ;

$cont_uses = array();

//remove
foreach($metaInfoList as $info) {
  $basenames = urlToBasename($info["url"]);
  $idxdir  = readConfig("CONTDIR") . $basenames["CONT"];
  $idxpath = $idxdir . _PGET_INDEX_PAGE_;
  $info["life_time"] = getLifetime($info);
  if($info["life_time"] <= 0 || !is_dir($idxdir) || !is_file($idxpath) ){
    log2file("cron_del.php " . $info["url"] );
    removePage($info["url"]);
  }
  
  $cont_uses[] = $basenames["CONT"];
}

//-----------------------------------------
//metaファイルが無い cont/ 内のファイルを削除
//windows環境では問題になる場合があるので手動で有効にすること

/*
$zombies = array();

$rootdir = readConfig("CONTDIR");
if ($dir = opendir($rootdir)){
  while ($fbase = readdir($dir)){
    $path = $rootdir .  $fbase;
    if($fbase != '.' && $fbase != '..' && is_dir($path)) {
      if(!in_array($fbase, $cont_uses)){
        $files = find_files($path);
        if(count($files) == 0){
          $zombies[] = $path;
        }
      }
    }
  }
  closedir($dir);
}

foreach($zombies as $target){
  log2file("cron_del.php del zombie " . $target );
  remove_directory($target);
}
//*/

} // readConfig("LIFETIME") > 0

function cleanOldfiles($rootdir, $lifetime) {
  if ($dir = opendir($rootdir)){
    while ($fbase = readdir($dir)){
      if($fbase != '.' && $fbase != '..') {
        $path = $rootdir . $fbase;
        if( is_file($path) && filemtime($path) + $lifetime < time()){
          unlink( $path );
        }
      }
    }
    closedir($dir);
  }
}

//linkフォルダのゴミ削除
cleanOldfiles($ROOTDIR . "l/", 72*60*60);

//lockフォルダのゴミ削除
cleanOldfiles($ROOTDIR . "lock/", 72*60*60);

//zipフォルダの掃除
cleanOldfiles($ROOTDIR . "zip/", 1*60*60);


//-----------------------------------------
//meta フォルダの最適化
meta_optimize();

