<?php

require_once 'config.php';
require_once 'phplib/common.php';
require_once 'phplib/smarty/Smarty.class.php';

if( !readConfig("USECONTACT")) {
  return false;
}

$reason = get_value($_REQUEST,'reason');
$logurl = get_value($_REQUEST,'logurl');

//メール送信
function sendmail($logurl, $reason) {
  //shell shockがあるのでmb_send_mailには注意が必要
  if( readConfig("MAILTOCONTACT") != "") {
    date_default_timezone_set('Asia/Tokyo');
    
    $to = readConfig("MAILTOCONTACT"); //送信先
    $IP = getClientIp();
    $HOST = gethostbyaddr($IP);
    $datetime = date("Y-n-j H:i:s");
    $subject = "連絡 [".readConfig("TITLE")."]";
    $body = readConfig("TITLE")." にて次の連絡がありました。\n\nログurl：".$logurl."\n内容：".$reason."\n申告者IP：$IP\n申告者HOST：$HOST\n申告日時：$datetime\n\n以上です。";
    
    //送信
    mb_language("Japanese");
    mb_internal_encoding ("SJIS");
    mb_send_mail(
      $to,
      mb_convert_encoding($subject, "SJIS", "UTF8"), 
      mb_convert_encoding($body, "SJIS", "UTF8")
      );
    log2file( $to );
    log2file( $subject );
    log2file( $body );
  }
}

//連絡入力
if($logurl) {
  if($reason) {
    //連絡の追加
    addcontact($logurl, $reason );
    
    //メール送付
    sendmail($logurl, $reason);
    
    //連絡ページ表示
    $smarty = new Smarty();
    $smarty->assign('logurl',$logurl);
    $smarty->display('contact_done.tpl');
  }else{
    //連絡ページ表示
    $smarty = new Smarty();
    $smarty->assign('logurl',$logurl);
    $smarty->display('contact.tpl');
  }
}else{
  header("HTTP/1.1 404 Not Found");
}

