<?php

if(!defined ( 'CONFIG_PHP_INC_' )) {
define('CONFIG_PHP_INC_', 't' );


$ROOTURL = "";            //公開するURLを手動で指定する場合変更
$ROOTDIR = dirname(__FILE__) . "/";

/*
 *設定情報一覧
 * "LIMITCAP" "LIFETIME" "RMPASSWD" 辺りの設定が重要です
 *
 *-----------------------
 * "TITLE"
 * タイトルを変更したい場合に修正してください
 *
 *-----------------------
 * "CONTDIR"
 * "METADIR"
 * "ZIPDIR"
 * "LOCKDIR"
 * "CONTURL"
 * "ZIPURL"
 *　ディレクトリ配置などを設定します
 * 変更不要です。
 *
 *-----------------------
 *　"THUMB"
 * 保存しているスレッド一覧画面に
 * サムネイル画像と1レス目テキストを表示する場合にtrue
 * falseの場合はスレッドtitleのみ表示されます
 *
 *-----------------------
 *　"USEZIP"
 * zip/mhtファイルのダウンロード機能を有効にする場合にtrue
 * 一覧画面に"download"のリンクを生成します
 *
 *-----------------------
 * "URLREGX"
 * ダウンロード対象スレッドurlを正規表現で記載します
 * ダウンロード先の板の制限をしたい場合はこれを修正します
 * 例) 双葉全体を許可(デフォルト)
 * "/http:\/\/...\.2chan\.net\/(.*)\/res/i"
 * 例) 虹裏(may)のみ許可
 * "/http:\/\/may\.2chan\.net\/b\/res/i"
 *
 *-----------------------
 * "RMPASSWD"
 * 管理者パスワードを設定します
 * 削除時に入力したりします
 * md5値で設定してください
 *
 *-----------------------
 * "LIFETIME"
 * 保存したスレッドを時間制限型で削除する場合に利用します
 * ログの生存秒数を設定し0で無視になります
 * 時間制限型で削除する場合は この設定の他に
 * cron_del.phpをcrontab等で動作させる必要があります
 *
 *-----------------------
 * "PAGECAP"
 * 一覧ページの1ページあたりに表示するスレッド数を指定します
 * 0で無制限
 *
 *-----------------------
 *　"LIMITCAP"
 *　保存するスレッドの上限数を指定します(0で無制限)
 * スレッド数上限を設けてログ数制御する場合に利用します
 * crontabが利用できない場合でも
 * こちらの設定ではスレッド数制限を行えます
 *
 * 保存したスレッドを時間制限型で削除する場合に0を指定します
 *
 *-----------------------
 *　"RMADLINK"
 * 取得ログ中のふたばの広告を削除する場合trueに設定します
 * 双葉由来のデータなので広告を表示するかは設置者の判断に任せます
 *
 * また実装方法が div タグをばっさり削除する方法を使っているため
 * 将来的にうまく動作しなくなる可能性もあります
 *
 *-----------------------
 *　"COOLTIME"
 *　スレッドを取得してから再度取得するまでに必要な秒数を設定します
 *　ボタン連打等の連続更新を無効化するための機能です
 * 連続更新された場合はふたばへのアクセスは行わず
 * 前回分のデータがそのまま表示されます。
 *
 * またzipファイル作成のコストが気になる場合や
 * スレッドを追尾して自動更新する場合は
 * この数値設定を長めに設定するのもいいでしょう
 *
 *-----------------------
 * "SIO_LOCK"
 * 塩辛瓶からのファイル取得時のロックファイルのパスを指定します
 * このパスのファイルをロックすることで塩辛瓶からの取得のwait秒の調整をしています
 *
 * デフォルトではこのFTBucket１つ辺りのロックファイルを指定していますが
 * 同じサーバーに複数のFTBucketを設置する場合は
 * 共通のロックファイルを参照するように設定してください
 * そうでないと同時アクセスしてしまい塩辛瓶からIP BANされてしまいます
 *
 *-----------------------
 * "LIFETIME_TYPE"
 * 定時削除を利用する際の
 * 生存秒数の基準をどの時刻にするかを設定する
 * 0 最終更新時刻     (自動更新で更新される)
 * 1 最終ユーザー更新 (自動更新で更新されない)
 * 2 初回登録時刻
 *
 *-----------------------
 * "IMGDIR_SYNC"
 * スレッドで削除済みの画像をキャッシュから消す場合true
 *
 *-----------------------
 * "USELIGHTBOX"
 * リンク先の画像表示にlightboxを使う場合true
 * ダイアログで画像表示するようになる
 *
 *-----------------------
 * "REMOTEROOT"
 * キャッシュ用(更新あり)の親バケットのURLを指定します
 * スレッド取得時には親バケットを更新し
 * 親バケット経由でスレッドの取得を行います
 *
 *-----------------------
 * "SUBSCRIBES"
 * 読み取り専用の親バケットのURLリストを指定します
 * 「自分,キャッシュ,ふたば」の何処にもログが無い場合に取得先に利用します
 * キャッシュ用のバケットとは違い親バケットを更新しません
 *
 *-----------------------
 * "REBUILDLOG"
 * 親バケットから取り込み時にログの再編集をする場合true
 * ログの変換形式が親バケットと異なる場合に利用します
 *
 *-----------------------
 * "ZIPONTHEFLY"
 * trueの場合zip/mhtをオンザフライでダウンロードさせます
 * zip/mhtファイルを保存しなくなるため
 * ディスク容量の消費を抑えることができますが
 * ダウンロード時にプログレスバーが表示出来なくなります
 *
 *-----------------------
 * "USECONTACT"
 * "削除連絡"機能を使う場合にtrueを設定します
 *
 *-----------------------
 * "MAILTOCONTACT"
 * 削除連絡を受けた時にメール送信を行う場合
 * 送信先メールアドレスを指定します
 * 設置鯖をメール鯖として利用できる場合のみ
 * メール送付できます
 *
 *-----------------------
 * "AUTOBOARDNAME"
 * trueの場合ふたばスレッド取得時に
 * 取得元の板の名前を自動でタグ付けします
 *
 *-----------------------
 * "USESEARCHSV"
 * 全レス検索を利用する場合true
 * 現在はsqlite3のみに依存しています
 * USEFTSDB も参照
 *
 *-----------------------
 * "USEFTSDB"
 * このフラグを有効にすると
 * 保有スレ数が多くても高速に全レス検索が出来ます
 * ただし検索DBのサイズが４倍程度に増えるため
 * 保有スレが3000件以下の場合は利用しないことをオススメします
 *
 *-----------------------
 * "BAYESIANTAG"
 * 親レスの内容から自動的にカテゴリ推定を行い
 * タグ入力の補助に使います
 * この動作にはSqlite3+PHP5が必要です
 *
 *-----------------------
 * "USEIMGFINDER"
 * 類似画像検索と連携を取る場合true
 *
 *-----------------------
 * "INTERNALURL"
 * 内部アクセス時のバケットの設置URLの指定
 * 類似画像検索との連携で利用する
 *
 *-----------------------
 * "MANUALUPDATE"
 * ユーザーによる手動更新を有効にする場合true
 * 自動更新を利用する場合は無効にしておくと
 * 更新頻度を一定に抑えることができる
 *
 *-----------------------
 * "STOCKLIST"
 * 自分が保存したスレッドのみ一覧する機能を使う場合true
 *
 *-----------------------
 * "WITHFILE"
 * img用で添付ありスレッドの絞込を追加
 * 2file以上の物を表示対象とする
 *
 *-----------------------
 * "FIRSTUSERDEL"
 * 初回登録者がログを消せるようにする場合true
 *
 *-----------------------
 * "USEFILEHASHING"
 * 画像の重複排除と画像被り検索を行う場合にtrue
 * sqlite3が必要でwindowsでは重複排除機能は動作しません
 *
 *-----------------------
 * "CONTDIRREADONLY"
 * ログ格納フォルダ(cont/)を読み込み専用にする
 * REBUILDLOG = falseの設定とセットで
 * 同一鯖でログ共有する時などに使うと良い
 *
**/
$APPCONST = array(
  "TITLE"   => "FTBucket",
  "CONTDIR" => $ROOTDIR . "cont/",
  "METADIR" => $ROOTDIR . "meta/",
  "ZIPDIR"  => $ROOTDIR . "zip/",
  "LOCKDIR" => $ROOTDIR . "lock/",
  "CONTURL" => "cont/",
  "ZIPURL"  => "zip/",
  "THUMB"   => true,                                     //一覧にサムネイルを表示する場合true
  "USEZIP"  => true,                                     //zipダウンロードさせる場合true
  "URLREGX" => "/^http:\/\/...\.2chan\.net\/(.*)\/res/i",//ダウンロード対象url（正規表現)
  "RMPASSWD" => md5("passwd"),                           //共通削除パスワードのmd5値(変更必須)
  "LIFETIME" => 0,                                       //cronで削除する場合のログの生存秒数(0で無視)
  "PAGECAP"  => 20,                                      //1ページに表示するスレッド数(0で無制限)
  "LIMITCAP" => 2000,                                    //保存するスレッドの上限(0で無制限)
  "RMADLINK" => true,                                    //ふたばの広告を削除する場合true
  "COOLTIME" => 10,                                      //連続した更新を無効にする秒数
  "SIO_LOCK" => $ROOTDIR . "lock/SIO_GET.lock",          //塩辛瓶の取得ウェイト用のロックパス名
  "LIFETIME_TYPE" => 0,                                  //生存秒数の基準
  "IMGDIR_SYNC" => true,                                 //スレッドで削除済みの画像をキャッシュから消す場合true
  "USELIGHTBOX" => false,                                //画像表示にlightboxを使う場合true
  "REMOTEROOT" => "",                                    //キャッシュ用(更新あり)の親バケットURLを指定
  "SUBSCRIBES" => array(),                               //保険用(読み取り専用)の親バケットURLリストを指定
  "REBUILDLOG" => true,                                  //他バケットから取り込んだログを再変換する場合true
  "ZIPONTHEFLY" => false,                                //zip/mhtファイルをオンザフライ生成にする場合true
  "USECONTACT" => false,                                 //"連絡"機能を表示する場合true
  "MAILTOCONTACT" => "",                                 //"連絡"機能の送信先メールアドレス
  "AUTOBOARDNAME" => false,                              //自動で"板名"のタグを付ける場合true
  "USESEARCHSV" => false,                                //全レス検索を利用する場合true
  "USEFTSDB" => false,                                   //全レス検索にfts3拡張を利用する場合true
  "BAYESIANTAG" => false,                                //自動カテゴリ推定を利用する場合true
  "USEIMGFINDER" => false,                               //ローカル画像検索を有効にする場合true
  "INTERNALURL" => "",                                   //画像検索内部アクセス時のバケットのURL
  "MANUALUPDATE" => true,                                //scrapshot.phpで手動更新する場合true
  "STOCKLIST" => false,                                  //ストック一覧を利用する場合true
  "WITHFILE" => false,                                   //img用で添付ありスレッドの絞込を追加
  "WITHFILE_THRESHOLD" => 2,                             //  しきい値とするファイル数
  "WITHFILE_MSG" => "添付あり",                          //  選択肢で表示する文言
  "FIRSTUSERDEL" => true,                                //初回登録者がログを消せるようにする場合true
  "USEFILEHASHING" => false,                             //画像の重複排除と画像被り検索の有効化
  "CONTDIRREADONLY" => false,                            //CONTディレクトリを読み込み専用にする
  "VIEWORDER" => false,                                  //表示順を再ソートする場合true
  "USESIGNATURE" => false,                               //署名機能を利用する場合true
);

function readConfig($key,$default=FALSE)
{
  global $APPCONST;
  if(array_key_exists($key,$APPCONST)){
    return $APPCONST[$key];
  }else{
    return $default;
  }
}


//------------------------------------------------------
//initial function

#ini_set( 'display_errors', 1 );

function getEncoding(){
  return "SJIS";  //ふたばのhtmlのエンコードを指定
}

mb_language("ja");
mb_internal_encoding("UTF8");
mb_regex_encoding( "UTF8" );

if (function_exists('date_default_timezone_set')) {
  date_default_timezone_set('Asia/Tokyo');
}

//タイムアウト設定
set_time_limit(600);

//ユーザー切断による強制終了を無効化
ignore_user_abort(1);

//エラー出力を行う
ini_set( 'display_errors', 1 );

//PHP5.4以降のエラーを非表示にする
//ini_set('error_reporting', E_ALL & ~E_DEPRECATED);

//------------------------------------------------------
//common function

function get_current_uri(){
    return "http://".$_SERVER["HTTP_HOST"].$_SERVER["SCRIPT_NAME"];
}

function get_current_uri_dir() {
    global $ROOTURL;
    if($ROOTURL != "") {
      return $ROOTURL;
    }
    if(isset($_SERVER["HTTP_X_FORWARDED_HOST"]) && $_SERVER["HTTP_X_FORWARDED_HOST"] != "") {
      return "http://".$_SERVER["HTTP_X_FORWARDED_HOST"].dirname($_SERVER["SCRIPT_NAME"])."/";
    }
    return "http://".$_SERVER["HTTP_HOST"].dirname($_SERVER["SCRIPT_NAME"])."/";
}

/**
 * url情報をローカルのファイル名に変換する
 * 数カ所で逆変換もかけているため変更不可
**/
function saniPath($basename) {
  return str_replace(".htm","",str_replace("/","_",$basename));
}

function saniCookie($basename) {
  return str_replace(".htm","",str_replace(".","_",str_replace("/","_",$basename)));
}

function metaFileSfx() {
  return ".info";
}

function urlToBasename($url) {

  //URLから各種関連情報を抽出
  $basename = substr($url, 7);

  $result = array(
    "CONT" => saniPath($basename) . "/",
    "ZIP"  => saniPath($basename) . ".zip",
    "MHT"  => saniPath($basename) . ".mht",
    "LOCK" => saniPath($basename) . ".lock",
    "META" => saniPath($basename) . metaFileSfx()
  );

  return $result;
}

} //if(!defined ( 'CONFIG_PHP_INC_' ))
