<?php

include_once 'config.php';
include_once 'phplib/common.php';
include_once 'phplib/crawl.php';

//contディレクトリ配下のデータを使い
//メタデータを再構築する

//read metafile
$dba = makeDBA("w");
$allKeys = $dba->allKeys();

//remove
foreach($allKeys as $key) {
  echo "exkey $key \n";

  $info = $dba->get($key);
  $basenames = urlToBasename($info["url"]);
  $idxdir  = readConfig("CONTDIR") . $basenames["CONT"];
  $idxpath = $idxdir . _PGET_INDEX_PAGE_;
  
  if(!is_dir($idxdir) || !is_file($idxpath) ){
    $dba->del($key);
  }
}

function _recovery_info($key)
{
  //metaデータの復元(再作成)を試みる
  if(!function_exists("makeMetaInfo")){echo "notexists makeMetaInfo"; return false;}

  //index.htmを読む
  $basenames = urlToBasename($key);
  $indexpath = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_INDEX_PAGE_;

  $info = false;

  $html = "";
  
  if( is_file($indexpath) )
  {
    $html = @file_get_contents($indexpath);
  }
  //infoをhtmlから再作成
  if( strlen($html) > 0){
    log2file("DBA_Flatfile.php restoration log:".__LINE__.":". $key );
    $srcHtml = mb_convert_encoding($html, "UTF8", getEncoding());
    $info = makeMetaInfo($key, $srcHtml);
  }else{
    echo "htmlerr \n";
  }

  return $info;
}


//add
$rootdir = readConfig("CONTDIR");
if($handle  = opendir($rootdir))
{
  while (false !== ($fbase = readdir($handle))) {
    $path =$rootdir .  $fbase;
    if($fbase != '.' && $fbase != '..' && is_dir($path)) {
      $url = "http://". str_replace("_","/",$fbase.".htm");
      echo $url . "\n";
      if(!$dba->exists($url)){
        if($info = _recovery_info($url)){
          echo "success\n";
          $dba->set($url, meta_verifyInfo($info));
        }else{
          echo "fail\n";
        }
      }
    }
  }
}

//save meta
$dba->close();




//キャッシュ更新
removeJsonApiCache();
readAllInfoCached();

//-----------------------------------------
//meta フォルダの最適化
meta_optimize();

