<?php
//-----------------------------------------------------
//互換wgetモジュール

require_once (dirname(__FILE__) . '/../../config.php');
require_once dirname(__FILE__) . '/../const.php';
require_once dirname(__FILE__) . '/../fsutil.php';
require_once 'httprequest.php';


if (!defined('PHP_VERSION_ID')) {
    $version = explode('.', PHP_VERSION);

    define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
}

/* ふたば専用のwgetの代替モジュール
 * urlで指定されたスレッドを解析し、
 * サムネイル画像、リンク先画像を取得し
 * それぞれ作成したフォルダに保存します。
 * アドレスの書き換え等も行います。
 *
**/

//-----------------------------------------------------------

function useLightBox() {
  return readConfig("USELIGHTBOX");
}

function isImageFileExt($fname) {
  $info = pathinfo($fname);
  return array_key_exists('extension',$info)
        && in_array(strtolower($info['extension']),
                  array('jpg','jpeg','gif','png') );
}

if (!function_exists('dir_copy')) {
function dir_copy($dir_name, $new_dir)
{
  if (!is_dir($new_dir)) {
    mkdir($new_dir);
  }

  if (is_dir($dir_name)) {
    if ($dh = opendir($dir_name)) {
      while (($file = readdir($dh)) !== false) {
        if ($file == "." || $file == "..") {
          continue;
        }
        if (is_dir($dir_name . "/" . $file)) {
          dir_copy($dir_name . "/" . $file, $new_dir . "/" . $file);
        }
        else {
          copy($dir_name . "/" . $file, $new_dir . "/" . $file);
        }
      }
      closedir($dh);
    }
  }
  return true;
}}

//-----------------------------------------------------------

//(元html,対象タグ,変換関数,変換関数パラメータ) -> 変換後html,[変換関数の戻り値]
function pgetParseHtml($srcHtml,$tag,$converter,$convparam,$url) {
  $curHtml = $srcHtml;
  $tagPairs = array();
  $convHtml = "";
  while(true){

    $pos = strpos($curHtml, "<" . $tag);
    if($pos !== false){
      $preHtml  = substr( $curHtml , 0, $pos);

      $tagclose = strpos($curHtml, ">", $pos + strlen($tag)+1);
      $target   = substr($curHtml, $pos, $tagclose - $pos + 1);
      $restHtml = substr($curHtml, $tagclose + 1 );

      $converted = $target;
      if( $ret = call_user_func($converter, $target, $convparam, $url) ) {
        //変換成功
        $converted = $ret[0];
        array_push($tagPairs, $ret);
      }
      $convHtml = $convHtml . $preHtml . $converted;
      $curHtml = $restHtml;

    }else{
      $convHtml = $convHtml . $curHtml;
      break;
    }

  }

  return array($convHtml, $tagPairs);
}

function cnvNone($src,$convparam) {
  return array("");
}

//サムネの抜き出しとURL書き換えを行う
function cnvThumb($src,$convparam,$url) {
  // 避難所用
  $reg = "/(.*)src=[\"\'](\/.*\/thumb\/[^\"^\']*)[\"\'](.*)/i";
  $matches = array();
  if(preg_match($reg, $src, $matches) == 1){
    $fname = str_replace("/","_",$matches[2]);
    $mc = array();
    if(preg_match("/([^\/]+)$/i", $matches[2], $mc) == 1) {
      $fname = $mc[1];
    }
    $host = "www.2chan.net";
    if(preg_match("/https?:\/\/([^\/]+).*/", $url, $hm) == 1){
      $host = $hm[1];
    }
    return array($matches[1] . "src=\"" . $convparam . $fname . "\"" . $matches[3]
                 ,$src,
                 $host."/".$matches[2],
                 $convparam . $fname );
  }
  // 通常のふたば用
  $reg = "/(.*)src=[\"\']http:\/\/(.*\.2chan.net\/.*\/thumb\/[^\"^\']*)[\"\'](.*)/i";
  $matches = array();
  if(preg_match($reg, $src, $matches) == 1){
    $fname = str_replace("/","_",$matches[2]);
    $mc = array();
    if(preg_match("/([^\/]+)$/i", $matches[2], $mc) == 1) {
      $fname = $mc[1];
    }
    return array($matches[1] . "src=\"" . $convparam . $fname . "\"" . $matches[3]
                 ,$src,
                 $matches[2],
                 $convparam . $fname );
  }
  return false;
}

//リンク先画像のURL書き換えを行う
function cnvLink($src,$convparam,$url) {
  // 避難所用
  $reg = "/(.*)href=[\"\'](\/.*\/src\/[^\"^\']*)[\"\'](.*)/i";
  $matches = array();
  if(preg_match($reg, $src, $matches) == 1){
    $fname = str_replace("/","_",$matches[2]);
    $mc = array();
    if(preg_match("/([^\/]+)$/i", $matches[2], $mc) == 1) {
      $fname = $mc[1];
    }
    $lbparam = "";
    if(useLightBox() && isImageFileExt($fname)) {
      $lbparam = ' rel="lightbox"';
    }
    $host = "www.2chan.net";
    if(preg_match("/https?:\/\/([^\/]+).*/", $url, $hm) == 1){
      $host = $hm[1];
    }
    return array($matches[1] . "href=\"" . $convparam . $fname . "\"" . $lbparam . $matches[3]
                 ,$src,
                 $host."/".$matches[2],
                 $convparam . $fname );
  }
  // 通常のふたば用
  $reg = "/(.*)href=[\"\']http:\/\/(.*\.2chan.net\/.*\/src\/[^\"^\']*)[\"\'](.*)/i";
  $matches = array();
  if(preg_match($reg, $src, $matches) == 1){
    $fname = str_replace("/","_",$matches[2]);
    $mc = array();
    if(preg_match("/([^\/]+)$/i", $matches[2], $mc) == 1) {
      $fname = $mc[1];
    }

    $lbparam = "";
    if(useLightBox() && isImageFileExt($fname)) {
      $lbparam = ' rel="lightbox"';
    }

    return array($matches[1] . "href=\"" . $convparam . $fname . "\"" . $lbparam . $matches[3]
                 ,$src,
                 $matches[2],
                 $convparam . $fname );
  }
  return false;
}

//----------------------------------------------------------------

/*
 *指定タグの削除
**/
function pgetRmTag($srcHtml,$tag,$multi) {
  $curHtml = $srcHtml;
  $tagPairs = array();
  $convHtml = "";
  do{

    $pos = strpos($curHtml, "<" . $tag);
    if($pos !== false){
      $preHtml  = substr( $curHtml , 0, $pos);
      $closetag =  "</" . $tag . ">";

      $posEnd = strpos($curHtml, $closetag, $pos + strlen($tag)+1);
      $restHtml = substr($curHtml, $posEnd + strlen($closetag));

      $convHtml = $convHtml . $preHtml ;
      if($multi) {
        $curHtml = $restHtml;
      }else{
        $convHtml =  $convHtml . $restHtml;
      }

    }else{
      $convHtml = $convHtml . $curHtml;
      break;
    }
  }while($multi);

  return $convHtml;
}

//----------------------------------------------------------------


//ダウンロード状況通知コールバックのデフォルト値
function pgetDmyGetImageList ($urls)
{
}
function pgetDmyGetImage($url,$success)
{
}

//外部板の設定取得リスト
function pgetOuterBoardsConst($imageDir)
{
  /**
   * (マッチさせる正規表現
   *  ダウンロード関数名( (パラメータ,経過取得関数,マッチテキスト)->変換後テキスト )
   *  パラメータ)
   *
   *  経過関数にはマッチテキストそのものを利用する(urlではない)
  */
  return array(//うｐ
               array("(f[0-9]{4,}(\.[_a-zA-Z0-9]+)?)",
                     "pgetUpBoardReader",
                     array("http://dec.2chan.net/up/",$imageDir)),
               //うｐ小
               array("(fu[0-9]{4,}(\.[_a-zA-Z0-9]+)?)",
                     "pgetUpBoardReader",
                     array("http://dec.2chan.net/up2/",$imageDir)),
               //塩つぶ
               array("(su[0-9]{4,}(\.[_a-zA-Z0-9]+)?)",
                     "pgetSioBoardReader",
                     array("http://www.nijibox5.com/futabafiles/tubu/",$imageDir)),
               //塩こびん
               array("(ss[0-9]{4,}(\.[_a-zA-Z0-9]+)?)",
                     "pgetSioBoardReader",
                     array("http://www.nijibox5.com/futabafiles/kobin/",$imageDir)),
               //塩空瓶
               array("(sa[0-9]{4,}(\.[_a-zA-Z0-9]+)?)",
                     "pgetSioBoardReader",
                     array("http://www.nijibox6.com/futabafiles/001/",$imageDir)),
               //塩3ml
               array("(sp[0-9]{4,}(\.[_a-zA-Z0-9]+)?)",
                     "pgetSioBoardReader",
                     array("http://www.nijibox2.com/futabafiles/003/",$imageDir))
               );
}
//リンク変換のみの場合
function pgetUrlConverterConst($imageDir)
{
  return array(//url
               array("((h?t?t?p?s?):\/\/([\!#$%&|\'\(\)\*\+,\-\.\/0-9:;=\?@[\]A-Z\\_a-z~]*|[\!#$%&|\'\(\)\*\+,\-\.\/0-9:;=\?@[\]A-Z\\_a-z~]+))",
                     "pgetUrlLinker",
                     array("",$imageDir)),
               //塩中瓶
               array("(sq[0-9]{4,}(\.[_a-zA-Z0-9]+)?)",
                     "pgetSioBoardLinker",
                     array("http://www.nijibox6.com/futabafiles/mid/",$imageDir)),
               );
}


//-----------------------------------------------------

//取得リソースリスト
$pget_resouce= array();

//うｐ,うｐ小の画像取得関数
function pgetUpBoardReader($param,$callback,$match)
{
  global $pget_resouce;
  $baseUrl   = $param[0];
  $fname     = $match;
  $getUrl    = $baseUrl . "src/" . $fname;
  $storePath = $param[1] . _PGET_OTHER_DIR_  . $fname;

  $success = true;
  //ダウンロードの実行
  if( !file_exists($storePath) ) {
    $image_bin = safe_file_get_contents($getUrl);
    if( $image_bin ) {
      file_put_contents($storePath, $image_bin);
    }else{
      $success = false;
    }
  }

  //経過関数にコールバック
  call_user_func($callback,$match,$success);

  //テキストの置換
  $result = "";
  if($success) {
    $lbparam = "";
    if(useLightBox() && isImageFileExt($fname)) {
      $lbparam = ' rel="lightbox"';
    }
    $pget_resouce[ _PGET_OTHER_DIR_  . $fname ] = $getUrl; //リソース名を記録

    $result = '<a target=_blank href="'._PGET_OTHER_DIR_ . $fname . '"' . $lbparam . '>' . $fname . '</a>' . generatePrevImg(_PGET_OTHER_DIR_ . $fname);
  }else{
    $result = $fname . '	[<a target=_blank href="' . $baseUrl . 'up.htm">link</a>]';
  }
  return $result;
}

//塩辛瓶(塩粒,空瓶,小瓶,3mlの取得)
function pgetSioBoardReader($param,$callback,$match)
{
  global $pget_resouce;
  $boardUrl  = $param[0];
  $baseUrl   = $param[0] . "src/";
  $fname     = $match;
  $refUrl    = $baseUrl . $fname . ".html";
  $getUrl    = $baseUrl . $fname;
  $storePath = $param[1] . _PGET_OTHER_DIR_ . $fname;

  $success = true;
  $geted = false;

  //拡張子無しのurlの場合
  //urlを参照しにいき拡張子を取得しなおす
  if(!preg_match("/[^\.]+\..+/", $fname)){
    $linkpage = safe_file_get_contents($getUrl);

    $mc = array();
    if(preg_match("/" . $fname . "(\.[_a-zA-Z0-9]+)/", $linkpage , $mc) ){
      $fname .= $mc[1];  //マッチした拡張子を追加
      $refUrl = $getUrl; //リファラをリンクページurlに修正
      $getUrl = $baseUrl . $fname;
      $storePath = $param[1] . _PGET_OTHER_DIR_ . $fname;
      $geted = true;
    }else{
      $success = false;
    }
  }

  //ダウンロードの実行
  if($success && !file_exists($storePath) ) {
    $geted = true;

    //塩辛のIP BAN回避のsleep
    $lockpath = readConfig("SIO_LOCK");
    if($lock = fopen($lockpath, "w")){
      if(flock($lock, LOCK_EX)){
        sleep(1);
        flock($lock, LOCK_UN);
      }
      fclose($lock);
    }

    //実際の画像取得
    $image_bin = safe_file_get_contents($getUrl, $refUrl);

    if( $image_bin ) {
      file_put_contents($storePath, $image_bin);

    }else{
      $success = false;
    }
  }

  //経過関数にコールバック
  call_user_func($callback,$match,$success);


  //テキストの置換
  $result = "";
  if($success) {
    $lbparam = "";
    if(useLightBox() && isImageFileExt($fname)) {
      $lbparam = ' rel="lightbox"';
    }
    $pget_resouce[ _PGET_OTHER_DIR_  . $fname ] = $getUrl; //リソース名のストア

    $result =  '<a target=_blank href="'._PGET_OTHER_DIR_ . $fname . '"' . $lbparam . '>' . $fname . '</a>' . generatePrevImg(_PGET_OTHER_DIR_ . $fname);
  }else{
    $result = $fname . '	[<a target=_blank href="' . $boardUrl . '">link</a>]';
  }
  return $result;
}

//塩辛(中瓶)のオートリンク
function pgetSioBoardLinker($param,$callback,$match)
{
  $boardUrl  = $param[0];
  $baseUrl   = $param[0] . "src/";
  $fname     = $match;
  $refUrl    = $baseUrl . preg_replace("/(.+)(\.[^.]+$)/", "$1", $fname);
  return $match . '	[<a target=_blank href="' . $refUrl . '">link</a>]';;
}

//URLオートリンク
function pgetUrlLinker($param,$callback,$match)
{
  global $pget_resouce;
  $url = $match;
  $regex = "/((h?t?t?p?s?):\/\/([\!#$%&|\'\(\)\*\+,\-\.\/0-9:;=\?@[\]A-Z\\_a-z~]*|[\!#$%&|\'\(\)\*\+,\-\.\/0-9:;=\?@[\]A-Z\\_a-z~]+))/";
  $m = array();
  $protocol = "";
  if(preg_match($regex, $url, $m)){
    $protocol = "https://";
    if(strpos($m[2],"s") === FALSE){
      $protocol = "http://";
    }
    $url = $protocol . $m[3];
  }

  $fname = str_replace("/","_", substr($url, strlen($protocol)));
  $storePath = $param[1] . _PGET_OTHER_DIR_ . $fname;
  $success = false;

  if(isImageFileExt($fname)) {
    //画像ファイルの場合回収に向かう

    $success = true;
    //ダウンロードの実行
    if( !file_exists($storePath) ) {

      $image_bin = safe_file_get_contents($url);
      if( $image_bin ) {

        file_put_contents($storePath, $image_bin);
      }else{
        $success = false;
      }
    }
  }

  if($success) {
    $lbparam = "";
    if(useLightBox() && isImageFileExt($fname)) {
      $lbparam = ' rel="lightbox"';
    }
    $pget_resouce[ _PGET_OTHER_DIR_  . $fname ] = $url; //リソース名のストア

    return '<a target=_blank href="' . _PGET_OTHER_DIR_ . $fname . '"' . $lbparam . '>' . $match . '</a>' . generatePrevImg(_PGET_OTHER_DIR_ . $fname);
  }else{
    return $match . '	[<a target=_blank href="' . $url . '">link</a>]';;
  }
}

//----------------
//html中の外部板ファイルのurlリスト取得
function pgetListupOuterBoardsUrls($html,$matchers)
{
  $offset = strpos("<body",$html);
  if($offset === FALSE){ $start = 0; }

  $result = array();
  foreach($matchers as $matcher)
  {
    $regex = "/>[^<]*?" . $matcher[0] . "/";
    $matches = array();
    if(preg_match_all($regex, $html, $matches, PREG_OFFSET_CAPTURE, $offset)){
      foreach($matches[1] as $match) {
        $result[] = $match;
      }
    }
  }
  return $result;
}

function pgetCar($var)
{
  return $var[0];
}

function pgetCdr($var)
{
  return $var[1];
}

//----------------------------
//塩辛等の添付画像の [見る] の生成
function generatePrevImg($imgUrl)
{
  if(isImageFileExt($imgUrl)) {
    $tagid = md5( uniqid( mt_rand() , true ) );
    return '<span id="' . $tagid . '" style="cursor:pointer;" onClick="previewImg(' . "'" .  $tagid . "','" . $imgUrl . "'" . ')">[見る]</span>';
  }else{
    return '';
  }
}

//----------------------------
//url置換関数

function pgetConvertLinkHelper($baseHtml, $outerMatches, $outerMatchers, $getImageFn)
{
  //外部板画像取得
  $convHtml = "";
  $convPtr = 0;
  foreach($outerMatches as $match) {
    $wordLen = strlen($match[0]);

    //マッチ文字より前方のhtmlを確定
    $convHtml .= substr($baseHtml, $convPtr, $match[1] - $convPtr);
    $convPtr = $match[1] + $wordLen;
    $convTag = $match[0];
    //ダウンロード関数を検索
    foreach($outerMatchers as $matcher) {
      $regex = "/^" . $matcher[0] . "$/";
      if(preg_match($regex, $match[0])) {
        //ダウンロード実行
        $convTag = call_user_func($matcher[1],$matcher[2],$getImageFn,$match[0]);
        $convHtml .= $convTag;
        break;
      }
    }
  }
  //残りのhtmlを確定
  $convHtml .= substr($baseHtml, $convPtr);

  return $convHtml;
}


//----------------------------------------------------------------

/**
 *　取得元URLを元に関連情報を格納先ディレクトリに書き出す
 * 格納先ディレクトリに対象ファイルがあった場合はダウンロードを無視する
 *
 * 戻り値 失敗時false 成功時 HTMLテキスト(utf8)
**/
function cust_pget($url,$storeDir,
                   $getImageListFn = 'pgetDmyGetImageList',
                   $getImageFn = 'pgetDmyGetImage',
                   $convertOnly = false)
{
  global $pget_resouce;
  $resultHtml = "";

  if(readConfig("CONTDIRREADONLY")){
    return false;
  }
  
  //その他の格納フォルダ(other/)の作成
  if(!file_exists($storeDir . _PGET_OTHER_DIR_)) {
    mkdir($storeDir . _PGET_OTHER_DIR_);
  }

  //変換元HTMLの取得と保存
  $srcHtml = "";
  if( $convertOnly ) {
    $gzPath = $storeDir . (_PGET_OTHER_DIR_._PGET_INDEX_PAGE_SRCGZ_);
    //gzファイルを親バケットから取得する場合の再変換をかける
    //htmlは取得せずgzファイルから再変換する
    if(readConfig("REBUILDLOG") && is_file( $gzPath ) && $zp = gzopen($gzPath,"r"))
    {
      while(!gzeof($zp)){
        $srcHtml .= gzread($zp, 5000000);
      }
      gzclose($zp);
    }else{
      return false;
    }
  }else{
    //ふたばからスレッドのHTML取得
    $srcHtml = safe_file_get_contents($url);
    if(! $srcHtml ){
      return false;
    }
    //元htmlをgz保存
    $srcHtmlGz = gzencode($srcHtml,1);
    file_put_contents($storeDir . (_PGET_OTHER_DIR_._PGET_INDEX_PAGE_SRCGZ_), $srcHtmlGz);
  }

  $convResults = array();

  //utf8変換
  $srcHtml = mb_convert_encoding($srcHtml, "UTF8", getEncoding());


  //スレッドのダウンロード情報
  //ダウンロードの前回情報を保持るために利用
  $getinfoPath = $storeDir . _PGET_OTHER_DIR_ . _PGET_CRAWL_INFO_;
  $getinfo = array(
    "catalogNone" => false,//カタログが無い場合true
    "imgsrc" => array(),   //画像ファイル名 -> 元urlの連想配列
  );
  if( is_file( $getinfoPath ) ){
    $getinfo = json_decode( file_get_contents($getinfoPath), true);
    $pget_resouce = $getinfo["imgsrc"];
  }

  //base href除去
  $result = pgetParseHtml($srcHtml, 'base', 'cnvNone', "", $url);
  $convHtml = $result[0];

  //aタグの置換
  $result = pgetParseHtml($convHtml, 'a', 'cnvLink', _PGET_IMG_DIR_, $url);
  $convHtml = $result[0];
  $convResults =array_merge ( $convResults,$result[1]);

  //imgタグの置換
  $result = pgetParseHtml($convHtml, 'img', 'cnvThumb', _PGET_THUMB_DIR_, $url);
  $convHtml = $result[0];
  $convResults =array_merge ( $convResults,$result[1]);

  // /bin直下の参照を削除
  $convHtml = preg_replace("/<[^>]*\/bin[^>]*>/i"," ", $convHtml);

  $resultHtml = $convHtml;

  //返信フォーム削除
  $convHtml = pgetRmTag($convHtml, 'form', false);

  //script文の削除
  $convHtml = pgetRmTag($convHtml, 'script', true);

  //[ホーム] のリンク削除
  $convHtml = preg_replace('/\[<a href="\.\.\/"[^>]+>([^<]+)<\/a>\]/i',' ', $convHtml);

  //[掲示板に戻る] のリンク削除
  $convHtml = preg_replace('/\[<a href="futaba.htm">[^<]*<\/a>\]/i',' ', $convHtml);

  //広告の削除
  if( readConfig("RMADLINK") )
  {
    $convHtml = preg_replace(
      "/<div class=[\"\']thre[\"\']/",
      '<span class="thre"',$convHtml);
    
    $convHtml = pgetRmTag($convHtml, 'div', true);
    $result   = pgetParseHtml($convHtml, '/div', 'cnvNone', "", $url);
    $convHtml = $result[0];
    
    $convHtml = pgetRmTag($convHtml, 'iframe', true);
  }
  
  //mailtoの展開
  $convHtml = preg_replace(
    "/<a href=[\"\']mailto:([^\"^\']*)[\"\']>([^<]*)<\/a>/",
    "$2 <font color=green>$1</font>",$convHtml);
  
  //画像一覧を通知
  $imageUrls = array();
  foreach($convResults as $ret){
    $url = "http://" . $ret[2];
    $imageUrls[] = $url;
  }

  //----------------------------------------------------------
  //リンク変換
  $outerMatchers = pgetUrlConverterConst($storeDir);
  $outerMatches = pgetListupOuterBoardsUrls($convHtml,$outerMatchers);
  $outerFiles   = array_map("pgetCar", $outerMatches);
  $outerPos     = array_map("pgetCdr", $outerMatches);
  //出現位置順にソート
  array_multisort($outerPos, SORT_ASC, $outerMatches);
  $convHtml = pgetConvertLinkHelper($convHtml, $outerMatches, $outerMatchers, $getImageFn);

  //----------------------------------------------------------
  //外部板の画像一覧の取得
  $outerMatchers = pgetOuterBoardsConst($storeDir );
  $outerMatches = pgetListupOuterBoardsUrls($convHtml,$outerMatchers);
  $outerFiles   = array_map("pgetCar", $outerMatches);
  $outerPos     = array_map("pgetCdr", $outerMatches);
  //出現位置順にソート
  array_multisort($outerPos, SORT_ASC, $outerMatches);

  //関連ファイル一覧の通知
  call_user_func($getImageListFn,array_merge($imageUrls,$outerFiles));

  //画像フォルダの作成
  if(!file_exists($storeDir . _PGET_THUMB_DIR_)){
    mkdir($storeDir . _PGET_THUMB_DIR_);
  }
  if(!file_exists($storeDir . _PGET_IMG_DIR_)){
    mkdir($storeDir . _PGET_IMG_DIR_);
  }

  //カタログ名
  $catPath = $storeDir . _PGET_CATALOG_;
  $enableCat = is_file($catPath);

  //画像取得
  foreach($convResults as $ret){
    $url  = "http://" . $ret[2];
    $path = $storeDir . $ret[3];
    $success = false;
    if(!file_exists($path)){
      //サムネか本体画像の取得
      $image_bin = safe_file_get_contents($url);
      if($image_bin) {
        file_put_contents($path,$image_bin);
        $success = true;
        $pget_resouce[$ret[3]] = $url;//画像ファイルのurl情報更新
      }
      //カタログ画像の取得
      if( !$getinfo['catalogNone'] && !$enableCat && strpos($url, "thumb/") !==FALSE ){
        $catUrl = str_replace("thumb/", "cat/", $url);
        if($catBin = safe_file_get_contents($catUrl)) {
          file_put_contents($catPath,$catBin);
          $enableCat = true;
          $pget_resouce[_PGET_CATALOG_] = $catUrl;//カタログのurl更新
        }
      }

    }

    call_user_func($getImageFn,$url,$success);
  }
  if(!$getinfo['catalogNone'] && !$enableCat){
    $getinfo['catalogNone'] = true;
  }


  //外部板画像取得
  $convHtml = pgetConvertLinkHelper($convHtml, $outerMatches, $outerMatchers, $getImageFn);

  //lightbox変換
  if(useLightBox()) {
    //headerにタグを挿入
    $lbtags  = '<link rel="stylesheet" type="text/css" href="resource/lightbox.css" media="screen,tv" />'."\r\n";
    $lbtags .= '<script type="text/javascript" charset="UTF-8" src="resource/lightbox_plus_min.js"></script>'."\r\n";
    $lbtags .= '</head>';
    $convHtml = str_replace('</head>', $lbtags, $convHtml);

    //lightboxのリソースをコピー
    $srcdir = dirname(__FILE__) . '/lbx';
    $dstdir = $storeDir . '/resource';
    if(!is_dir($dstdir)){
      dir_copy($srcdir,$dstdir);
    }
  }

  //削除されたコメントの表示非表示するためのjavascript挿入
  $scriptline  = file_get_contents(dirname(__FILE__) . "/header.txt");
  $scriptline .= "<script src='../../phplib/contextmenu.js'></script>\n";
  $scriptline .= '</head>';
  $convHtml = str_replace('</head>', $scriptline, $convHtml);

  $footer  = file_get_contents(dirname(__FILE__) . "/footer.txt");
  $footer.= "</body>";
  $convHtml = str_replace('</body>', $footer, $convHtml);

  //その他ファイル一覧を書き出し
  if( file_exists($storeDir . _PGET_OTHER_DIR_) ) {
    $filesline = "";
    $exists = false;

    foreach(find_files( $storeDir . _PGET_OTHER_DIR_ ) as $path) {
      $fname = basename( $path );
      if(!in_array( $fname, array(_PGET_INDEX_PAGE_SRCGZ_,_PGET_CRAWL_INFO_,_PGET_CATALOG_))){
        $exists = true;
        $lbparam = "";
        if(useLightBox() && isImageFileExt($fname)) {
          $lbparam = ' rel="lightbox"';
        }
        $filesline .= '<a target=_blank href="'._PGET_OTHER_DIR_ . $fname . '"' . $lbparam . '>' . $fname . '</a>' . generatePrevImg('other/' . $fname).'<br>';
      }
    }
    if($exists){
      $convHtml = str_replace('</form>', '</form><span><div>'.$filesline."</div></span><hr>", $convHtml);
    }
  }

  //sjis変換
  $convHtml = mb_convert_encoding($convHtml, getEncoding(), "UTF8");

  //htmlファイルの書き出し
  file_put_contents($storeDir . _PGET_INDEX_PAGE_, $convHtml);

  //スレッドのダウンロード情報の更新
  $getinfo['imgsrc'] = $pget_resouce;
  file_put_contents($getinfoPath, json_encode($getinfo));

  //----------------------------------------------------------
  //スレッドで削除済みの画像をキャッシュから消す

  if( readConfig("IMGDIR_SYNC") ){

    //スレッド画像リストを取得 (img,thumbディレクトリ)
    $thImgs = array();
    foreach($convResults as $ret){
      $path = $storeDir . $ret[3];
      $thImgs[] = $path;
    }
    $thImgs  = array_unique ($thImgs);

    $thFiles = array_merge (
                 find_files($storeDir . preg_replace("/\/$/","",_PGET_IMG_DIR_) ),
                 find_files($storeDir . preg_replace("/\/$/","",_PGET_THUMB_DIR_) )
                 );

    $thDiff = array_diff ($thFiles, $thImgs);
    if( count($thDiff) > 0) {
      log2file(__FILE__.":".__LINE__." IMGDIR_SYNC ".print_r($thDiff,true));
    }

    foreach($thDiff as $path){
      unlink($path); //削除
    }

  }

  return $resultHtml;
}
