<?php

//--------------------------------------------------------------
//PHP4向けの各種エミュレーション関連

if(!function_exists('array_column')){
  function array_column( $array, $column_key, $index_key=null){
    $result = array();
    foreach($array as $arr){
      if(!is_array($arr)) continue;

      if(is_null($column_key)){
        $value = $arr;
      }else{
        $value = $arr[$column_key];
      }
      if(!is_null($index_key)){
        $key = $arr[$index_key];
        $result[$key] = $value;
      }else{
        $result[] = $value;
      }
    }

    return $result;
  }
}

if(!function_exists("json_encode")) {
  require_once("crawl/pear/Services_JSON.php");
  
  function json_encode($value) {
    $s = new Services_JSON();
    return $s->encode($value);
  }

  function json_decode($json, $assoc = false) {
    $s = new Services_JSON($assoc ? SERVICES_JSON_LOOSE_TYPE : 0);
    return $s->decode($json);
  }
}


if (!function_exists('file_put_contents')) {
    function file_put_contents($filename, $data) {
        $f = @fopen($filename, 'w');
        if (!$f) {
            return false;
        } else {
            $bytes = fwrite($f, $data);
            fclose($f);
            return $bytes;
        }
    }
}

if (!function_exists('ftb_get_headers')) {
function ftb_get_headers($Url, $Format= 0, $Depth= 0) {
    if ($Depth > 5) return;
    $Parts = parse_url($Url);
    if (!array_key_exists('path', $Parts))   $Parts['path'] = '/';
    if (!array_key_exists('port', $Parts))   $Parts['port'] = 80;
    if (!array_key_exists('scheme', $Parts)) $Parts['scheme'] = 'http';

    $Return = array();
    $fp = fsockopen($Parts['host'], $Parts['port'], $errno, $errstr, 3);
    if ($fp) {
        $Out = 'HEAD '.$Parts['path'].(isset($Parts['query']) ? '?'.@$Parts['query'] : '')." HTTP/1.1\r\n".
               'Host: '.$Parts['host'].($Parts['port'] != 80 ? ':'.$Parts['port'] : '')."\r\n".
               'User-Agent: ' . ini_get('user_agent')."\r\n".
               'Connection: Close'."\r\n";
        fwrite($fp, $Out."\r\n");
        $Redirect = false; $RedirectUrl = '';
        while (!feof($fp) && $InLine = fgets($fp, 1280)) {
            if ($InLine == "\r\n") break;
            $InLine = rtrim($InLine);

            list($Key, $Value) = explode(': ', $InLine, 2);
            if ($Key == $InLine) {
                if ($Format == 1)
                        $Return[$Depth] = $InLine;
                else    $Return[] = $InLine;

                if (strpos($InLine, 'Moved') > 0) $Redirect = true;
            } else {
                if ($Key == 'Location') $RedirectUrl = $Value;
                if ($Format == 1)
                        $Return[$Key] = $Value;
                else    $Return[] = $Key.': '.$Value;
            }
        }
        fclose($fp);
        if ($Redirect && !empty($RedirectUrl)) {
            $NewParts = parse_url($RedirectUrl);
            if (!array_key_exists('host', $NewParts))   $RedirectUrl = $Parts['host'].$RedirectUrl;
            if (!array_key_exists('scheme', $NewParts)) $RedirectUrl = $Parts['scheme'].'://'.$RedirectUrl;
            $RedirectHeaders = ftb_get_headers($RedirectUrl, $Format, $Depth+1);
            if ($RedirectHeaders) $Return = array_merge_recursive($Return, $RedirectHeaders);
        }
        return $Return;
    }
    return false;
}}

if(!function_exists("mkdir_r")) {
function mkdir_r($dirname)
{
    if (file_exists($dirname)) return false;
    if (strpos($dirname, '/') && !file_exists(dirname($dirname))) {
        if (mkdir_r(dirname($dirname)) === false) return false;
    }
    return mkdir($dirname);
}}


if(!function_exists("gzdecode")) {
function gzdecode($data)
{
   return gzinflate(substr($data,10,-8));
}}
