<?php

/**
 * ダウンロードページ
 *
 * GET
 *  rooturl 元のスレッドurl
 *  type    ファイル形式(zip/mht)
 *  dlname  ダウンロードファイル名
**/


require_once 'config.php';
require_once 'phplib/session.php';
init_session();

require_once 'phplib/common.php';
require_once 'phplib/archive/pzip.php';
require_once 'phplib/archive/mht.lib.php';
require_once 'phplib/shortly.php';
require_once 'phplib/result.php';
require_once 'blacklist.php';
require_once 'phplib/const.php';

require_once 'phplib/smarty/Smarty.class.php';

//----------------------------------
//query param

$GETURL=$_GET["rooturl"];

//meta 情報の読み取り
$meta = readUrlInfo($GETURL);

$zippath   = "";
$mhtpath   = "";
$zipnames = array();
$mhtnames = array();

//meta情報がある場合にファイル名などを算出する
if($meta){

  $basenames = urlToBasename($meta["url"]);

  $sanititle = str_replace(" ","_",
               str_replace(".","_",
               str_replace("/","_",
               str_replace("\\","_",
               str_replace("?","_",
               str_replace("*","_",
               str_replace(":","_",
               str_replace("|","_",
               str_replace('"',"_",
               str_replace('<',"_",
               str_replace('>',"_",
                 $meta["title"]
                 )))))))))));

  preg_match("/([0-9]+).htm/i", $meta["url"], $m);
  $threadid = $m[1] ;

  $zippath   = readConfig("ZIPDIR") . $basenames["ZIP"];
  $zipnames[] = $basenames["ZIP"];
  //$zipnames[] = $sanititle . ".zip";
  //$zipnames[] = date("ymd", $meta["date"]) . "_" . $sanititle . ".zip";
  $zipnames[] = date("ymd", $meta["date"]) . "_" . $threadid  . "_" . $sanititle . ".zip";

  $mhtpath   = readConfig("ZIPDIR") . $basenames["MHT"];
  $mhtnames[] = $basenames["MHT"];
  //$mhtnames[] = $sanititle . ".mht";
  //$mhtnames[] = date("ymd", $meta["date"]) . "_" . $sanititle . ".mht";
  $mhtnames[] = date("ymd", $meta["date"]) . "_" . $threadid  . "_" . $sanititle . ".mht";
}

if(!isset($_GET["type"])){
 if($meta){
  //短縮urlの生成

  $shortdir  = $ROOTDIR . "l/"; //リンク格納先
  $shorturlb = get_current_uri_dir() . "l/";
  $myurl     = "../" . $meta["store_url"];

  $shortly   = shortly_url($myurl,$shortdir,$shorturlb);

  //metaデータの更新
  if(!in_array($shortly[1], $meta['samefiles'])) {
    $meta['samefiles'][] = $shortly[1];
    saveInfo($meta);
  }

  //--------------------------------------------
  //ページの表示

  $smarty = new Smarty();

  $smarty->assign('title',  readConfig("TITLE") );
  $smarty->assign('infotable', _echoResultTable($meta, false));
  $smarty->assign('shortly', $shortly[0]);
  $smarty->assign('USEZIP', readConfig("USEZIP"));
  $smarty->assign('zipnames', $zipnames);
  $smarty->assign('mhtnames', $mhtnames);
  $smarty->assign('meta', $meta);

  $smarty->assign('zipdu', number_format(ceil($meta["du"]/1000/100)*0.1,1) );
  $smarty->assign('mhtdu', number_format(ceil($meta["du"]*1.34/1000/100)*0.1,1) );

  $smarty->display('download.tpl');

  //--------------------------------------------
 }else{ //if($meta) meta情報が読めない場合
  header("HTTP/1.1 404 Not Found");
  echo "404";
 } //if($meta)
}else if($meta){ //if(isset(!$_GET["type"]))
 //zip/mhtファイルを作成して返す

 $DLTYPE = $_GET["type"];
 $DLNAME = $_GET["dlname"];

 if( !in_array($DLTYPE, array("zip","mht"))
  || !(isset($DLTYPE)&&isset($DLNAME)&&readConfig("USEZIP"))){
   //typeかdlnameがない場合は404に飛ばす
   header("HTTP/1.1 404 Not Found");
   echo "404";
   return ;
 }

 if(!$meta['lost'] || readConfig("ZIPONTHEFLY")) {
  //元スレが生存中の場合か
  //ZIPONTHEFLYフラグが有効な場合は
  //zip|mhtファイルをサーバー上に生成せず
  //オンザフライでダウンロードさせる
  header('Content-Type: application/force-download');
  header('Content-disposition: attachment; filename="'.$DLNAME.'"');

  $targetDir = readConfig("CONTDIR") . $basenames["CONT"];
  if($DLTYPE == "zip"){
   pzip_list_stdout($targetDir);
  }
  if($DLTYPE == "mht"){
   //mhtの作成
   $MhtFileMaker = new MhtFileMaker();
   $MhtFileMaker->SetFrom('foobar <foobar@mailinator.com>');
   $MhtFileMaker->SetSubject( $meta['title'] );
   $MhtFileMaker->SetBaseDir($targetDir);
   $MhtFileMaker->SetFirstPage(_PGET_INDEX_PAGE_);
   $MhtFileMaker->AutoAddFiles();
   $MhtFileMaker->MakeFileWithWriter('pzip_stdout_writer','dummy');
  }

 }else{
  //ダウンロードファイルを生成してからダウンロードさせる
  $dlurl  = ""; //ダウンロードurl
  $dlpath = "";
  $dlsize = 0;

  $lockpath = readConfig("LOCKDIR") . $basenames["LOCK"];
  if($lock = fopen($lockpath, 'w')){
    if (flock($lock, LOCK_EX)){
      //------------------------------
      //zip生成
      if($DLTYPE == "zip"){
        $dlurl = readConfig("ZIPURL") . $basenames["ZIP"];

        //zipファイルが無いか古い場合は再作成する
        if(!file_exists($zippath) || $meta["date"] > filemtime($zippath)) {
          //zipの再作成
          $targetDir = readConfig("CONTDIR") .  $basenames["CONT"];

          pzip_dir($targetDir, $zippath);//zip作成
        }
        $dlpath = $zippath;
        $dlsize = filesize($zippath);
      }
      //------------------------------
      //mht生成
      if($DLTYPE == "mht"){
        $dlurl = readConfig("ZIPURL") . $basenames["MHT"];
        $targetDir = readConfig("CONTDIR") .  $basenames["CONT"];

        //mhtファイルが無いか古い場合は再作成する
        if(!file_exists($mhtpath) || $meta["date"] > filemtime($mhtpath)) {
          //mhtの作成
          $MhtFileMaker = new MhtFileMaker();
          $MhtFileMaker->SetFrom('foobar <foobar@mailinator.com>');
          $MhtFileMaker->SetSubject( $meta['title'] );
          $MhtFileMaker->SetBaseDir($targetDir);
          $MhtFileMaker->SetFirstPage(_PGET_INDEX_PAGE_);
          $MhtFileMaker->AutoAddFiles();
          $MhtFileMaker->MakeFile($mhtpath);
        }
        $dlpath = $mhtpath;
        $dlsize = filesize($mhtpath);
      }
      flock($lock, LOCK_UN);
    }
    fclose($lock);
  }

  //------------------------------
  //ヘッダにダウンロード情報を書き出す

  header('Content-Type: application/force-download');
  header('Content-Length: ' . $dlsize);
  header('Content-disposition: attachment; filename="'.$DLNAME.'"');
  
  $last_modified = gmdate( "D, d M Y H:i:s T", $meta['date'] );
  $etag = md5( $last_modified . __FILE__ . $meta["url"] );
  header('Pragma: cache');
  header('Cache-control: public,s-maxage=3600');
  header('Expires: ' . gmdate('D, d M Y H:i:s T', time() + 3600));
  header( "Last-Modified: {$last_modified}" );
  header( "Etag: {$etag}" );
  // リクエストヘッダの If-Modified-Since と If-None-Match を取得
  $if_modified_since = filter_input( INPUT_SERVER, 'HTTP_IF_MODIFIED_SINCE' );
  $if_none_match = filter_input( INPUT_SERVER, 'HTTP_IF_NONE_MATCH' );
  // Last-modified または Etag と一致していたら 304 Not Modified ヘッダを返して終了
  if ( $if_modified_since === $last_modified || $if_none_match === $etag ) {
    header( 'HTTP', true, 304 );
    exit;
  }

  touch($dlpath);
  $mtime = filemtime($dlpath);

  $handle = fopen($dlpath, "rb");
  while(!feof($handle))
  {
      print fread($handle, 262144);
      ob_flush();
      flush();
  }
  fclose($handle);

 } //if(readConfig("ZIPONTHEFLY"))

}  //if(isset($_GET["type"]))
else{
  header("HTTP/1.1 404 Not Found");
}
