<!DOCTYPE html>
<html ng-app='app'>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="Robots" content="NoIndex">

<!-- ver 0.6.5 -->
<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
<!--[if lt IE 9]>
<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<script src="http://css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js"></script>
<![endif]-->

  <link rel="shortcut icon" href="favicon.ico" />
  <title>{$title}</title>
  
  <script src="//ajax.googleapis.com/ajax/libs/angularjs/1.2.26/angular.min.js"></script>
  <script>
    var tagbookstr = '{$tagbook}';
{literal}
    var app=angular.module('app',[]);
    app.filter('encodeURIComponent', function() {
        return window.encodeURIComponent;
    });
    
    app.controller('myControl',['$scope','$http',function($scope,$http){
      $scope.tagbook = JSON.parse(tagbookstr);
      $scope.tagstatus = {};
      for(var url in $scope.tagbook){
        $scope.tagstatus[url] = {
          visible:false,
          inputtext:""
        };
      }
      
      $scope.addtag = function(url, tag){
        if(confirm('「'+tag+'」タグを追加しますか？')) {
          $http({ method:'GET',
            url:'./et.php',
            params:{ url:url, tag:tag }
          }).success(function(data, status, headers, config){
            $scope.tagbook[url].push( {value:tag,owner:true} );
            $scope.tagstatus[url].inputtext = "";
            $scope.tagstatus[url].visible=false;
          }).error(function(data, status, headers, config){
            $scope.tagstatus[url].inputtext = "";
            $scope.tagstatus[url].visible=false;
          });
        }
      };
      
      $scope.deltag = function(url, tag){
        if(confirm('「'+tag+'」タグを削除しますか？')) {
          $http({ method:'GET',
            url:'./et.php',
            params:{ url:url, tag:tag , method:"del" }
          }).success(function(data, status, headers, config){
            var idx = 0;
            while(idx < $scope.tagbook[url].length && $scope.tagbook[url][idx].value != tag){
              idx += 1;
            }
            if( idx < $scope.tagbook[url].length ){
              $scope.tagbook[url].splice(idx,1);
            }
          });
        }
      };
      
    }]);
  </script>
{/literal}
</head>

<body ng-controller="myControl" bgcolor="#FFFFEE" text="#800000" link="#0000EE" vlink="#0000EE" alink="#FF0000">

<datalist id="taglist">
{foreach from=$alltag item=tag }
  <option value="{$tag.name}">
{/foreach}
</datalist>

<!--<h3>{$title}</h3>-->

<div>
<a href="./"><img src="logo.png" alt="ftbucket"></a>
</div>

<em>登録する</em>

<table>
<tr><td>
  <form action="scrapshot.php" method="get" accept-charset="UTF-8">
    <input name="rooturl" type="text" size=50 placeholder="ふたばスレッドのurl" />
    <input type="submit" value="スレッドを登録" />
  </form>
</td></tr>
</table>

<div>
ブックマークレット
<a href="{$bookmarklet}">{$title}で保存</a>
</div>

<!-- 折りたたみ -->
<div onclick="obj=document.getElementById('xxxxx').style; obj.display=(obj.display=='none')?'block':'none';">
<a style="cursor:pointer;"><b>+説明</b></a>
</div>
<!--// 折りたたみ -->
 
<!-- 折りたたまれ -->
<div id="xxxxx" style="display:none;clear:both;">
{php}
  include 'info.txt';
{/php}
</div>

<!--// 折りたたまれ -->

<hr>

<em>検索する</em>

<form action="index.php" method="get">
  
  {if $catalogmode}
    {if $MINICATALOG }
      <input type="hidden" name="mode" value="cm">
    {else}
      <input type="hidden" name="mode" value="c">
    {/if}
  {/if}
  
  {if $USESEARCHSV}
  <input id="ff1" type="radio" name="f" value="0" {if !$fullsv}checked{/if} >
    <label for="ff1">通常検索</label>
  <input id="ff2" type="radio" name="f" value="1" {if $fullsv}checked{/if} >
    <label for="ff2">全レス検索</label>
  <br>
  {/if}
  
  {if $STOCKLIST}
  <input id="fv2" type="radio" name="favo" value="0" {if !$favoarg}checked{/if} >
    <label for="fv2">全件</label>
  <input id="fv1" type="radio" name="favo" value="1" {if $favoarg}checked{/if} >
    <label for="fv1">ストックのみ表示</label>
  <br>
  {/if}
  
  {if $USEWITHFILE}
  <input id="ww1" type="radio" name="w" value="0" {if !$withFile}checked{/if} >
    <label for="ww1">全件</label>
  <input id="ww2" type="radio" name="w" value="1" {if $withFile}checked{/if} >
    <label for="ww2">{$WITHFILE_MSG}</label>
  <br>
  {/if}
  
  {if $USEVIEWORDER}
  <input id="vo1" type="radio" name="ord" value="0" {if !$VIEWORDER}checked{/if} >
    <label for="vo1">更新順</label>
  <input id="vo2" type="radio" name="ord" value="1" {if $VIEWORDER}checked{/if} >
    <label for="vo2">登録順</label>
  <br>
  {/if}
  
  
  <!-- 折りたたみ -->
  <div onclick="obj=document.getElementById('taglists').style; obj.display=(obj.display=='none')?'block':'none';">
  <a style="cursor:pointer;"><b>+タグ一覧</b></a>
  </div>
  <!--// 折りたたみ -->
  <!-- 折りたたまれ -->
  <div id="taglists" style="display:none;clear:both;">
   <div>
   {foreach from=$boardtags item=tag }
     <a href="?s={$tag.name|urlencode}">{$tag.name}({$tag.count})</a>
   {/foreach}
   </div>
   <div>
   {foreach from=$alltag item=tag }
     <a href="?s={$tag.name|urlencode}">{$tag.name}({$tag.count})</a>
   {/foreach}
   </div>
  </div>
  <!--// 折りたたまれ -->
  
  <input type="search" id="searchword" autocomplete="on" list="taglist" name="s" value="{$searchWord}" size=30 
   placeholder="検索ワードを入力"
   >
  
  <input type="submit" value="検索">
  
</form>

<div>保存しているスレッド一覧 ( {$metaInfoListCount} 件
{if $LIMITCAP > 0}
 /最大 {$LIMITCAP} 件
{/if} )

<a href="index.php?mode=l{foreach from=$options item=option}&{$option.key}={$option.value|urlencode}{/foreach}"
>一覧</a>
<a href="index.php?mode=c{foreach from=$options item=option}&{$option.key}={$option.value|urlencode}{/foreach}"
>カタログ</a>(<a href="index.php?mode=cm{foreach from=$options item=option}&{$option.key}={$option.value|urlencode}{/foreach}"
>圧縮</a>)

</div>

{if $catalogmode}
  {include file='index-cat.tpl'}
{else}
  {include file='index-list.tpl'}
{/if}

{$listbody}

{$pager}

total {$totaldu}MB usage

{include file='common-footer.tpl'}

</body>
</html>
